/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.UIutils;

import LinguaView.UIutils.BatchDocument;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class TextComponentLayout {
    private BatchDocument doc;
    private JTextPane Textcomponent;
    private Style tagStyle;
    private Style attributeStyle;
    private Style strStyle;
    private Style normalStyle;
    ArrayList<String> wrdsArray = new ArrayList();
    ArrayList<String> stysArray = new ArrayList();

    public TextComponentLayout() {
        this.tagStyle = this.doc.addStyle("tag_Style", null);
        this.attributeStyle = this.doc.addStyle("attribute_Style", null);
        this.strStyle = this.doc.addStyle("str_Style", null);
    }

    public void setPane(JTextPane Textcomponent) {
        this.Textcomponent = Textcomponent;
    }

    public void linkUp() {
        this.Textcomponent.setDocument(this.doc);
    }

    public TextComponentLayout(JTextPane Textcomponent) {
        this.doc = new BatchDocument();
        this.normalStyle = this.doc.addStyle("normal_Style", null);
        this.tagStyle = this.doc.addStyle("tag_Style", null);
        this.attributeStyle = this.doc.addStyle("attribute_Style", null);
        this.strStyle = this.doc.addStyle("str_Style", null);
        StyleConstants.setForeground(this.normalStyle, Color.black);
        StyleConstants.setForeground(this.tagStyle, Color.getHSBColor(0.6944f, 0.5f, 0.8f));
        StyleConstants.setForeground(this.attributeStyle, Color.getHSBColor(0.5278f, 0.9f, 0.55f));
        StyleConstants.setForeground(this.strStyle, Color.getHSBColor(0.8889f, 0.6f, 1.0f));
        StyleConstants.setBold(this.tagStyle, true);
        StyleConstants.setBold(this.attributeStyle, true);
        StyleConstants.setBold(this.strStyle, true);
        this.doc.addDocumentListener(new ColoringListener());
        this.Textcomponent = Textcomponent;
        this.linkUp();
    }

    public TextComponentLayout(JTextPane Textcomponent, String filename) {
        this.doc = new BatchDocument();
        this.normalStyle = this.doc.addStyle("normal_Style", null);
        this.tagStyle = this.doc.addStyle("tag_Style", null);
        this.attributeStyle = this.doc.addStyle("attribute_Style", null);
        this.strStyle = this.doc.addStyle("str_Style", null);
        StyleConstants.setForeground(this.normalStyle, Color.black);
        StyleConstants.setForeground(this.tagStyle, Color.getHSBColor(0.6944f, 0.5f, 0.8f));
        StyleConstants.setForeground(this.attributeStyle, Color.getHSBColor(0.5278f, 0.9f, 0.55f));
        StyleConstants.setForeground(this.strStyle, Color.getHSBColor(0.8889f, 0.6f, 1.0f));
        StyleConstants.setBold(this.tagStyle, true);
        StyleConstants.setBold(this.attributeStyle, true);
        StyleConstants.setBold(this.strStyle, true);
        this.initColouring(filename);
        this.Textcomponent = Textcomponent;
        this.Textcomponent.setEditable(true);
        this.linkUp();
        this.doc.addDocumentListener(new ColoringListener());
    }

    public void initColouring(String filename) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            String line = in.readLine();
            while (line != null) {
                this.initColouringLineParser(line);
                int j = 0;
                while (j < this.wrdsArray.size()) {
                    if (this.stysArray.get(j).equals("normal")) {
                        this.doc.appendBatchString(this.wrdsArray.get(j), this.normalStyle);
                    } else if (this.stysArray.get(j).equals("tag")) {
                        this.doc.appendBatchString(this.wrdsArray.get(j), this.tagStyle);
                    } else if (this.stysArray.get(j).equals("attribute")) {
                        this.doc.appendBatchString(this.wrdsArray.get(j), this.attributeStyle);
                    } else if (this.stysArray.get(j).equals("str")) {
                        this.doc.appendBatchString(this.wrdsArray.get(j), this.strStyle);
                    }
                    ++j;
                }
                this.doc.appendBatchLineFeed(this.normalStyle);
                this.wrdsArray = new ArrayList();
                this.stysArray = new ArrayList();
                line = in.readLine();
            }
            this.doc.processBatchUpdates(0);
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initColouringLineParser(String line) {
        int state = 0;
        int startpos = 0;
        int endpos = 0;
        int i = 0;
        while (i < line.length()) {
            char ch = line.charAt(i);
            if (state == 0 && ch == '<') {
                state = 1;
                startpos = i;
                if (startpos > 0) {
                    this.wrdsArray.add(line.substring(0, startpos));
                    this.stysArray.add("normal");
                }
            } else if (state == 1 && ch != ' ' && ch != '>') {
                state = 1;
            } else if (state == 1 && ch == ' ') {
                state = 2;
                endpos = i + 1;
                this.wrdsArray.add(line.substring(startpos, endpos));
                this.stysArray.add("tag");
                startpos = i + 1;
            } else if (state == 1 && ch == '>') {
                state = 5;
                endpos = i + 1;
                this.wrdsArray.add(line.substring(startpos, endpos));
                this.stysArray.add("tag");
                startpos = i + 1;
            } else if (state == 2 && ch != '\"' && ch != '>') {
                state = 2;
            } else if (state == 2 && ch == '\"') {
                state = 3;
                endpos = i;
                this.wrdsArray.add(line.substring(startpos, endpos));
                this.stysArray.add("attribute");
                startpos = i;
            } else if (state == 2 && ch == '>') {
                state = 5;
                endpos = i + 1;
                this.wrdsArray.add(line.substring(startpos, endpos));
                this.stysArray.add("tag");
                startpos = i + 1;
            } else if (state == 3 && ch != '\"' && ch != '>') {
                state = 3;
            } else if (state == 3 && ch == '\"') {
                state = 4;
                endpos = i + 1;
                this.wrdsArray.add(line.substring(startpos, endpos));
                this.stysArray.add("str");
                startpos = i + 1;
            } else if (state == 3 && ch == '>') {
                state = 5;
                endpos = i + 1;
                this.wrdsArray.add(line.substring(startpos, endpos));
                this.stysArray.add("tag");
                startpos = i + 1;
            } else if (state == 4 && ch != ' ' && ch != '\n' && ch != '\t' && ch != '>') {
                state = 2;
            } else if (state == 4 && (ch == ' ' || ch == '\n' || ch == '\t')) {
                state = 4;
            } else if (state == 4 && ch == '>') {
                state = 5;
                endpos = i + 1;
                this.wrdsArray.add(line.substring(startpos, endpos));
                this.stysArray.add("tag");
                startpos = i + 1;
            } else if (state == 5 && ch != '<') {
                state = 5;
            } else if (state == 5 && ch == '<') {
                state = 1;
                endpos = i + 1;
                this.wrdsArray.add(line.substring(startpos, endpos));
                this.stysArray.add("normal");
                startpos = i + 1;
            }
            ++i;
        }
        if (endpos < line.length()) {
            this.wrdsArray.add(line.substring(endpos, line.length()));
            this.stysArray.add("normal");
        }
    }

    class ColoringListener
    implements DocumentListener {
        ColoringListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            try {
                this.colouring((StyledDocument)e.getDocument(), e.getOffset(), e.getLength());
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            try {
                this.colouring((StyledDocument)e.getDocument(), e.getOffset(), 0);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }

        public void colouring(StyledDocument doc, int pos, int len) throws BadLocationException {
            int start = this.indexOfWordStart(doc, pos);
            int end = this.indexOfWordEnd(doc, pos + len);
            while (start < end) {
                char ch = this.getCharAt(doc, start);
                if (ch == '<') {
                    start = this.colouringWord(doc, start);
                    continue;
                }
                if (ch == '>') {
                    ++start;
                    start = this.colouringWord(doc, start);
                    continue;
                }
                ++start;
            }
        }

        public int colouringWord(StyledDocument doc, int pos) throws BadLocationException {
            int wordEnd = this.indexOfWordEnd(doc, pos);
            String word = doc.getText(pos, wordEnd - pos + 1);
            int state = 0;
            int startpos = 0;
            int endpos = 0;
            int i = 0;
            while (i < word.length()) {
                char ch = word.charAt(i);
                if (state == 0 && ch == '<') {
                    state = 1;
                    startpos = i;
                    if (startpos > 0) {
                        SwingUtilities.invokeLater(new ColouringTask(doc, pos, startpos, TextComponentLayout.this.normalStyle));
                    }
                } else if (state == 1 && ch != ' ' && ch != '>') {
                    state = 1;
                } else if (state == 1 && ch == ' ') {
                    state = 2;
                    endpos = i;
                    SwingUtilities.invokeLater(new ColouringTask(doc, pos + startpos, endpos - startpos, TextComponentLayout.this.tagStyle));
                    startpos = i + 1;
                } else if (state == 1 && ch == '>') {
                    state = 5;
                    endpos = i + 1;
                    SwingUtilities.invokeLater(new ColouringTask(doc, pos + startpos, endpos - startpos, TextComponentLayout.this.tagStyle));
                    startpos = i + 2;
                } else if (state == 2 && ch != '\"' && ch != '>') {
                    state = 2;
                } else if (state == 2 && ch == '\"') {
                    state = 3;
                    endpos = i - 1;
                    SwingUtilities.invokeLater(new ColouringTask(doc, pos + startpos, endpos - startpos, TextComponentLayout.this.attributeStyle));
                    startpos = i;
                } else if (state == 2 && ch == '>') {
                    state = 5;
                    endpos = i + 1;
                    SwingUtilities.invokeLater(new ColouringTask(doc, pos + startpos, endpos - startpos, TextComponentLayout.this.tagStyle));
                    startpos = i + 2;
                } else if (state == 3 && ch != '\"' && ch != '>') {
                    state = 3;
                } else if (state == 3 && ch == '\"') {
                    state = 4;
                    endpos = i + 1;
                    SwingUtilities.invokeLater(new ColouringTask(doc, pos + startpos, endpos - startpos, TextComponentLayout.this.strStyle));
                    startpos = i + 1;
                } else if (state == 3 && ch == '>') {
                    state = 5;
                    endpos = i + 1;
                    SwingUtilities.invokeLater(new ColouringTask(doc, pos + startpos, endpos - startpos, TextComponentLayout.this.tagStyle));
                    startpos = i + 2;
                } else if (state == 4 && ch != ' ' && ch != '\n' && ch != '\t' && ch != '>') {
                    state = 2;
                    startpos = i;
                } else if (state == 4 && (ch == ' ' || ch == '\n' || ch == '\t')) {
                    state = 4;
                } else if (state == 4 && ch == '>') {
                    state = 5;
                    endpos = i + 1;
                    SwingUtilities.invokeLater(new ColouringTask(doc, pos + startpos, endpos - startpos, TextComponentLayout.this.tagStyle));
                    startpos = i + 2;
                } else if (state == 5 && ch != '<') {
                    state = 5;
                } else if (state == 5 && ch == '<') {
                    state = 5;
                    endpos = i;
                    SwingUtilities.invokeLater(new ColouringTask(doc, pos + startpos, endpos - startpos, TextComponentLayout.this.normalStyle));
                    startpos = i + 1;
                }
                ++i;
            }
            if (endpos < word.length()) {
                SwingUtilities.invokeLater(new ColouringTask(doc, pos + endpos, word.length() - endpos - 1, TextComponentLayout.this.normalStyle));
            }
            return wordEnd;
        }

        public int indexOfWordStart(StyledDocument doc, int pos) throws BadLocationException {
            while (pos > 0 && this.getCharAt(doc, pos) != '<') {
                --pos;
            }
            return pos;
        }

        public int indexOfWordEnd(Document doc, int pos) throws BadLocationException {
            while (pos < doc.getLength() && this.getCharAt(doc, pos) != '>') {
                ++pos;
            }
            return pos;
        }

        public char getCharAt(Document doc, int pos) throws BadLocationException {
            return doc.getText(pos, 1).charAt(0);
        }
    }

    class ColouringTask
    implements Runnable {
        private StyledDocument doc;
        private Style style;
        private int pos;
        private int len;

        public ColouringTask(StyledDocument doc, int pos, int len, Style style) {
            this.doc = doc;
            this.pos = pos;
            this.len = len;
            this.style = style;
        }

        @Override
        public void run() {
            try {
                this.doc.setCharacterAttributes(this.pos, this.len, this.style, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

