/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.syntax;

import LinguaView.syntax.Atomic;
import LinguaView.syntax.Attribute;
import LinguaView.syntax.SemanticForm;
import LinguaView.syntax.SetOfAttributeValueMatrix;
import LinguaView.syntax.Value;
import fig.basic.DeepCloneable;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AttributeValueMatrix
extends Value
implements DeepCloneable<AttributeValueMatrix> {
    private Map<String, Attribute> Attrs = new HashMap<String, Attribute>();
    private Map<Attribute, Value> Pairs = new HashMap<Attribute, Value>();
    private static Map<Integer, AttributeValueMatrix> AVMChart = new HashMap<Integer, AttributeValueMatrix>();
    private Map<Integer, AttributeValueMatrix> Nodes = new HashMap<Integer, AttributeValueMatrix>();
    private static ArrayList<AttributeValueMatrix> Checklist = new ArrayList();
    private ArrayList<AttributeValueMatrix> RefList = new ArrayList();
    private int id = 0;
    private static int LargestID = 0;
    public boolean isContentOrPointer = false;
    public boolean isRealContent = true;
    public boolean isRoot = false;

    public Value getAttributeValue(String AttrName) {
        return this.Pairs.get(this.Attrs.get(AttrName));
    }

    public Set<String> getAllAttributeNames() {
        return this.Attrs.keySet();
    }

    public Set<Value> getAllAttributeValues() {
        return (Set)this.Pairs.values();
    }

    public Collection<AttributeValueMatrix> collectAllNodes() {
        return this.Nodes.values();
    }

    public int countAllNodes() {
        return this.Nodes.size();
    }

    public AttributeValueMatrix getSpecifiedNode(int id) {
        return this.Nodes.get(id);
    }

    public ArrayList<AttributeValueMatrix> getRefList() {
        return this.RefList;
    }

    public static AttributeValueMatrix parseXMLSentence(String xmlString) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
            Document doc = builder.parse(stream);
            Element docRoot = doc.getDocumentElement();
            AttributeValueMatrix root = AttributeValueMatrix.recursiveParse(docRoot);
            for (AttributeValueMatrix avm : Checklist) {
                AttributeValueMatrix content;
                Attribute contentAttr = avm.Attrs.get("content");
                Attribute pointerAttr = avm.Attrs.get("pointer");
                if (AVMChart.get(avm.id) != null) {
                    avm.Pairs.put(pointerAttr, AVMChart.get(avm.id));
                    content = (AttributeValueMatrix)avm.Pairs.get(contentAttr);
                    content.isRealContent = false;
                    avm.Pairs.put(contentAttr, content);
                    avm.id = -(++LargestID);
                    root.RefList.add(avm);
                }
                content = (AttributeValueMatrix)avm.Pairs.get(contentAttr);
                AttributeValueMatrix pointer = (AttributeValueMatrix)avm.Pairs.get(pointerAttr);
                AVMChart.put(avm.id, avm);
                AVMChart.put(content.id, content);
                AVMChart.put(pointer.id, pointer);
            }
            root.isRoot = true;
            root.Nodes.putAll(AVMChart);
            Checklist.clear();
            AVMChart.clear();
            return root;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AttributeValueMatrix parseXMLSentence(List<String> lines) {
        String xmlString = new String();
        for (String line : lines) {
            xmlString = String.valueOf(xmlString) + line;
        }
        return AttributeValueMatrix.parseXMLSentence(xmlString);
    }

    public static AttributeValueMatrix parseXMLSentence(Element e) {
        AttributeValueMatrix res = AttributeValueMatrix.recursiveParse(e);
        for (AttributeValueMatrix avm : Checklist) {
            AttributeValueMatrix content;
            Attribute contentAttr = avm.Attrs.get("content");
            Attribute pointerAttr = avm.Attrs.get("pointer");
            if (AVMChart.get(avm.id) != null) {
                avm.Pairs.put(pointerAttr, AVMChart.get(avm.id));
                content = (AttributeValueMatrix)avm.Pairs.get(contentAttr);
                content.isRealContent = false;
                avm.Pairs.put(contentAttr, content);
                avm.id = -(++LargestID);
                res.RefList.add(avm);
            }
            content = (AttributeValueMatrix)avm.Pairs.get(contentAttr);
            AttributeValueMatrix pointer = (AttributeValueMatrix)avm.Pairs.get(pointerAttr);
            AVMChart.put(avm.id, avm);
            AVMChart.put(content.id, content);
            AVMChart.put(pointer.id, pointer);
        }
        res.isRoot = true;
        res.Nodes.putAll(AVMChart);
        Checklist.clear();
        AVMChart.clear();
        return res;
    }

    private static AttributeValueMatrix recursiveParse(Element e) {
        AttributeValueMatrix res = new AttributeValueMatrix();
        res.id = Integer.parseInt(e.getAttribute("id"));
        LargestID = res.id > LargestID ? res.id : LargestID;
        AttributeValueMatrix content = new AttributeValueMatrix();
        content.isContentOrPointer = true;
        content.isRealContent = true;
        content.id = -(++LargestID);
        AttributeValueMatrix pointer = new AttributeValueMatrix();
        pointer.isContentOrPointer = true;
        pointer.isRealContent = false;
        pointer.id = -(++LargestID);
        NodeList children = e.getChildNodes();
        content.Attrs = new HashMap<String, Attribute>();
        boolean childExists = false;
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                NodeList grandChildren;
                AttributeValueMatrix val;
                childExists = true;
                String attrName = ((Element)child).getAttribute("name");
                String attrValType = ((Element)child).getAttribute("valtype");
                Attribute Attr2 = new Attribute(attrName);
                if (attrValType.trim().equals("fstruct")) {
                    val = null;
                    grandChildren = ((Element)child).getChildNodes();
                    int j = 0;
                    while (j < grandChildren.getLength()) {
                        if (grandChildren.item(j) instanceof Element) {
                            val = AttributeValueMatrix.recursiveParse((Element)grandChildren.item(j));
                            break;
                        }
                        ++j;
                    }
                    content.Pairs.put(Attr2, val);
                } else if (attrValType.trim().equals("set")) {
                    val = new AttributeValueMatrix();
                    SetOfAttributeValueMatrix savm = new SetOfAttributeValueMatrix();
                    NodeList fstructNodes = child.getChildNodes();
                    int j = 0;
                    while (j < fstructNodes.getLength()) {
                        if (fstructNodes.item(j) instanceof Element) {
                            val = AttributeValueMatrix.recursiveParse((Element)fstructNodes.item(j));
                            savm.addAVM(val);
                        }
                        ++j;
                    }
                    content.Pairs.put(Attr2, savm);
                } else if (attrValType.trim().equals("sem")) {
                    SemanticForm sem = new SemanticForm();
                    CharacterData TextNode = null;
                    NodeList grandChildren2 = ((Element)child).getChildNodes();
                    int j = 0;
                    while (j < grandChildren2.getLength()) {
                        if (grandChildren2.item(j) instanceof Text) {
                            TextNode = (Text)grandChildren2.item(j);
                            break;
                        }
                        ++j;
                    }
                    String text = TextNode.getData().trim();
                    if (text.indexOf(40) != -1) {
                        String[] args;
                        sem.setPred(text.substring(text.indexOf(39) + 1, text.indexOf(40)));
                        text = text.substring(text.indexOf(40) + 1, text.lastIndexOf(41));
                        String[] stringArray = args = text.split(",");
                        int n = args.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String arg = stringArray[n2];
                            sem.addArgs(arg.trim());
                            ++n2;
                        }
                    } else if (text.indexOf(39) != -1) {
                        text = text.substring(text.indexOf(39) + 1, text.lastIndexOf(39));
                        sem.setPred(text);
                    } else {
                        sem.setPred(text);
                    }
                    content.Pairs.put(Attr2, sem);
                } else if (attrValType.trim().equals("atomic")) {
                    CharacterData TextNode = null;
                    grandChildren = ((Element)child).getChildNodes();
                    int j = 0;
                    while (j < grandChildren.getLength()) {
                        if (grandChildren.item(j) instanceof Text) {
                            TextNode = (Text)grandChildren.item(j);
                            break;
                        }
                        ++j;
                    }
                    Atomic atom = new Atomic(TextNode.getData().trim());
                    content.Pairs.put(Attr2, atom);
                }
                content.Attrs.put(attrName, Attr2);
            }
            ++i;
        }
        res.Attrs.put("content", new Attribute("content"));
        res.Attrs.put("pointer", new Attribute("pointer"));
        res.Pairs.put(res.Attrs.get("content"), content);
        res.Pairs.put(res.Attrs.get("pointer"), pointer);
        res.isContentOrPointer = false;
        res.isRealContent = true;
        if (!childExists) {
            Checklist.add(res);
        } else {
            AVMChart.put(res.id, res);
            AVMChart.put(content.id, content);
            AVMChart.put(pointer.id, pointer);
        }
        return res;
    }

    public static boolean unify(AttributeValueMatrix f1, AttributeValueMatrix f2) {
        if (f1.isContentOrPointer || f2.isContentOrPointer) {
            return false;
        }
        AttributeValueMatrix f1_real = AttributeValueMatrix.getRealContent(f1);
        AttributeValueMatrix f2_real = AttributeValueMatrix.getRealContent(f2);
        if (f1_real == null) {
            f1.Pairs.put(f1.Attrs.get("pointer"), f2);
            Value f1_content = f1.Pairs.get(f1.Attrs.get("content"));
            if (f1_content instanceof AttributeValueMatrix) {
                ((AttributeValueMatrix)f1_content).isRealContent = false;
                f1.Pairs.put(f1.Attrs.get("content"), f1_content);
            }
            return true;
        }
        if (f2_real == null) {
            f2.Pairs.put(f2.Attrs.get("pointer"), f1);
            Value f2_content = f2.Pairs.get(f2.Attrs.get("content"));
            if (f2_content instanceof AttributeValueMatrix) {
                ((AttributeValueMatrix)f2_content).isRealContent = false;
                f2.Pairs.put(f2.Attrs.get("content"), f2_content);
            }
            return true;
        }
        if (f1_real.equals(f2_real)) {
            f1.Pairs.put(f1.Attrs.get("pointer"), f2);
            Value f1_content = f1.Pairs.get(f1.Attrs.get("content"));
            if (f1_content instanceof AttributeValueMatrix) {
                ((AttributeValueMatrix)f1_content).isRealContent = false;
                f1.Pairs.put(f1.Attrs.get("content"), f1_content);
            }
            return true;
        }
        f2.Pairs.put(f2.Attrs.get("pointer"), f1);
        Value f2_content = f2.Pairs.get(f2.Attrs.get("content"));
        if (f2_content instanceof AttributeValueMatrix) {
            ((AttributeValueMatrix)f2_content).isRealContent = false;
            f2.Pairs.put(f2.Attrs.get("content"), f2_content);
        }
        for (Attribute attr : f2_real.Pairs.keySet()) {
            Value newFeature;
            Attribute otherAttr = f1_real.Attrs.get(attr.getName());
            Value otherFeature = f1_real.Pairs.get(otherAttr);
            Value feature = f2_real.Pairs.get(attr);
            if (feature instanceof AttributeValueMatrix) {
                if (otherFeature == null) {
                    newFeature = new AttributeValueMatrix();
                    ((AttributeValueMatrix)newFeature).isContentOrPointer = false;
                    ((AttributeValueMatrix)newFeature).isRealContent = true;
                    ((AttributeValueMatrix)newFeature).id = -(++LargestID);
                    if (!AttributeValueMatrix.unify((AttributeValueMatrix)feature, (AttributeValueMatrix)newFeature)) {
                        return false;
                    }
                    f1_real.Pairs.put(otherAttr, newFeature);
                    continue;
                }
                if (otherFeature instanceof AttributeValueMatrix) {
                    if (AttributeValueMatrix.unify((AttributeValueMatrix)feature, (AttributeValueMatrix)otherFeature)) continue;
                    return false;
                }
                return false;
            }
            if (feature instanceof SetOfAttributeValueMatrix) {
                if (otherFeature == null) {
                    newFeature = new SetOfAttributeValueMatrix();
                    ((SetOfAttributeValueMatrix)newFeature).addAll((SetOfAttributeValueMatrix)feature);
                    continue;
                }
                if (otherFeature instanceof SetOfAttributeValueMatrix) {
                    SetOfAttributeValueMatrix.union((SetOfAttributeValueMatrix)feature, (SetOfAttributeValueMatrix)otherFeature);
                    continue;
                }
                return false;
            }
            if (feature instanceof Atomic) {
                if (otherFeature == null) {
                    newFeature = new Atomic(((Atomic)feature).getValue());
                    f1_real.Pairs.put(otherAttr, newFeature);
                    continue;
                }
                if (otherFeature instanceof Atomic) {
                    if (((Atomic)feature).equals(otherFeature)) continue;
                    return false;
                }
                return false;
            }
            if (!(feature instanceof SemanticForm)) continue;
            if (otherFeature == null) {
                newFeature = new SemanticForm(((SemanticForm)feature).getPred(), ((SemanticForm)feature).getStringArgs());
                f1_real.Pairs.put(otherAttr, newFeature);
                continue;
            }
            if (otherFeature instanceof SemanticForm) {
                if (((SemanticForm)feature).equals(otherFeature)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static AttributeValueMatrix getRealContent(AttributeValueMatrix f) {
        while (f.Pairs.get(f.Attrs.get("pointer")) instanceof AttributeValueMatrix) {
            AttributeValueMatrix res = (AttributeValueMatrix)f.Pairs.get(f.Attrs.get("pointer"));
            if (!res.isRealContent) {
                res = (AttributeValueMatrix)f.Pairs.get(f.Attrs.get("content"));
                if (res.isContentOrPointer && res.isRealContent) {
                    return (AttributeValueMatrix)f.Pairs.get(f.Attrs.get("content"));
                }
                return null;
            }
            if (res.isContentOrPointer) {
                return (AttributeValueMatrix)f.Pairs.get(f.Attrs.get("pointer"));
            }
            f = (AttributeValueMatrix)f.Pairs.get(f.Attrs.get("pointer"));
        }
        return null;
    }

    public boolean equals(Object other) {
        AttributeValueMatrix otheravm = new AttributeValueMatrix();
        if (!(other instanceof AttributeValueMatrix)) {
            return false;
        }
        otheravm = (AttributeValueMatrix)other;
        if (this.isContentOrPointer && otheravm.isContentOrPointer) {
            for (Attribute key : this.Pairs.keySet()) {
                Attribute otherKey = new Attribute();
                if (!otheravm.Attrs.containsKey(key.getName())) {
                    return false;
                }
                otherKey = otheravm.Attrs.get(key.getName());
                if (!otheravm.Pairs.containsKey(otherKey)) {
                    return false;
                }
                if (otheravm.Pairs.get(otherKey) instanceof Atomic) {
                    if (((Atomic)otheravm.Pairs.get(otherKey)).equals(this.Pairs.get(key))) continue;
                    return false;
                }
                if (otheravm.Pairs.get(otherKey) instanceof SemanticForm) {
                    if (((SemanticForm)otheravm.Pairs.get(otherKey)).equals(this.Pairs.get(key))) continue;
                    return false;
                }
                if (otheravm.Pairs.get(otherKey) instanceof AttributeValueMatrix) {
                    if (!(this.Pairs.get(key) instanceof AttributeValueMatrix)) {
                        return false;
                    }
                    if (((AttributeValueMatrix)this.Pairs.get(key)).equals(otheravm.Pairs.get(otherKey))) continue;
                    return false;
                }
                if (!(otheravm.Pairs.get(otherKey) instanceof SetOfAttributeValueMatrix)) continue;
                if (!(this.Pairs.get(key) instanceof SetOfAttributeValueMatrix)) {
                    return false;
                }
                if (((SetOfAttributeValueMatrix)this.Pairs.get(key)).equals(otheravm.Pairs.get(otherKey))) continue;
                return false;
            }
            return true;
        }
        if (!this.isContentOrPointer && !otheravm.isContentOrPointer) {
            return AttributeValueMatrix.getRealContent(this).equals(AttributeValueMatrix.getRealContent(otheravm));
        }
        return false;
    }

    @Override
    public AttributeValueMatrix deepClone() {
        return this.recursiveClone(this);
    }

    private AttributeValueMatrix recursiveClone(AttributeValueMatrix stub) {
        AttributeValueMatrix res = new AttributeValueMatrix();
        HashMap<String, Attribute> Attrs = new HashMap<String, Attribute>();
        for (String key : stub.Attrs.keySet()) {
            Attribute cloneAttr = new Attribute(stub.Attrs.get(key).getName());
            Attrs.put(key, cloneAttr);
        }
        res.Attrs = Attrs;
        HashMap<Attribute, Value> Pairs = new HashMap<Attribute, Value>();
        for (Attribute attr : stub.Pairs.keySet()) {
            Attribute cloneAttr = res.Attrs.get(attr.getName());
            Value cloneVal = stub.Pairs.get(attr) instanceof AttributeValueMatrix ? this.recursiveClone((AttributeValueMatrix)stub.Pairs.get(attr)) : (stub.Pairs.get(attr) instanceof SetOfAttributeValueMatrix ? this.recursiveClone((SetOfAttributeValueMatrix)stub.Pairs.get(attr)) : (stub.Pairs.get(attr) instanceof SemanticForm ? this.recursiveClone((SemanticForm)stub.Pairs.get(attr)) : this.recursiveClone((Atomic)stub.Pairs.get(attr))));
            Pairs.put(cloneAttr, cloneVal);
        }
        res.Pairs = Pairs;
        res.id = stub.id;
        res.isContentOrPointer = stub.isContentOrPointer;
        res.isRealContent = stub.isRealContent;
        return res;
    }

    private SetOfAttributeValueMatrix recursiveClone(SetOfAttributeValueMatrix stub) {
        SetOfAttributeValueMatrix res = new SetOfAttributeValueMatrix();
        for (AttributeValueMatrix avm : stub.getSet()) {
            res.addAVM(this.recursiveClone(avm));
        }
        return res;
    }

    private SemanticForm recursiveClone(SemanticForm stub) {
        return new SemanticForm(stub.getPred(), stub.getStringArgs());
    }

    private Atomic recursiveClone(Atomic stub) {
        return new Atomic(stub.getValue());
    }

    public static void main(String[] args) {
        try {
            String filename = "wsj001_1.xml";
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ArrayList<String> xmlStringList = new ArrayList<String>();
            String Line = new String();
            Line = in.readLine();
            xmlStringList.add(Line);
            Line = in.readLine();
            boolean addFlag = false;
            while (Line != null) {
                if (Line.trim().equals("<lfg>")) {
                    while (Line != null && !Line.trim().matches("<fstruct *id *= *\"[0-9]\">")) {
                        Line = in.readLine();
                    }
                    addFlag = true;
                }
                if (Line.trim().equals("</lfg>")) {
                    addFlag = false;
                }
                if (addFlag) {
                    xmlStringList.add(Line.trim());
                }
                Line = in.readLine();
            }
            in.close();
            AttributeValueMatrix avm1 = AttributeValueMatrix.parseXMLSentence(xmlStringList);
            AttributeValueMatrix avm2 = avm1.deepClone();
            boolean bl = AttributeValueMatrix.unify(avm1, avm2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

