/*
 * Decompiled with CFR 0.152.
 */
package fig.record;

import fig.record.GlobalEnv;
import fig.record.GnuPlotter;
import fig.record.OffsetReader;
import fig.record.ReceiverInterface;
import java.rmi.RemoteException;

public class CommandEnv {
    private GlobalEnv globalEnv;
    private GnuPlotter plotter;
    private ReceiverInterface receiver;
    private OffsetReader lastReader;

    public CommandEnv(GlobalEnv globalEnv, ReceiverInterface receiver) {
        this.globalEnv = globalEnv;
        this.plotter = new GnuPlotter();
        this.receiver = receiver;
        this.lastReader = null;
        globalEnv.getLoadFileState().init(receiver);
    }

    public void finish() {
        this.globalEnv.getLoadFileState().finish();
    }

    public GlobalEnv getGlobalEnv() {
        return this.globalEnv;
    }

    public GnuPlotter getPlotter() {
        return this.plotter;
    }

    public ReceiverInterface getReceiver() {
        return this.receiver;
    }

    public void sendMandateToReceiver() {
        this.flushPlot();
    }

    public void flushPlot() {
        try {
            this.receiver.executeMandate(this.getPlotter().makeMandate(this.globalEnv.getCleanupMandate()));
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        this.getPlotter().reset();
    }
}

