/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.treeapprox;

import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.treeapprox.DAG2TreeTransformer;
import edu.pku.coli.treeapprox.EisnerDpChart;
import java.util.List;

public class DAG2TreeProjectiveSimple
implements DAG2TreeTransformer {
    private static final int MAXN = 400;
    boolean addMoreLabels;
    PredicateArgumentAdjunctDAG.PredicateArgumentAdjunctArcAdjacencyList[] map;
    PredicateArgumentAdjunctDAG newmap;
    int[] newmapfa = new int[400];
    String[] newmapfalabel = new String[400];
    int len;
    EisnerDpChart eisner = new EisnerDpChart(400);
    int[][] value = new int[400][400];
    private static final int isEdge = 1000000;
    private static final int isForward = 1000;

    public DAG2TreeProjectiveSimple() {
        this.addMoreLabels = false;
    }

    public DAG2TreeProjectiveSimple(boolean morelabels) {
        this.addMoreLabels = morelabels;
    }

    @Override
    public PredicateArgumentAdjunctDAG toDAG(PredicateArgumentAdjunctDAG tree) {
        this.map = tree.getAdjacencyLists();
        this.len = tree.sentenceLength();
        this.newmap = new PredicateArgumentAdjunctDAG(this.len);
        this.toDAGWork();
        return this.newmap;
    }

    private void toDAGWork() {
        int i = 0;
        while (i <= this.len) {
            this.newmapfa[i] = -1;
            ++i;
        }
        int[] queue = new int[400];
        int open = 1;
        int closed = 0;
        queue[1] = 0;
        while (closed < open) {
            int y;
            int x = queue[++closed];
            List<PredicateArgumentAdjunctDAG.ArcInfo> p = this.map[x].getOutArcs();
            for (PredicateArgumentAdjunctDAG.ArcInfo tmp : p) {
                y = tmp.index;
                this.newmapfa[y] = x;
                queue[++open] = y;
            }
            for (PredicateArgumentAdjunctDAG.ArcInfo tmp : p) {
                y = tmp.index;
                this.DealString(x, y, tmp.label);
            }
        }
    }

    private void DealString(int x, int y, String ll) {
        if (ll.equals("None")) {
            return;
        }
        int flag = 0;
        boolean rev = false;
        int tmp = 0;
        ll = String.valueOf(ll) + ";";
        String truelabel = new String();
        int lenll = ll.length();
        char[] tmpc = new char[lenll + 10];
        tmpc = ll.toCharArray();
        int i = 0;
        block6: while (i < lenll) {
            switch (tmpc[i]) {
                case '~': {
                    if (tmpc[i + 1] == 'R') {
                        rev = true;
                        i += 2;
                        break;
                    }
                    truelabel = String.valueOf(truelabel) + tmpc[i];
                    ++i;
                    break;
                }
                case 'R': {
                    if (i == 0) {
                        truelabel = String.valueOf(truelabel) + tmpc[i];
                    }
                    if (i != 0 && tmpc[i - 1] != '~') {
                        truelabel = String.valueOf(truelabel) + tmpc[i];
                    }
                    ++i;
                    break;
                }
                case '!': {
                    if (tmpc[i + 1] == 'f') {
                        flag = 3;
                        i += 2;
                    }
                    if (tmpc[i + 1] == 'g') {
                        flag = 4;
                        i += 2;
                    }
                    if (tmpc[i + 1] != 'b') continue block6;
                    if (tmpc[i + 2] == 'y') {
                        flag = 1;
                        tmp = tmpc[i + 3] - 48;
                        i += 4;
                        break;
                    }
                    flag = 2;
                    tmp = tmpc[i + 3] - 48;
                    i += 4;
                    break;
                }
                case ';': {
                    int lx = x;
                    int ly = y;
                    if (flag >= 3 && lx != -1) {
                        lx = this.newmapfa[lx];
                    }
                    if (flag >= 4 && lx != -1) {
                        lx = this.newmapfa[lx];
                    }
                    if (flag == 1) {
                        lx = this.findEdgeleftrightrank_1(lx, ly, tmp);
                    }
                    if (flag == 2) {
                        lx = this.findEdgeleftrightrank_2(lx, ly, tmp);
                    }
                    if (lx != -1 && !truelabel.equals("None")) {
                        if (rev) {
                            this.newmap.addArc(ly, lx, truelabel);
                        } else {
                            this.newmap.addArc(lx, ly, truelabel);
                        }
                    }
                    rev = false;
                    flag = 0;
                    truelabel = "";
                    ++i;
                    break;
                }
                default: {
                    truelabel = String.valueOf(truelabel) + tmpc[i];
                    ++i;
                }
            }
        }
    }

    private int findEdgeleftrightrank_2(int lx, int ly, int tmp) {
        int help = 0;
        int step = 0 - (ly - lx) / Math.abs(ly - lx);
        int i = lx + step;
        while (i >= 0 && i <= this.len) {
            if (this.newmapfa[i] == lx) {
                ++help;
            }
            if (help == tmp) {
                return i;
            }
            i += step;
        }
        return -1;
    }

    private int findEdgeleftrightrank_1(int lx, int ly, int tmp) {
        int help = 0;
        int step = (ly - lx) / Math.abs(ly - lx);
        int i = lx + step;
        while (i >= 0 && i <= this.len) {
            if (this.newmapfa[i] == lx) {
                ++help;
            }
            if (i == ly) {
                tmp += help;
            }
            if (help == tmp) {
                return i;
            }
            i += step;
        }
        return -1;
    }

    @Override
    public PredicateArgumentAdjunctDAG toTree(PredicateArgumentAdjunctDAG dag) {
        this.map = dag.getAdjacencyLists();
        this.len = dag.sentenceLength();
        this.newmap = new PredicateArgumentAdjunctDAG(this.len);
        this.toTreeWork();
        return this.newmap;
    }

    private void toTreeWork() {
        int i = 0;
        while (i <= this.len) {
            int j = 0;
            while (j <= this.len) {
                this.value[i][j] = 0;
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j <= this.len) {
            this.value[0][j] = -100000000;
            this.value[j][0] = -100000000;
            ++j;
        }
        i = 0;
        while (i <= this.len) {
            List<PredicateArgumentAdjunctDAG.ArcInfo> p = this.map[i].getOutArcs();
            for (PredicateArgumentAdjunctDAG.ArcInfo edge : p) {
                int j2 = edge.index;
                this.value[i][j2] = 1001000 + this.mEdgeValue(i, j2);
                this.value[j2][i] = 1000000 + this.mEdgeValue(j2, i);
            }
            ++i;
        }
        i = 1;
        while (i <= this.len) {
            int j3 = 1;
            while (j3 <= this.len) {
                if (this.value[i][j3] == 0 && i != j3) {
                    this.value[i][j3] = this.mEdgeValue(i, j3);
                }
                ++j3;
            }
            ++i;
        }
        this.eisner.doDynamicProgram(this.len, this.value, -200000000);
        boolean[][] checkedge = this.eisner.getDpMovement(this.len);
        boolean[][] markedge = new boolean[400][400];
        int i2 = 0;
        while (i2 <= this.len) {
            int j4 = 0;
            while (j4 <= this.len) {
                markedge[i2][j4] = false;
                ++j4;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 <= this.len) {
            List<PredicateArgumentAdjunctDAG.ArcInfo> p = this.map[i2].getOutArcs();
            for (PredicateArgumentAdjunctDAG.ArcInfo edge : p) {
                if (checkedge[i2][edge.index]) {
                    this.newmap.addArc(i2, edge.index, edge.label);
                    markedge[i2][edge.index] = true;
                    this.newmapfa[edge.index] = i2;
                    this.newmapfalabel[edge.index] = edge.label;
                }
                if (checkedge[edge.index][i2]) {
                    this.newmap.addArc(edge.index, i2, String.valueOf(edge.label) + "~R");
                    markedge[edge.index][i2] = true;
                    this.newmapfa[i2] = edge.index;
                    this.newmapfalabel[i2] = String.valueOf(edge.label) + "~R";
                }
                checkedge[i2][edge.index] = false;
                checkedge[edge.index][i2] = false;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 <= this.len) {
            int j5 = 0;
            while (j5 <= this.len) {
                if (checkedge[i2][j5]) {
                    this.newmap.addArc(i2, j5, "None");
                    this.newmapfa[j5] = i2;
                    checkedge[i2][j5] = true;
                    this.newmapfalabel[j5] = "None";
                }
                ++j5;
            }
            ++i2;
        }
        if (!this.addMoreLabels) {
            return;
        }
        boolean onlytwo = true;
        int i3 = 0;
        while (i3 <= this.len) {
            List<PredicateArgumentAdjunctDAG.ArcInfo> p = this.map[i3].getOutArcs();
            block21: for (PredicateArgumentAdjunctDAG.ArcInfo nowip : p) {
                if (markedge[i3][nowip.index] || markedge[nowip.index][i3]) continue;
                char addedgetype = DAG2TreeProjectiveSimple.FindRelationship(this.newmap, i3, nowip.index);
                switch (addedgetype) {
                    case 'f': {
                        int comma = this.newmapfalabel[nowip.index].indexOf(";");
                        if (onlytwo && comma != -1) continue block21;
                        this.newmap.removeArc(this.newmapfa[nowip.index], nowip.index);
                        this.newmap.addArc(this.newmapfa[nowip.index], nowip.index, String.valueOf(this.newmapfalabel[nowip.index]) + ";!f" + nowip.label);
                        this.newmapfalabel[nowip.index] = String.valueOf(this.newmapfalabel[nowip.index]) + ";!f" + nowip.label;
                        break;
                    }
                    case 'F': {
                        int comma = this.newmapfalabel[i3].indexOf(";");
                        if (onlytwo && comma != -1) continue block21;
                        this.newmap.removeArc(this.newmapfa[i3], i3);
                        this.newmap.addArc(this.newmapfa[i3], i3, String.valueOf(this.newmapfalabel[i3]) + ";!f" + nowip.label + "~R");
                        this.newmapfalabel[i3] = String.valueOf(this.newmapfalabel[i3]) + ";!f" + nowip.label + "~R";
                        break;
                    }
                    case 'g': {
                        int comma = this.newmapfalabel[nowip.index].indexOf(";");
                        if (onlytwo && comma != -1) continue block21;
                        this.newmap.removeArc(this.newmapfa[nowip.index], nowip.index);
                        this.newmap.addArc(this.newmapfa[nowip.index], nowip.index, String.valueOf(this.newmapfalabel[nowip.index]) + ";!g" + nowip.label);
                        this.newmapfalabel[nowip.index] = String.valueOf(this.newmapfalabel[nowip.index]) + ";!g" + nowip.label;
                        break;
                    }
                    case 'G': {
                        int comma = this.newmapfalabel[i3].indexOf(";");
                        if (onlytwo && comma != -1) continue block21;
                        this.newmap.removeArc(this.newmapfa[i3], i3);
                        this.newmap.addArc(this.newmapfa[i3], i3, String.valueOf(this.newmapfalabel[i3]) + ";!g" + nowip.label + "~R");
                        this.newmapfalabel[i3] = String.valueOf(this.newmapfalabel[i3]) + ";!g" + nowip.label + "~R";
                        break;
                    }
                    case 'b': {
                        int comma;
                        int xrank = this.getEdgeleftrightrank(this.newmapfa[i3], i3);
                        int yrank = this.getEdgeleftrightrank(this.newmapfa[i3], nowip.index);
                        if ((this.newmapfa[i3] - i3) * (this.newmapfa[i3] - nowip.index) > 0) {
                            if (xrank < yrank) {
                                comma = this.newmapfalabel[i3].indexOf(";");
                                if (onlytwo && comma != -1) continue block21;
                                this.newmap.removeArc(this.newmapfa[i3], i3);
                                this.newmap.addArc(this.newmapfa[i3], i3, String.valueOf(this.newmapfalabel[i3]) + ";!by" + Integer.toString(yrank - xrank) + nowip.label + "~R");
                                this.newmapfalabel[i3] = String.valueOf(this.newmapfalabel[i3]) + ";!by" + Integer.toString(yrank - xrank) + nowip.label + "~R";
                                break;
                            }
                            comma = this.newmapfalabel[nowip.index].indexOf(";");
                            if (onlytwo && comma != -1) continue block21;
                            this.newmap.removeArc(this.newmapfa[i3], nowip.index);
                            this.newmap.addArc(this.newmapfa[i3], nowip.index, String.valueOf(this.newmapfalabel[nowip.index]) + ";!by" + Integer.toString(xrank - yrank) + nowip.label);
                            this.newmapfalabel[nowip.index] = String.valueOf(this.newmapfalabel[nowip.index]) + ";!by" + Integer.toString(xrank - yrank) + nowip.label;
                            break;
                        }
                        comma = this.newmapfalabel[nowip.index].indexOf(";");
                        if (onlytwo && comma != -1) continue block21;
                        this.newmap.removeArc(this.newmapfa[nowip.index], nowip.index);
                        this.newmap.addArc(this.newmapfa[nowip.index], nowip.index, String.valueOf(this.newmapfalabel[nowip.index]) + ";!bn" + Integer.toString(xrank) + nowip.label);
                        this.newmapfalabel[nowip.index] = String.valueOf(this.newmapfalabel[nowip.index]) + ";!bn" + Integer.toString(xrank) + nowip.label;
                    }
                }
            }
            ++i3;
        }
    }

    private int getEdgeleftrightrank(int xx, int yy) {
        int step = (yy - xx) / Math.abs(yy - xx);
        int i = xx + step;
        int ret = 0;
        while (i >= 0 && i <= this.len) {
            if (this.newmapfa[i] == xx) {
                ++ret;
            }
            if (i == yy) break;
            i += step;
        }
        return ret;
    }

    private int mEdgeValue(int i, int j) {
        return this.len - Math.abs(i - j);
    }

    private static char FindRelationship(PredicateArgumentAdjunctDAG checkmap, int xx, int yy) {
        int[] xtree = DAG2TreeProjectiveSimple.getDFSback(checkmap, xx);
        int[] ytree = DAG2TreeProjectiveSimple.getDFSback(checkmap, yy);
        int xi = 0;
        int yi = 0;
        int commonfather = 0;
        int xw = -1;
        int yw = -1;
        do {
            if (xtree[xi] == ytree[yi]) {
                commonfather = xi;
            }
            if (xtree[xi] == xx) {
                xw = xi;
            } else {
                ++xi;
            }
            if (ytree[yi] == yy) {
                yw = yi;
                continue;
            }
            ++yi;
        } while (xw == -1 || yw == -1);
        if (xw - commonfather == 0 && yw - commonfather == 2) {
            return 'f';
        }
        if (xw - commonfather == 2 && yw - commonfather == 0) {
            return 'F';
        }
        if (xw - commonfather == 0 && yw - commonfather == 3) {
            return 'g';
        }
        if (xw - commonfather == 3 && yw - commonfather == 0) {
            return 'G';
        }
        if (xw - commonfather == 1 && yw - commonfather == 1) {
            return 'b';
        }
        return 'u';
    }

    private static int[] getDFSback(PredicateArgumentAdjunctDAG checkmap, int xx) {
        int[] ret = new int[400];
        int[] linshi = new int[400];
        int length = 0;
        linshi[0] = xx;
        int xi = xx;
        while (xi != 0) {
            PredicateArgumentAdjunctDAG.ArcInfo arc = checkmap.getAdjacencyLists()[xi].getInArcs().iterator().next();
            xi = arc.index;
            linshi[++length] = xi;
        }
        xi = 0;
        while (xi <= length) {
            ret[xi] = linshi[length - xi];
            ++xi;
        }
        return ret;
    }
}

