/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.data;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import matetools.is2.data.IEncoderPlus;
import matetools.is2.util.DB;

public final class Cluster {
    public static final String LPATH = "LP";
    public static final String SPATH = "SP";
    private final short[][] word2path;

    public Cluster() {
        this.word2path = new short[0][0];
    }

    public Cluster(String clusterFile, IEncoderPlus mf, int ls) {
        String REGEX = "\t";
        try {
            String line;
            BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(clusterFile), "UTF-8"), 32768);
            int cnt = 0;
            while ((line = inputReader.readLine()) != null) {
                ++cnt;
                try {
                    String[] split = line.split("\t");
                    mf.register(SPATH, split[0].length() < ls ? split[0] : split[0].substring(0, ls));
                    mf.register(LPATH, split[0]);
                    mf.register("WORD", split[1]);
                }
                catch (Exception e) {
                    System.out.println("Error in cluster line " + cnt + " error: " + e.getMessage());
                }
            }
            System.out.println("read number of clusters " + cnt);
            inputReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.word2path = new short[mf.getFeatureCounter().get("WORD").intValue()][2];
        try {
            String line;
            BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(clusterFile), "UTF-8"), 32768);
            while ((line = inputReader.readLine()) != null) {
                String[] split = line.split("\t");
                int wd = mf.getValue("WORD", split[1]);
                this.word2path[wd][0] = (short)mf.getValue(SPATH, split[0].length() < ls ? split[0] : split[0].substring(0, ls));
                this.word2path[wd][1] = (short)mf.getValue(LPATH, split[0]);
            }
            inputReader.close();
            int fill = 0;
            int l = 0;
            while (l < this.word2path.length) {
                if (this.word2path[l][0] != 0) {
                    ++fill;
                }
                ++l;
            }
            System.out.println("filled " + fill + " of " + this.word2path.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Cluster(DataInputStream dis) throws IOException {
        this.word2path = new short[dis.readInt()][2];
        int i = 0;
        while (i < this.word2path.length) {
            this.word2path[i][0] = dis.readShort();
            this.word2path[i][1] = dis.readShort();
            ++i;
        }
        DB.println("Read cluster with " + this.word2path.length + " words ");
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.word2path.length);
        short[][] sArray = this.word2path;
        int n = this.word2path.length;
        int n2 = 0;
        while (n2 < n) {
            short[] i = sArray[n2];
            dos.writeShort(i[0]);
            dos.writeShort(i[1]);
            ++n2;
        }
    }

    public final int getLP(int form) {
        if (this.word2path.length <= form || this.word2path[form].length <= 0) {
            return -1;
        }
        return this.word2path[form][0] == 0 ? -1 : this.word2path[form][0];
    }

    public final int getLP(int form, int l) {
        if (this.word2path.length < form) {
            return -1;
        }
        return this.word2path[form][l] == 0 ? -1 : this.word2path[form][l];
    }

    public final int size() {
        return this.word2path.length;
    }
}

