/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import matetools.is2.data.F2SF;
import matetools.is2.data.FV;
import matetools.is2.data.FVR;
import matetools.is2.data.Instances;
import matetools.is2.data.Parse;
import matetools.is2.util.DB;

public final class ParametersFloat {
    public float[] parameters;
    public float[] total;

    public ParametersFloat(int size) {
        this.parameters = new float[size];
        this.total = new float[size];
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = 0.0f;
            this.total[i] = 0.0f;
            ++i;
        }
    }

    public ParametersFloat(float[] p) {
        this.parameters = p;
    }

    public void average(double avVal) {
        int j = 0;
        while (j < this.total.length) {
            this.parameters[j] = this.total[j] / (float)avVal;
            ++j;
        }
        this.total = null;
    }

    public ParametersFloat average2(double avVal) {
        float[] px = new float[this.parameters.length];
        int j = 0;
        while (j < this.total.length) {
            px[j] = this.total[j] / (float)avVal;
            ++j;
        }
        ParametersFloat pf = new ParametersFloat(px);
        return pf;
    }

    public void update(FV pred, FV act, float upd, float err) {
        float lam_dist = act.getScore(this.parameters, false) - pred.getScore(this.parameters, false);
        float loss = err - lam_dist;
        FV dist = act.getDistVector(pred);
        float A = dist.dotProduct(dist);
        float alpha = (double)A <= 1.0E-16 ? 0.0f : loss / A;
        dist.update(this.parameters, this.total, (double)alpha, (double)upd, false);
    }

    public void update(FV pred, FV act, float upd, float err, float C2) {
        float lam_dist = act.getScore(this.parameters, false) - pred.getScore(this.parameters, false);
        float loss = err - lam_dist;
        FV dist = act.getDistVector(pred);
        float A = dist.dotProduct(dist);
        float alpha = (double)A <= 1.0E-16 ? 0.0f : loss / A;
        alpha = Math.min(alpha, C2);
        dist.update(this.parameters, this.total, (double)alpha, (double)upd, false);
    }

    public double update(FV a, double b) {
        double A = a.dotProduct(a);
        if (A <= 1.0E-19) {
            return 0.0;
        }
        return b / A;
    }

    public double getScore(FV fv) {
        if (fv == null) {
            return 0.0;
        }
        return fv.getScore(this.parameters, false);
    }

    public final void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.parameters.length);
        float[] fArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            float d = fArray[n2];
            dos.writeFloat(d);
            ++n2;
        }
    }

    public void read(DataInputStream dis) throws IOException {
        this.parameters = new float[dis.readInt()];
        int notZero = 0;
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = dis.readFloat();
            if (this.parameters[i] != 0.0f) {
                ++notZero;
            }
            ++i;
        }
        DB.println("read parameters " + this.parameters.length + " not zero " + notZero);
    }

    public int countNZ() {
        int notZero = 0;
        int i = 0;
        while (i < this.parameters.length) {
            if (this.parameters[i] != 0.0f) {
                ++notZero;
            }
            ++i;
        }
        return notZero;
    }

    public F2SF getFV() {
        return new F2SF(this.parameters);
    }

    public int size() {
        return this.parameters.length;
    }

    public void update(FVR act, FVR pred, Instances isd, int instc, Parse dx, double upd, double e, float lam_dist) {
        float b = (float)(e += 1.0) - lam_dist;
        FVR dist = act.getDistVector(pred);
        dist.update(this.parameters, this.total, this.hildreth(dist, b), upd, false);
    }

    public void update(FVR pred, FVR act, float upd, float e) {
        float lam_dist = act.getScore(this.parameters, false) - pred.getScore(this.parameters, false);
        float b = (e += 1.0f) - lam_dist;
        FVR dist = act.getDistVector(pred);
        dist.update(this.parameters, this.total, this.hildreth(dist, b), upd, false);
    }

    protected double hildreth(FVR a, double b) {
        double A = a.dotProduct(a);
        if (A <= 1.0E-19) {
            return 0.0;
        }
        return b / A;
    }

    public float getScore(FVR fv) {
        if (fv == null) {
            return 0.0f;
        }
        return fv.getScore(this.parameters, false);
    }
}

