/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.trees.AbstractCollinsHeadFinder;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeVisitor;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Generics;

public class CollinsHeadFinder
extends AbstractCollinsHeadFinder {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final long serialVersionUID = -8747319554557223437L;

    public CollinsHeadFinder() {
        this(new PennTreebankLanguagePack());
    }

    public CollinsHeadFinder(TreebankLanguagePack tlp) {
        this(tlp, EMPTY_STRING_ARRAY);
    }

    public CollinsHeadFinder(TreebankLanguagePack tlp, String ... categoriesToAvoid) {
        super(tlp, categoriesToAvoid);
        this.nonTerminalInfo = Generics.newHashMap();
        this.nonTerminalInfo.put("ADJP", new String[][]{{"left", "NNS", "QP", "NN", "$", "ADVP", "JJ", "VBN", "VBG", "ADJP", "JJR", "NP", "JJS", "DT", "FW", "RBR", "RBS", "SBAR", "RB"}});
        this.nonTerminalInfo.put("ADVP", new String[][]{{"right", "RB", "RBR", "RBS", "FW", "ADVP", "TO", "CD", "JJR", "JJ", "IN", "NP", "JJS", "NN"}});
        this.nonTerminalInfo.put("CONJP", new String[][]{{"right", "CC", "RB", "IN"}});
        this.nonTerminalInfo.put("FRAG", new String[][]{{"right"}});
        this.nonTerminalInfo.put("INTJ", new String[][]{{"left"}});
        this.nonTerminalInfo.put("LST", new String[][]{{"right", "LS", ":"}});
        this.nonTerminalInfo.put("NAC", new String[][]{{"left", "NN", "NNS", "NNP", "NNPS", "NP", "NAC", "EX", "$", "CD", "QP", "PRP", "VBG", "JJ", "JJS", "JJR", "ADJP", "FW"}});
        this.nonTerminalInfo.put("NX", new String[][]{{"left"}});
        this.nonTerminalInfo.put("PP", new String[][]{{"right", "IN", "TO", "VBG", "VBN", "RP", "FW"}});
        this.nonTerminalInfo.put("PRN", new String[][]{{"left"}});
        this.nonTerminalInfo.put("PRT", new String[][]{{"right", "RP"}});
        this.nonTerminalInfo.put("QP", new String[][]{{"left", "$", "IN", "NNS", "NN", "JJ", "RB", "DT", "CD", "NCD", "QP", "JJR", "JJS"}});
        this.nonTerminalInfo.put("RRC", new String[][]{{"right", "VP", "NP", "ADVP", "ADJP", "PP"}});
        this.nonTerminalInfo.put("S", new String[][]{{"left", "TO", "IN", "VP", "S", "SBAR", "ADJP", "UCP", "NP"}});
        this.nonTerminalInfo.put("SBAR", new String[][]{{"left", "WHNP", "WHPP", "WHADVP", "WHADJP", "IN", "DT", "S", "SQ", "SINV", "SBAR", "FRAG"}});
        this.nonTerminalInfo.put("SBARQ", new String[][]{{"left", "SQ", "S", "SINV", "SBARQ", "FRAG"}});
        this.nonTerminalInfo.put("SINV", new String[][]{{"left", "VBZ", "VBD", "VBP", "VB", "MD", "VP", "S", "SINV", "ADJP", "NP"}});
        this.nonTerminalInfo.put("SQ", new String[][]{{"left", "VBZ", "VBD", "VBP", "VB", "MD", "VP", "SQ"}});
        this.nonTerminalInfo.put("UCP", new String[][]{{"right"}});
        this.nonTerminalInfo.put("VP", new String[][]{{"left", "TO", "VBD", "VBN", "MD", "VBZ", "VB", "VBG", "VBP", "AUX", "AUXG", "VP", "ADJP", "NN", "NNS", "NP"}});
        this.nonTerminalInfo.put("WHADJP", new String[][]{{"left", "CC", "WRB", "JJ", "ADJP"}});
        this.nonTerminalInfo.put("WHADVP", new String[][]{{"right", "CC", "WRB"}});
        this.nonTerminalInfo.put("WHNP", new String[][]{{"left", "WDT", "WP", "WP$", "WHADJP", "WHPP", "WHNP"}});
        this.nonTerminalInfo.put("WHPP", new String[][]{{"right", "IN", "TO", "FW"}});
        this.nonTerminalInfo.put("X", new String[][]{{"right"}});
        this.nonTerminalInfo.put("NP", new String[][]{{"rightdis", "NN", "NNP", "NNPS", "NNS", "NX", "POS", "JJR"}, {"left", "NP"}, {"rightdis", "$", "ADJP", "PRN"}, {"right", "CD"}, {"rightdis", "JJ", "JJS", "RB", "QP"}});
        this.nonTerminalInfo.put("TYPO", new String[][]{{"left"}});
        this.nonTerminalInfo.put("EDITED", new String[][]{{"left"}});
        this.nonTerminalInfo.put("XS", new String[][]{{"right", "IN"}});
    }

    @Override
    protected int postOperationFix(int headIdx, Tree[] daughterTrees) {
        String prevLab;
        if (headIdx >= 2 && ((prevLab = this.tlp.basicCategory(daughterTrees[headIdx - 1].value())).equals("CC") || prevLab.equals("CONJP"))) {
            int newHeadIdx;
            Tree t = daughterTrees[newHeadIdx];
            for (newHeadIdx = headIdx - 2; newHeadIdx >= 0 && t.isPreTerminal() && this.tlp.isPunctuationTag(t.value()); --newHeadIdx) {
            }
            if (newHeadIdx >= 0) {
                headIdx = newHeadIdx;
            }
        }
        return headIdx;
    }

    public static void main(String[] args) {
        DiskTreebank treebank = new DiskTreebank();
        CategoryWordTag.suppressTerminalDetails = true;
        treebank.loadPath(args[0]);
        final CollinsHeadFinder chf = new CollinsHeadFinder();
        ((Treebank)treebank).apply(new TreeVisitor(){

            @Override
            public void visitTree(Tree pt) {
                pt.percolateHeads(chf);
                pt.pennPrint();
                System.out.println();
            }
        });
    }
}

