-- This module will transliterate Kyrgyz language text per WT:KY TR.

local export = {}

local tt = {
	["ү"]="ü",['Ү']='Ü',   ["т"]="t",['Т']='T', ["р"]="r",['Р']='R',   ["ф"]="f",['Ф']='F', ["ө"]="ö",['Ө']='Ö',
	["ю"]="yu",['Ю']='Yu', ["ш"]="ş",['Ш']='Ş', ["ь"]="ʹ",['Ь']='ʹ',   ["ъ"]="ʺ",['Ъ']='ʺ', ["н"]="n",['Н']='N', 
	["п"]="p",['П']='P',   ["й"]="y",['Й']='Y', ["л"]="l",['Л']='L',   ["з"]="z",['З']='Z', ["е"]="e",['Е']='E', 
	["г"]="g",['Г']='G',   ["б"]="b",['Б']='B', ["у"]="u",['У']='U',   ["с"]="s",['С']='S', ["х"]="h",['Х']='H',
	["ч"]="ç",['Ч']='Ç', ["щ"]="şç",['Щ']='Şç', ["я"]="ya",['Я']='Ya', ["ы"]="ı",['Ы']='I', ["э"]="e",['Э']='E', 
	["м"]="m",['М']='M',   ["о"]="o",['О']='O', ["и"]="i",['И']='İ', ["ё"]="yo",['Ё']='Yo', ["ж"]="c",['Ж']='C',
	["к"]="k",['К']='K',   ["д"]="d",['Д']='D', ["в"]="v",['В']='V', ["ц"]="ts",['Ц']='Ts', ["а"]="a",['А']='A',
	["ң"]="ñ",['Ң']='Ñ'
};

function export.tr(text, lang, sc)
	text = mw.ustring.gsub(
		text,
		"([АОӨӘУЫЕЯЁЮИЕаоөәуыэяёюиеъь%A][́̀]?)([Ее])",
		function(a,e)
			return a .. ( e == 'е' and 'ye' or 'Ye' )
		end
	)
		:gsub("^Е",'Ye')
		:gsub("^е",'ye');
	
	return (mw.ustring.gsub(text, '.', tt))
end

return export