package translator;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.*;

import edu.illinois.cs.cogcomp.core.datastructures.trees.Tree;
import edu.illinois.cs.cogcomp.edison.sentences.TextAnnotation;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.trees.*;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;

class ParserDemo2 {

	static List<String> getSentencesInLine(String line) {
		Reader reader = new StringReader(line);
		DocumentPreprocessor dp = new DocumentPreprocessor(reader);
		return getStanfordSentences(dp);
	}

	private static List<String> getStanfordSentences(DocumentPreprocessor dp) {
		List<String> sentenceList = new ArrayList<String>();
		for (List<HasWord> sentence : dp) {
			String sentenceString = Sentence.listToString(sentence);
			sentenceList.add(sentenceString.toString());
		}
		return sentenceList;
	}

	/**
	 * This example shows a few more ways of providing input to a parser.
	 *
	 * Usage: ParserDemo2 [grammar [textFile]]
	 */
	public static void main(String[] args) throws IOException {
		String grammar = "edu/stanford/nlp/models/lexparser/germanFactored.ser.gz";
		String[] options = { "-maxLength", "100" ,"-outputFormatOptions","removeTopBracket","-outputFormat","penn"};
		LexicalizedParser lp = LexicalizedParser.loadModel(grammar, options);
		TreebankLanguagePack tlp = lp.getOp().langpack();
		BufferedReader de = new BufferedReader(new InputStreamReader(
				new FileInputStream(args[0]), "UTF8"));

		String line;
		while ((line = de.readLine()) != null) {
			List<String> sentences = getSentencesInLine(line);
			for (String sentence : sentences) {
				edu.stanford.nlp.trees.Tree parse = lp.parse(sentence);
				String tmp = parse.pennString();
				edu.illinois.cs.cogcomp.core.datastructures.trees.Tree<String> mytree = edu.illinois.cs.cogcomp.core.datastructures.trees.Tree
						.readTreeFromString(tmp);
				TextAnnotation ta = GermanPrimeGenerator.handleTree(mytree);
				System.out.print(clean(ta));
			}
			System.out.println();
		}
	}

	private static String clean(TextAnnotation ta) {
		String[] tokens = ta.getTokens();
		String ans="";
		for(int i=1;i<tokens.length;i++)
		{
			ans+=tokens[i]+" ";
		}
		return ans;
	}

}
