# -*- coding: utf-8 -*-

import torch

try:
    major, minor = map(int, torch.__version__.split('.')[:2])
except Exception:
    major = minor = 0

if int(major) <= 1 and int(minor) <= 1:
    import torch.nn as nn

    # there are a lot of bugs in jit script during pytorch 1.1
    ScriptModule = nn.Module

    def script_method(x, _rcb=None):
        return x
else:
    import torch.jit as jit
    ScriptModule = jit.ScriptModule
    script_method = jit.script_method
