## Abstract

The implement of our proposed PCKMT is based on the original implements of:

- adaptive kNN-MT (Xin Zheng et. al. 2021)
- Fairseq and Faiss developed by Facebook Research

## Requirement

- python >= 3.6
- faiss-gpu >= 1.6.5
- fairseq >= 0.10.1
- torch >= 1.5.0
- torch-scatter >= 2.0.5

## Implement

To run our implement, please follow the steps:

1. Follow the code base of (Xin Zheng et. al. 2021) and download the checkpoint of base NMT model released by Facebook github repository.
2. Similarly, download the corpora and test sets as illustrated by (Xin Zheng et. al. 2021) . 
3. Create the original datastore of adaptive kNN-MT.

```shell
. create_datastore.sh
```

4.  (Optional) Modify the script **prune_datastore.py** to fit your datastore (e.g., datadir, datastore size, etc.) and then prune the datastore using the proposed cluster-based algorithm.

```shell
python prune_datastore.py
```

5. Train the Compact Network:

```shell
. knn_align.sh
```

6. Reconstruct the compressed datastore of CKMT

```shell
. create_datastore_knn_align.sh
```

7. Train the quantized index

```
. build_faiss_index_knn_align.sh
```

8. Train the CKMT

```shell
. train_faiss_knn_align.sh
```

9. Evaluation

```shell
. test_adaptive_knn_mt_knn_align.sh
```

