from pprint import pprint
from Questgen import main
import sys
import json
import copy
import os

os.environ['OMP_NUM_THREADS'] = "5"
os.environ['MKL_NUM_THREADS'] = "5"

qg = main.QGen()
input_file = sys.argv[1]
result_file = input_file[:-5]+"-qgai.json"

with open(input_file, "r") as f_in:
    sentence_refs = json.load(f_in)

for qid, sent_ref in sentence_refs.items():
    payload = {"input_text": sent_ref["question"]}
    output = qg.predict_shortq(payload, [sent_ref["ref"]])
    if not output:
        continue
    for qa in output["questions"]:
        if qa["Answer"].lower() == sent_ref["ref"].lower():
            sent_ref["converted_question"] = qa["Question"]

with open(result_file, "w") as f_res:
    json.dump(sentence_refs, f_res, indent=4)

# if len(sys.argv) > 2:
#     output = qg.predict_shortq(payload, [sys.argv[2]])
# else:
#     output = qg.predict_shortq(payload) 
# pprint (output)
