from sentence_transformers import SentenceTransformer, util
from google.colab import files
from scipy import spatial
from csv import reader
import pandas as pd
import io
import numpy as np
import csv
import itertools
out_list=[]
df = pd.read_csv(io.StringIO(uploaded['inputfile_07012021.csv'].decode('utf-8')))
embedder = SentenceTransformer('stsb-xlm-r-multilingual')
for i in range(18937):
  embeddings = embedder.encode([df['synset_eng'].iloc[i],df['synset_hin'].iloc[i],df['synset_mal'].iloc[i]])
  dist_1 = 1-spatial.distance.cosine(embeddings[0], embeddings[1])
  dist_2 = 1-spatial.distance.cosine(embeddings[0], embeddings[2])
  dist_3 = 1-spatial.distance.cosine(embeddings[1], embeddings[2])
  out_list.append([df['indo_id'].iloc[i], dist_1, dist_2, dist_3]) 
   
out=pd.DataFrame(out_list,columns=['id','eng_hin','eng_mal','hin_mal'])   
out.to_csv('outputfile_07012021_1.csv') 
files.download('outputfile_07012021_1.csv')    