**English** | [日本語](クイックスタート)

## Requirement

- [Docker/Docker Compose](https://docs.docker.com/get-docker/)
- [Google Cloud SDK](https://cloud.google.com/sdk/docs/install)
- [Firebase CLI](https://firebase.google.com/docs/cli#install-cli-mac-linux)

## 1. Create a Firebase project

Create from the right link：https://console.firebase.google.com/



## 2. Set up the project

```shell
# Login gcloud
gcloud auth login
# Activate the required api
gcloud services enable firestore.googleapis.com run.googleapis.com cloudbuild.googleapis.com
```

```shell
# Login firebase
firebase login
# Check projects
firebase projects:list
# Set the target project
cd frontend/app
firebase use --add <PROJECT_ID> --alias default
# Create a Web App
firebase apps:create WEB <APP_NAME>
```

- Change the data mode to Native mode on `Firestore Database` .
- Activate Analytics on `Analytics > Dashboard` .
- Set the Default GCP resource location on `Project settings > General` .
- Enable Google as login provider on `Authentication > Sign-in method`.
- Activate "Cloud Run" and "Service Accounts" on [Cloud Build Settings](https://console.cloud.google.com/cloud-build/settings) .



## 3. Backend

```
cd backend/cloud-run-api
```

- Set up `.env` with reference to `.env.example`.

```
GOOGLE_APPLICATION_CREDENTIALS=/root/.config/gcloud/application_default_credentials.json
GOOGLE_CLOUD_PROJECT=<PROJECT_ID>
API_VERSION=1.0.0
API_PROJECT_NAME=fast-annotation-tool-api
APP_URL=https://<PROJECT_ID>.web.app
```

### 3.1 Start up the Local API server

Execute the following command to start the API server (http://localhost:5000/) and the Jupyter server for development (http://localhost:8888/).
For more information on how to use the API, please refer to [this notebook](https://github.com/CyberAgent/fast-annotation-tool/blob/master/backend/cloud-run-api/notebooks/QuickStart-API.ipynb).

```shell
gcloud auth application-default login
make up
```

### 3.2 Upload mock data
Upload the mock data to FireStore to check the operation.

```
make set_demo_tasks
```

### 3.3 Granting Admin privileges
Grant Admin privileges to the user, who can allocate tasks and check the progress on the app.  
(Run it after logging in on the front app.)

```shell
make set_user_role email=<YOUR_EMAIL> role=admin
```

### 3.4 Deploy

```shell
gcloud builds submit --substitutions _PROJECT=<PROJECT_ID>,_APP_URL=<PROJECT_ID>.web.app
```



## 4. Frontend

```
cd frontend
```

- Set up `.env` with reference to `.env.example`.
  - REACT_APP_* is taken from `firebase apps:sdkconfig`.
  - FIREBASE_TOKEN is taken from `firebase login:ci`

```
REACT_APP_DEV_PORT=8080
REACT_APP_PRD_PORT=3000
FIREBASE_TOKEN=*****
REACT_APP_FIREBASE_API_KEY=*****
REACT_APP_FIREBASE_AUTH_DOMAIN=<PROJECT_ID>.firebaseapp.com
REACT_APP_FIREBASE_PROJECT_ID=<PROJECT_ID>
REACT_APP_FIREBASE_MESSAGING_SENDER_ID=*****
REACT_APP_FIREBASE_APP_ID=*****
REACT_APP_MEASUREMENT_ID=*****
```

### 4.1 Initialization

```shell
make init
```

### 4.2 Start up the Local App server

Execute the following command, and then access http://localhost:8080/.

```shell
make up
```

### 4.3 Deploy

Build the app and deploy it to Firebase Hosting.
After deployment, it will work as `<PROJECT_ID>.web.app`.

```shell
make deploy
```

### 4.4 Assign tasks

Log in to the application with the user who has been granted Admin privileges in `3.3 Granting Admin privileges` and jump to the task management screen from the menu. You can see the tasks added in `3.2 Upload mock data`.

![image-20210603000225317](https://tva1.sinaimg.cn/large/008i3skNgy1gr4bk9ofvhj31a20kg0uz.jpg)

Jump to the task detail page, select the unassigned user, and execute the assignment.
The task will be added to the user's main page.

<img src="https://tva1.sinaimg.cn/large/008i3skNgy1gr4foo11c8j30ko10y0u8.jpg" alt="image-20210603022422501" width=300 />