from typing import Dict
from data_structure import DataStruct

class State:

    def __init__(self, structures: Dict[str, DataStruct], init_a: Action, treminal_a: Action):
        self.structures = structures
        self.init_a = init_a
        self.treminal_a = treminal_a

    def initialize(self, instance):
        self.init_a.do(self, instance)

    def is_terminal(self):
        return self.treminal_a.can_do(self)

    def __getitem__(self, key):
        return self.structures.__getitem__(key)