 | Idx | Table      | Column | Primary Key | Foreign Key | 
 | ----------- | ----------- | ----------- | ----------- | ----------- | 
  | 0 |  | * |   |   | 
 | 1 | **airlines** | uid | + | --> 10 | 
 | 2 |   | Airline |   |   | 
 | 3 |   | Abbreviation |   |   | 
 | 4 |   | Country |   |   | 
 | 5 | **airports** | City |   |   | 
 | 6 |   | AirportCode | + | --> 13 | 
 | 7 |   | AirportName |   |   | 
 | 8 |   | Country |   |   | 
 | 9 |   | CountryAbbrev |   |   | 
 | 10 | **flights** | Airline | + | --> 1 | 
 | 11 |   | FlightNo |   |   | 
 | 12 |   | SourceAirport |   |   | 
 | 13 |   | DestAirport |   |   | 
 
  | Index | Question  | SQL | gold QDMR | pred QDMR | Exec | SQL hardness |
  | ----------- | ----------- | ----------- |  ----------- | ----------- | ----------- | ----------- | 
 | SPIDER_dev_179 | Which country does Airline "JetBlue Airways" belong to? | SELECT Country FROM AIRLINES WHERE Airline  =  "JetBlue Airways" | 1. SELECT[val:​airlines:​Airline:​JetBlue Airways] <br>2. PROJECT[col:​airlines:​Country, #1] <br> | 1. SELECT[col:​airlines:​Country] <br>2. PROJECT[tbl:​airlines, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​JetBlue Airways:​col:​airlines:​Airline] <br> | + | easy | 
  | SPIDER_dev_180 | What country is Jetblue Airways affiliated with? | SELECT Country FROM AIRLINES WHERE Airline  =  "JetBlue Airways" | 1. SELECT[val:​airlines:​Airline:​JetBlue Airways] <br>2. PROJECT[col:​airlines:​Country, #1] <br> | 1. SELECT[val:​airlines:​Abbreviation:​JetBlue] <br>2. PROJECT[col:​airlines:​Country, #1] <br> | + | easy | 
  | SPIDER_dev_181 | What is the abbreviation of Airline "JetBlue Airways"? | SELECT Abbreviation FROM AIRLINES WHERE Airline  =  "JetBlue Airways" | 1. SELECT[col:​airlines:​Abbreviation] <br>2. FILTER[#1, comparative:​=:​JetBlue Airways:​col:​airlines:​Airline] <br> | 1. SELECT[tbl:​airlines] <br>2. PROJECT[col:​airlines:​Abbreviation, #1] <br>3. COMPARATIVE[#2, #1, comparative:​=:​JetBlue:​col:​airlines:​Abbreviation] <br> | + | easy | 
  | SPIDER_dev_182 | Which abbreviation corresponds to Jetblue Airways? | SELECT Abbreviation FROM AIRLINES WHERE Airline  =  "JetBlue Airways" | 1. SELECT[val:​airlines:​Airline:​JetBlue Airways] <br>2. PROJECT[col:​airlines:​Abbreviation, #1] <br> | 1. SELECT[col:​airlines:​Abbreviation] <br>2. PROJECT[col:​airlines:​Abbreviation, #1] <br>3. COMPARATIVE[#2, #1, comparative:​=:​JetBlue:​col:​airlines:​Abbreviation] <br> | + | easy | 
  | SPIDER_dev_183 | List all airline names and their abbreviations in "USA". | SELECT Airline ,  Abbreviation FROM AIRLINES WHERE Country  =  "USA" | 1. SELECT[tbl:​airlines] <br>2. PROJECT[col:​airlines:​Airline, #1] <br>3. PROJECT[col:​airlines:​Abbreviation, #2] <br>4. UNION[#2, #3] <br>5. FILTER[#4, comparative:​=:​USA:​col:​airlines:​Country] <br> | 1. SELECT[tbl:​airlines] <br>2. COMPARATIVE[#1, #1, comparative:​=:​USA:​col:​airlines:​Country] <br>3. PROJECT[col:​airlines:​Airline, #2] <br>4. PROJECT[col:​airlines:​Abbreviation, #2] <br>5. UNION[#3, #4] <br> | + | medium | 
  | SPIDER_dev_184 | What are the airline names and abbreviations for airlines in the USA? | SELECT Airline ,  Abbreviation FROM AIRLINES WHERE Country  =  "USA" | 1. SELECT[tbl:​airlines] <br>2. FILTER[#1, comparative:​=:​USA:​col:​airlines:​Country] <br>3. PROJECT[col:​airlines:​Airline, #2] <br>4. PROJECT[col:​airlines:​Abbreviation, #2] <br>5. UNION[#3, #4] <br> | 1. SELECT[tbl:​airlines] <br>2. COMPARATIVE[#1, #1, comparative:​=:​USA:​col:​airlines:​Country] <br>3. PROJECT[col:​airlines:​Airline, #2] <br>4. PROJECT[col:​airlines:​Abbreviation, #2] <br>5. UNION[#3, #4] <br> | + | medium | 
  | SPIDER_dev_185 | List the airport code and name in the city of Anthony. | SELECT AirportCode ,  AirportName FROM AIRPORTS WHERE city  =  "Anthony" | 1. SELECT[tbl:​airports] <br>2. FILTER[#1, comparative:​=:​Anthony:​col:​airports:​City] <br>3. PROJECT[col:​airports:​AirportCode, #2] <br>4. PROJECT[col:​airports:​AirportName, #2] <br>5. UNION[#3, #4] <br> | 1. SELECT[tbl:​airports] <br>2. PROJECT[col:​airports:​City, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Anthony:​col:​airports:​City] <br>4. PROJECT[col:​airports:​AirportCode, #3] <br>5. PROJECT[col:​airports:​AirportName, #3] <br>6. UNION[#4, #5] <br> | + | medium | 
  | SPIDER_dev_186 | Give the airport code and airport name corresonding to the city Anthony. | SELECT AirportCode ,  AirportName FROM AIRPORTS WHERE city  =  "Anthony" | 1. SELECT[val:​airports:​City:​Anthony] <br>2. PROJECT[col:​airports:​AirportCode, #1] <br>3. PROJECT[col:​airports:​AirportName, #1] <br>4. UNION[#2, #3] <br> | 1. SELECT[tbl:​airports] <br>2. PROJECT[col:​airports:​City, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Anthony:​col:​airports:​City] <br>4. PROJECT[col:​airports:​AirportCode, #3] <br>5. PROJECT[col:​airports:​AirportName, #3] <br>6. UNION[#4, #5] <br> | + | medium | 
  | SPIDER_dev_187 | How many airlines do we have? | SELECT count(*) FROM AIRLINES | 1. SELECT[tbl:​airlines] <br>2. AGGREGATE[count, #1] <br> | 1. SELECT[tbl:​airlines] <br>2. AGGREGATE[count, #1] <br> | + | easy | 
  | SPIDER_dev_189 | How many airports do we have? | SELECT count(*) FROM AIRPORTS | 1. SELECT[tbl:​airports] <br>2. AGGREGATE[count, #1] <br> | 1. SELECT[tbl:​airports] <br>2. AGGREGATE[count, #1] <br> | + | easy | 
  | SPIDER_dev_190 | Return the number of  airports. | SELECT count(*) FROM AIRPORTS | 1. SELECT[tbl:​airports] <br>2. AGGREGATE[count, #1] <br> | 1. SELECT[tbl:​airports] <br>2. AGGREGATE[count, #1] <br> | + | easy | 
  | SPIDER_dev_192 | Return the number of flights. | SELECT count(*) FROM FLIGHTS | 1. SELECT[tbl:​flights] <br>2. AGGREGATE[count, #1] <br> | 1. SELECT[tbl:​flights] <br>2. AGGREGATE[count, #1] <br> | + | easy | 
  | SPIDER_dev_193 | Which airline has abbreviation 'UAL'? | SELECT Airline FROM AIRLINES WHERE Abbreviation  =  "UAL" | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[col:​airlines:​Abbreviation, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​UAL:​col:​airlines:​Abbreviation] <br> | 1. SELECT[tbl:​airlines] <br>2. PROJECT[col:​airlines:​Abbreviation, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​UAL:​col:​airlines:​Abbreviation] <br> | - | easy | 
  | SPIDER_dev_194 | Give the airline with abbreviation 'UAL'. | SELECT Airline FROM AIRLINES WHERE Abbreviation  =  "UAL" | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[col:​airlines:​Abbreviation, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​UAL:​col:​airlines:​Abbreviation] <br> | 1. SELECT[tbl:​airlines] <br>2. PROJECT[col:​airlines:​Abbreviation, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​UAL:​col:​airlines:​Abbreviation] <br> | - | easy | 
  | SPIDER_dev_195 | How many airlines are from USA? | SELECT count(*) FROM AIRLINES WHERE Country  =  "USA" | 1. SELECT[tbl:​airlines] <br>2. FILTER[#1, comparative:​=:​USA:​col:​airlines:​Country] <br>3. AGGREGATE[count, #2] <br> | 1. SELECT[tbl:​airlines] <br>2. COMPARATIVE[#1, #1, comparative:​=:​USA:​col:​airlines:​Country] <br>3. AGGREGATE[count, #2] <br> | + | easy | 
  | SPIDER_dev_196 | Return the number of airlines in the USA. | SELECT count(*) FROM AIRLINES WHERE Country  =  "USA" | 1. SELECT[tbl:​airlines] <br>2. FILTER[#1, comparative:​=:​USA:​col:​airlines:​Country] <br>3. AGGREGATE[count, #2] <br> | 1. SELECT[tbl:​airlines] <br>2. COMPARATIVE[#1, #1, comparative:​=:​USA:​col:​airlines:​Country] <br>3. AGGREGATE[count, #2] <br> | + | easy | 
  | SPIDER_dev_197 | Which city and country is the Alton airport at? | SELECT City ,  Country FROM AIRPORTS WHERE AirportName  =  "Alton" | 1. SELECT[val:​airports:​AirportName:​Alton] <br>2. PROJECT[col:​airports:​City, #1] <br>3. PROJECT[col:​airports:​Country, #1] <br>4. UNION[#2, #3] <br> | 1. SELECT[val:​airports:​AirportName:​Alton] <br>2. PROJECT[col:​airports:​City, #1] <br>3. PROJECT[col:​airports:​Country, #1] <br>4. UNION[#2, #3] <br> | + | medium | 
  | SPIDER_dev_198 | Give the city and country for the Alton airport. | SELECT City ,  Country FROM AIRPORTS WHERE AirportName  =  "Alton" | 1. SELECT[val:​airports:​AirportName:​Alton] <br>2. PROJECT[col:​airports:​City, #1] <br>3. PROJECT[col:​airports:​Country, #1] <br>4. UNION[#2, #3] <br> | 1. SELECT[tbl:​airports] <br>2. PROJECT[col:​airports:​City, #1] <br>3. PROJECT[col:​airports:​Country, #1] <br>4. UNION[#2, #3] <br> | - | medium | 
  | SPIDER_dev_199 | What is the airport name for airport 'AKO'? | SELECT AirportName FROM AIRPORTS WHERE AirportCode  =  "AKO" | 1. SELECT[col:​airports:​AirportName] <br>2. PROJECT[tbl:​airports, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​AKO:​col:​airports:​AirportCode] <br> | 1. SELECT[tbl:​airports] <br>2. COMPARATIVE[#1, #1, comparative:​=:​AKO:​col:​airports:​AirportCode] <br>3. PROJECT[col:​airports:​AirportName, #2] <br> | + | easy | 
  | SPIDER_dev_200 | Return the name of the airport with code 'AKO'. | SELECT AirportName FROM AIRPORTS WHERE AirportCode  =  "AKO" | 1. SELECT[tbl:​airports] <br>2. PROJECT[col:​airports:​AirportCode, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​AKO:​col:​airports:​AirportCode] <br>4. PROJECT[col:​airports:​AirportName, #3] <br> | 1. SELECT[tbl:​airports] <br>2. PROJECT[col:​airports:​AirportCode, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​AKO:​col:​airports:​AirportCode] <br>4. PROJECT[col:​airports:​AirportName, #3] <br> | + | easy | 
  | SPIDER_dev_201 | What are airport names at City 'Aberdeen'? | SELECT AirportName FROM AIRPORTS WHERE City = "Aberdeen" | 1. SELECT[val:​airports:​City:​Aberdeen] <br>2. PROJECT[col:​airports:​AirportName, #1] <br> | 1. SELECT[tbl:​airports] <br>2. PROJECT[col:​airports:​City, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Aberdeen:​col:​airports:​City] <br>4. PROJECT[col:​airports:​AirportName, #3] <br> | + | easy | 
  | SPIDER_dev_202 | What are the names of airports in Aberdeen? | SELECT AirportName FROM AIRPORTS WHERE City = "Aberdeen" | 1. SELECT[tbl:​airports] <br>2. FILTER[#1, comparative:​=:​Aberdeen:​col:​airports:​City] <br>3. PROJECT[col:​airports:​AirportName, #2] <br> | 1. SELECT[tbl:​airports] <br>2. COMPARATIVE[#1, #1, comparative:​=:​Aberdeen:​col:​airports:​City] <br>3. PROJECT[col:​airports:​AirportName, #2] <br> | + | easy | 
  | SPIDER_dev_203 | How many flights depart from 'APG'? | SELECT count(*) FROM FLIGHTS WHERE SourceAirport  =  "APG" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​APG:​col:​flights:​SourceAirport] <br>3. AGGREGATE[count, #2] <br> | 1. SELECT[tbl:​flights] <br>2. COMPARATIVE[#1, #1, comparative:​=:​APG:​col:​flights:​DestAirport] <br>3. AGGREGATE[count, #2] <br> | + | easy | 
  | SPIDER_dev_204 | Count the number of flights departing from 'APG'. | SELECT count(*) FROM FLIGHTS WHERE SourceAirport  =  "APG" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​APG:​col:​flights:​SourceAirport] <br>3. AGGREGATE[count, #2] <br> | 1. SELECT[tbl:​flights] <br>2. COMPARATIVE[#1, #1, comparative:​=:​APG:​col:​flights:​DestAirport] <br>3. AGGREGATE[count, #2] <br> | + | easy | 
  | SPIDER_dev_205 | How many flights have destination ATO? | SELECT count(*) FROM FLIGHTS WHERE DestAirport  =  "ATO" | 1. SELECT[tbl:​flights] <br>2. PROJECT[destinations of #REF, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​ATO:​col:​flights:​DestAirport] <br>4. AGGREGATE[count, #3] <br> | 1. SELECT[tbl:​flights] <br>2. PROJECT[col:​flights:​DestAirport, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​ATO:​col:​flights:​DestAirport] <br>4. AGGREGATE[count, #3] <br> | + | easy | 
  | SPIDER_dev_206 | Count the number of flights into ATO. | SELECT count(*) FROM FLIGHTS WHERE DestAirport  =  "ATO" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​ATO:​col:​flights:​DestAirport] <br>3. AGGREGATE[count, #2] <br> | 1. SELECT[tbl:​flights] <br>2. COMPARATIVE[#1, #1, comparative:​=:​ATO:​col:​flights:​SourceAirport] <br>3. AGGREGATE[count, #2] <br> | + | easy | 
  | SPIDER_dev_207 | How many flights depart from City Aberdeen? | SELECT count(*) FROM FLIGHTS AS T1 JOIN AIRPORTS AS T2 ON T1.SourceAirport  =  T2.AirportCode WHERE T2.City  =  "Aberdeen" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​Aberdeen:​col:​airports:​City] <br>3. AGGREGATE[count, #2] <br> | 1. SELECT[tbl:​flights] <br>2. PROJECT[col:​airports:​City, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Aberdeen:​col:​airports:​City] <br>4. AGGREGATE[count, #3] <br> | + | medium | 
  | SPIDER_dev_208 | Return the number of flights departing from Aberdeen. | SELECT count(*) FROM FLIGHTS AS T1 JOIN AIRPORTS AS T2 ON T1.SourceAirport  =  T2.AirportCode WHERE T2.City  =  "Aberdeen" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​Aberdeen:​col:​airports:​City] <br>3. AGGREGATE[count, #2] <br> | 1. SELECT[tbl:​flights] <br>2. COMPARATIVE[#1, #1, comparative:​=:​Aberdeen:​col:​airports:​City] <br>3. AGGREGATE[count, #2] <br> | + | medium | 
  | SPIDER_dev_209 | How many flights arriving in Aberdeen city? | SELECT count(*) FROM FLIGHTS AS T1 JOIN AIRPORTS AS T2 ON T1.DestAirport  =  T2.AirportCode WHERE T2.City  =  "Aberdeen" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​Aberdeen:​col:​airports:​City] <br>3. AGGREGATE[count, #2] <br> | 1. SELECT[tbl:​flights] <br>2. PROJECT[col:​airports:​City, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Aberdeen:​col:​airports:​City] <br>4. AGGREGATE[count, #3] <br> | + | medium | 
  | SPIDER_dev_210 | Return the number of flights arriving in Aberdeen. | SELECT count(*) FROM FLIGHTS AS T1 JOIN AIRPORTS AS T2 ON T1.DestAirport  =  T2.AirportCode WHERE T2.City  =  "Aberdeen" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​Aberdeen:​col:​airports:​City] <br>3. AGGREGATE[count, #2] <br> | 1. SELECT[tbl:​flights] <br>2. COMPARATIVE[#1, #1, comparative:​=:​Aberdeen:​col:​airports:​City] <br>3. AGGREGATE[count, #2] <br> | + | medium | 
  | SPIDER_dev_213 | How many flights does airline 'JetBlue Airways' have? | SELECT count(*) FROM FLIGHTS AS T1 JOIN AIRLINES AS T2 ON T1.Airline  =  T2.uid WHERE T2.Airline = "JetBlue Airways" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​JetBlue Airways:​col:​airlines:​Airline] <br>3. AGGREGATE[count, #2] <br> | 1. SELECT[tbl:​airlines] <br>2. PROJECT[tbl:​flights, #1] <br>3. COMPARATIVE[#2, #1, comparative:​=:​JetBlue Airways:​col:​airlines:​Airline] <br>4. AGGREGATE[count, #3] <br> | + | medium | 
  | SPIDER_dev_214 | Give the number of Jetblue Airways flights. | SELECT count(*) FROM FLIGHTS AS T1 JOIN AIRLINES AS T2 ON T1.Airline  =  T2.uid WHERE T2.Airline = "JetBlue Airways" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​JetBlue Airways:​col:​airlines:​Airline] <br>3. AGGREGATE[count, #2] <br> | 1. SELECT[val:​airlines:​Airline:​JetBlue Airways] <br>2. PROJECT[tbl:​flights, #1] <br>3. AGGREGATE[count, #2] <br> | + | medium | 
  | SPIDER_dev_215 | How many 'United Airlines' flights go to Airport 'ASY'? | SELECT count(*) FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T2.Airline  =  T1.uid WHERE T1.Airline  =  "United Airlines" AND T2.DestAirport  =  "ASY" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​United Airlines:​col:​airlines:​Airline] <br>3. PROJECT[col:​flights:​DestAirport, #2] <br>4. COMPARATIVE[#2, #3, comparative:​=:​ASY:​col:​flights:​DestAirport] <br>5. AGGREGATE[count, #4] <br> | 1. SELECT[val:​airlines:​Airline:​United Airlines] <br>2. PROJECT[tbl:​flights, #1] <br>3. COMPARATIVE[#2, #2, comparative:​=:​ASY:​col:​flights:​SourceAirport] <br>4. AGGREGATE[count, #3] <br> | + | medium | 
  | SPIDER_dev_216 | Count the number of United Airlines flights arriving in ASY Airport. | SELECT count(*) FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T2.Airline  =  T1.uid WHERE T1.Airline  =  "United Airlines" AND T2.DestAirport  =  "ASY" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​United Airlines:​col:​airlines:​Airline] <br>3. FILTER[#2, comparative:​=:​ASY:​col:​flights:​DestAirport] <br>4. AGGREGATE[count, #3] <br> | 1. SELECT[val:​airlines:​Airline:​United Airlines] <br>2. PROJECT[tbl:​flights, #1] <br>3. COMPARATIVE[#2, #2, comparative:​=:​ASY:​col:​flights:​SourceAirport] <br>4. AGGREGATE[count, #3] <br> | + | medium | 
  | SPIDER_dev_217 | How many 'United Airlines' flights depart from Airport 'AHD'? | SELECT count(*) FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T2.Airline  =  T1.uid WHERE T1.Airline  =  "United Airlines" AND T2.SourceAirport  =  "AHD" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​United Airlines:​col:​airlines:​Airline] <br>3. PROJECT[col:​flights:​SourceAirport, #2] <br>4. COMPARATIVE[#2, #3, comparative:​=:​AHD:​col:​flights:​SourceAirport] <br>5. AGGREGATE[count, #4] <br> | 1. SELECT[tbl:​airlines] <br>2. PROJECT[tbl:​flights, #1] <br>3. COMPARATIVE[#2, #1, comparative:​=:​United Airlines:​col:​airlines:​Airline] <br>4. COMPARATIVE[#3, #3, comparative:​=:​AHD:​col:​flights:​SourceAirport] <br>5. AGGREGATE[count, #4] <br> | + | medium | 
  | SPIDER_dev_218 | Return the number of United Airlines flights leaving from AHD Airport. | SELECT count(*) FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T2.Airline  =  T1.uid WHERE T1.Airline  =  "United Airlines" AND T2.SourceAirport  =  "AHD" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​United Airlines:​col:​airlines:​Airline] <br>3. FILTER[#2, comparative:​=:​AHD:​col:​flights:​SourceAirport] <br>4. AGGREGATE[count, #3] <br> | 1. SELECT[val:​airlines:​Airline:​United Airlines] <br>2. PROJECT[tbl:​flights, #1] <br>3. COMPARATIVE[#2, #2, comparative:​=:​AHD:​col:​flights:​SourceAirport] <br>4. AGGREGATE[count, #3] <br> | + | medium | 
  | SPIDER_dev_219 | How many United Airlines flights go to City 'Aberdeen'? | SELECT count(*) FROM FLIGHTS AS T1 JOIN AIRPORTS AS T2 ON T1.DestAirport  =  T2.AirportCode JOIN AIRLINES AS T3 ON T3.uid  =  T1.Airline WHERE T2.City  =  "Aberdeen" AND T3.Airline  =  "United Airlines" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​United Airlines:​col:​airlines:​Airline] <br>3. PROJECT[col:​airports:​City, #2] <br>4. COMPARATIVE[#2, #3, comparative:​=:​Aberdeen:​col:​airports:​City] <br>5. AGGREGATE[count, #4] <br> | 1. SELECT[val:​airlines:​Airline:​United Airlines] <br>2. PROJECT[col:​airports:​City, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Aberdeen:​col:​airports:​City] <br>4. AGGREGATE[count, #3] <br> | + | hard | 
  | SPIDER_dev_220 | Count the number of United Airlines flights that arrive in Aberdeen. | SELECT count(*) FROM FLIGHTS AS T1 JOIN AIRPORTS AS T2 ON T1.DestAirport  =  T2.AirportCode JOIN AIRLINES AS T3 ON T3.uid  =  T1.Airline WHERE T2.City  =  "Aberdeen" AND T3.Airline  =  "United Airlines" | 1. SELECT[val:​airlines:​Airline:​United Airlines] <br>2. PROJECT[tbl:​flights, #1] <br>3. FILTER[#2, comparative:​=:​Aberdeen:​col:​airports:​City] <br>4. AGGREGATE[count, #3] <br> | 1. SELECT[val:​airlines:​Airline:​United Airlines] <br>2. COMPARATIVE[#1, #1, comparative:​=:​United Airlines:​col:​airlines:​Airline] <br>3. AGGREGATE[count, #2] <br> | - | hard | 
  | SPIDER_dev_221 | Which city has most number of arriving flights? | SELECT T1.City FROM AIRPORTS AS T1 JOIN FLIGHTS AS T2 ON T1.AirportCode  =  T2.DestAirport GROUP BY T1.City ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[col:​airports:​City] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br> | 1. SELECT[col:​airports:​City] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br> | + | extra | 
  | SPIDER_dev_225 | What is the code of airport that has the highest number of flights? | SELECT T1.AirportCode FROM AIRPORTS AS T1 JOIN FLIGHTS AS T2 ON T1.AirportCode  =  T2.DestAirport OR T1.AirportCode  =  T2.SourceAirport GROUP BY T1.AirportCode ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[tbl:​airports] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​max:​None] <br>5. PROJECT[col:​airports:​AirportCode, #4] <br> | 1. SELECT[tbl:​airports] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​airports:​AirportCode, #4] <br> | + | extra | 
  | SPIDER_dev_226 | What is the airport code of the airport with the most flights? | SELECT T1.AirportCode FROM AIRPORTS AS T1 JOIN FLIGHTS AS T2 ON T1.AirportCode  =  T2.DestAirport OR T1.AirportCode  =  T2.SourceAirport GROUP BY T1.AirportCode ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[tbl:​airports] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​max:​None] <br>5. PROJECT[col:​airports:​AirportCode, #4] <br> | 1. SELECT[tbl:​airports] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​airports:​AirportCode, #4] <br> | + | extra | 
  | SPIDER_dev_227 | What is the code of airport that has fewest number of flights? | SELECT T1.AirportCode FROM AIRPORTS AS T1 JOIN FLIGHTS AS T2 ON T1.AirportCode  =  T2.DestAirport OR T1.AirportCode  =  T2.SourceAirport GROUP BY T1.AirportCode ORDER BY count(*) LIMIT 1 | 1. SELECT[tbl:​airports] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​min:​None, #1, #3] <br>5. PROJECT[col:​airports:​AirportCode, #4] <br> | 1. SELECT[tbl:​airports] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​min:​None, #1, #3] <br>5. PROJECT[col:​airports:​AirportCode, #4] <br> | + | extra | 
  | SPIDER_dev_228 | Give the code of the airport with the least flights. | SELECT T1.AirportCode FROM AIRPORTS AS T1 JOIN FLIGHTS AS T2 ON T1.AirportCode  =  T2.DestAirport OR T1.AirportCode  =  T2.SourceAirport GROUP BY T1.AirportCode ORDER BY count(*) LIMIT 1 | 1. SELECT[tbl:​airports] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​min:​None, #1, #3] <br>5. PROJECT[col:​airports:​AirportCode, #4] <br> | 1. SELECT[tbl:​airports] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​min:​None, #1, #3] <br>5. PROJECT[col:​airports:​AirportCode, #4] <br> | + | extra | 
  | SPIDER_dev_229 | Which airline has most number of flights? | SELECT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline GROUP BY T1.Airline ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br> | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br> | + | extra | 
  | SPIDER_dev_230 | What airline serves the most flights? | SELECT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline GROUP BY T1.Airline ORDER BY count(*) DESC LIMIT 1 | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br> | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br> | + | extra | 
  | SPIDER_dev_231 | Find the abbreviation and country of the airline that has fewest number of flights? | SELECT T1.Abbreviation ,  T1.Country FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline GROUP BY T1.Airline ORDER BY count(*) LIMIT 1 | 1. SELECT[tbl:​airlines] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​min:​None, #1, #3] <br>5. PROJECT[col:​airlines:​Abbreviation, #4] <br>6. PROJECT[col:​airlines:​Country, #4] <br>7. UNION[#5, #6] <br> | 1. SELECT[tbl:​airlines] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​min:​None, #1, #3] <br>5. PROJECT[col:​airlines:​Abbreviation, #4] <br>6. PROJECT[col:​airlines:​Country, #4] <br>7. UNION[#5, #6] <br> | + | extra | 
  | SPIDER_dev_232 | What is the abbreviation of the airline has the fewest flights and what country is it in? | SELECT T1.Abbreviation ,  T1.Country FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline GROUP BY T1.Airline ORDER BY count(*) LIMIT 1 | 1. SELECT[tbl:​airlines] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​min:​None, #1, #3] <br>5. PROJECT[col:​airlines:​Abbreviation, #4] <br>6. PROJECT[col:​airlines:​Country, #4] <br>7. UNION[#5, #6] <br> | 1. SELECT[tbl:​airlines] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​min:​None, #1, #3] <br>5. PROJECT[col:​airlines:​Abbreviation, #4] <br>6. PROJECT[col:​airlines:​Country, #4] <br>7. UNION[#5, #6] <br> | + | extra | 
  | SPIDER_dev_233 | What are airlines that have some flight departing from airport 'AHD'? | SELECT DISTINCT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline WHERE T2.SourceAirport  =  "AHD" | 1.*(distinct)* SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. PROJECT[col:​flights:​SourceAirport, #2] <br>4. COMPARATIVE[#1, #3, comparative:​=:​AHD:​col:​flights:​SourceAirport] <br> | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​AHD:​col:​flights:​SourceAirport] <br> | + | medium | 
  | SPIDER_dev_234 | Which airlines have a flight with source airport AHD? | SELECT DISTINCT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline WHERE T2.SourceAirport  =  "AHD" | 1.*(distinct)* SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. PROJECT[col:​flights:​SourceAirport, #2] <br>4. COMPARATIVE[#1, #3, comparative:​=:​AHD:​col:​flights:​SourceAirport] <br> | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. PROJECT[col:​flights:​SourceAirport, #2] <br>4. COMPARATIVE[#1, #3, comparative:​=:​AHD:​col:​flights:​SourceAirport] <br> | + | medium | 
  | SPIDER_dev_235 | What are airlines that have flights arriving at airport 'AHD'? | SELECT DISTINCT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline WHERE T2.DestAirport  =  "AHD" | 1.*(distinct)* SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. PROJECT[col:​flights:​DestAirport, #2] <br>4. COMPARATIVE[#1, #3, comparative:​=:​AHD:​col:​flights:​DestAirport] <br> | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​AHD:​col:​flights:​SourceAirport] <br> | + | medium | 
  | SPIDER_dev_236 | Which airlines have a flight with destination airport AHD? | SELECT DISTINCT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline WHERE T2.DestAirport  =  "AHD" | 1. SELECT[tbl:​flights] <br>2. PROJECT[col:​flights:​DestAirport, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​AHD:​col:​flights:​DestAirport] <br>4.*(distinct)* PROJECT[col:​airlines:​Airline, #3] <br> | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. PROJECT[col:​flights:​DestAirport, #2] <br>4. COMPARATIVE[#1, #3, comparative:​=:​AHD:​col:​flights:​DestAirport] <br> | + | medium | 
  | SPIDER_dev_237 | Find all airlines that have flights from both airports 'APG' and 'CVO'. | SELECT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline WHERE T2.SourceAirport  =  "APG" INTERSECT SELECT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline WHERE T2.SourceAirport  =  "CVO" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​APG:​col:​flights:​SourceAirport] <br>3. FILTER[#1, comparative:​=:​CVO:​col:​flights:​SourceAirport] <br>4. PROJECT[col:​airlines:​Airline, #1] <br>5. PROJECT[tbl:​airlines, #2] <br>6. PROJECT[tbl:​airlines, #3] <br>7. INTERSECTION[#4, #5, #6] <br> | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. PROJECT[col:​flights:​SourceAirport, #2] <br>4. COMPARATIVE[#1, #3, comparative:​=:​APG:​col:​flights:​SourceAirport] <br>5. COMPARATIVE[#1, #3, comparative:​=:​CVO:​col:​flights:​SourceAirport] <br>6. INTERSECTION[#1, #4, #5] <br> | + | extra | 
  | SPIDER_dev_238 | Which airlines have departing flights from both APG and CVO airports? | SELECT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline WHERE T2.SourceAirport  =  "APG" INTERSECT SELECT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline WHERE T2.SourceAirport  =  "CVO" | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. PROJECT[col:​flights:​SourceAirport, #2] <br>4. COMPARATIVE[#1, #3, comparative:​=:​APG:​col:​flights:​SourceAirport] <br>5. COMPARATIVE[#1, #3, comparative:​=:​CVO:​col:​flights:​SourceAirport] <br>6. INTERSECTION[#1, #4, #5] <br> | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​APG:​col:​flights:​SourceAirport] <br>4. COMPARATIVE[#1, #2, comparative:​=:​CVO:​col:​flights:​SourceAirport] <br>5. INTERSECTION[#1, #3, #4] <br> | + | extra | 
  | SPIDER_dev_240 | Which airlines have departures from CVO but not from APG airports? | SELECT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline WHERE T2.SourceAirport  =  "CVO" EXCEPT SELECT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline WHERE T2.SourceAirport  =  "APG" | 1. SELECT[col:​airlines:​Airline] <br>2. FILTER[#1, comparative:​=:​CVO:​col:​flights:​SourceAirport] <br>3. FILTER[#2, comparative:​=:​APG:​col:​flights:​SourceAirport] <br>4. DISCARD[#2, #3] <br> | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​airports, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​CVO:​col:​flights:​SourceAirport] <br>4. COMPARATIVE[#1, #2, comparative:​=:​APG:​col:​flights:​SourceAirport] <br>5. INTERSECTION[#1, #3, #4] <br>6. DISCARD[#3, #5] <br> | + | extra | 
  | SPIDER_dev_241 | Find all airlines that have at least 10 flights. | SELECT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline GROUP BY T1.Airline HAVING count(*)  >  10 | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>:​10] <br> | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[sum, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>=:​10:​col:​flights:​FlightNo] <br> | + | medium | 
  | SPIDER_dev_242 | Which airlines have at least 10 flights? | SELECT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline GROUP BY T1.Airline HAVING count(*)  >  10 | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>:​10] <br> | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>=:​10] <br> | + | medium | 
  | SPIDER_dev_243 | Find all airlines that have fewer than 200 flights. | SELECT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline GROUP BY T1.Airline HAVING count(*)  <  200 | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​<:​200] <br> | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​<:​200] <br> | + | medium | 
  | SPIDER_dev_244 | Which airlines have less than 200 flights? | SELECT T1.Airline FROM AIRLINES AS T1 JOIN FLIGHTS AS T2 ON T1.uid  =  T2.Airline GROUP BY T1.Airline HAVING count(*)  <  200 | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​<:​200] <br> | 1. SELECT[col:​airlines:​Airline] <br>2. PROJECT[tbl:​flights, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​<:​200] <br> | + | medium | 
  | SPIDER_dev_245 | What are flight numbers of Airline "United Airlines"? | SELECT T1.FlightNo FROM FLIGHTS AS T1 JOIN AIRLINES AS T2 ON T2.uid  =  T1.Airline WHERE T2.Airline  =  "United Airlines" | 1. SELECT[val:​airlines:​Airline:​United Airlines] <br>2. PROJECT[col:​flights:​FlightNo, #1] <br> | 1. SELECT[tbl:​airlines] <br>2. PROJECT[col:​flights:​FlightNo, #1] <br>3. COMPARATIVE[#2, #1, comparative:​=:​United Airlines:​col:​airlines:​Airline] <br> | + | medium | 
  | SPIDER_dev_246 | Which flight numbers correspond to United Airlines flights? | SELECT T1.FlightNo FROM FLIGHTS AS T1 JOIN AIRLINES AS T2 ON T2.uid  =  T1.Airline WHERE T2.Airline  =  "United Airlines" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​United Airlines:​col:​airlines:​Airline] <br>3. PROJECT[col:​flights:​FlightNo, #2] <br> | 1. SELECT[tbl:​flights] <br>2. PROJECT[tbl:​flights, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​United Airlines:​col:​airlines:​Airline] <br>4. PROJECT[col:​flights:​FlightNo, #3] <br> | + | medium | 
  | SPIDER_dev_247 | What are flight numbers of flights departing from Airport "APG"? | SELECT FlightNo FROM FLIGHTS WHERE SourceAirport  =  "APG" | 1. SELECT[tbl:​flights] <br>2. PROJECT[col:​flights:​SourceAirport, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​APG:​col:​flights:​SourceAirport] <br>4. PROJECT[col:​flights:​FlightNo, #3] <br> | 1. SELECT[tbl:​flights] <br>2. COMPARATIVE[#1, #1, comparative:​=:​APG:​col:​flights:​SourceAirport] <br>3. PROJECT[col:​flights:​FlightNo, #2] <br> | + | easy | 
  | SPIDER_dev_248 | Give the flight numbers of flights leaving from APG. | SELECT FlightNo FROM FLIGHTS WHERE SourceAirport  =  "APG" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​APG:​col:​flights:​SourceAirport] <br>3. PROJECT[col:​flights:​FlightNo, #2] <br> | 1. SELECT[tbl:​flights] <br>2. COMPARATIVE[#1, #1, comparative:​=:​APG:​col:​flights:​SourceAirport] <br>3. PROJECT[col:​flights:​FlightNo, #2] <br> | + | easy | 
  | SPIDER_dev_249 | What are flight numbers of flights arriving at Airport "APG"? | SELECT FlightNo FROM FLIGHTS WHERE DestAirport  =  "APG" | 1. SELECT[tbl:​flights] <br>2. PROJECT[col:​flights:​DestAirport, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​APG:​col:​flights:​DestAirport] <br>4. PROJECT[col:​flights:​FlightNo, #3] <br> | 1. SELECT[tbl:​flights] <br>2. COMPARATIVE[#1, #1, comparative:​=:​APG:​col:​flights:​SourceAirport] <br>3. PROJECT[col:​flights:​FlightNo, #2] <br> | - | easy | 
  | SPIDER_dev_250 | Give the flight numbers of flights landing at APG. | SELECT FlightNo FROM FLIGHTS WHERE DestAirport  =  "APG" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​APG:​col:​flights:​DestAirport] <br>3. PROJECT[col:​flights:​FlightNo, #2] <br> | 1. SELECT[tbl:​flights] <br>2. COMPARATIVE[#1, #1, comparative:​=:​APG:​col:​flights:​DestAirport] <br>3. PROJECT[col:​flights:​FlightNo, #2] <br> | + | easy | 
  | SPIDER_dev_251 | What are flight numbers of flights departing from City "Aberdeen "? | SELECT T1.FlightNo FROM FLIGHTS AS T1 JOIN AIRPORTS AS T2 ON T1.SourceAirport   =  T2.AirportCode WHERE T2.City  =  "Aberdeen" | 1. SELECT[tbl:​flights] <br>2. PROJECT[col:​airports:​City, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Aberdeen:​col:​airports:​City] <br>4. PROJECT[col:​flights:​FlightNo, #3] <br> | 1. SELECT[tbl:​flights] <br>2. PROJECT[col:​airports:​City, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Aberdeen:​col:​airports:​City] <br>4. PROJECT[col:​flights:​FlightNo, #3] <br> | + | medium | 
  | SPIDER_dev_252 | Give the flight numbers of flights leaving from Aberdeen. | SELECT T1.FlightNo FROM FLIGHTS AS T1 JOIN AIRPORTS AS T2 ON T1.SourceAirport   =  T2.AirportCode WHERE T2.City  =  "Aberdeen" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​Aberdeen:​col:​airports:​City] <br>3. PROJECT[col:​flights:​FlightNo, #2] <br> | 1. SELECT[tbl:​flights] <br>2. COMPARATIVE[#1, #1, comparative:​=:​Aberdeen:​col:​airports:​City] <br>3. PROJECT[col:​flights:​FlightNo, #2] <br> | + | medium | 
  | SPIDER_dev_255 | Find the number of flights landing in the city of Aberdeen or Abilene. | SELECT count(*) FROM Flights AS T1 JOIN Airports AS T2 ON T1.DestAirport  =  T2.AirportCode WHERE T2.city  =  "Aberdeen" OR T2.city  =  "Abilene" | 1. SELECT[tbl:​flights] <br>2. PROJECT[col:​airports:​City, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Aberdeen:​col:​airports:​City] <br>4. COMPARATIVE[#1, #2, comparative:​=:​Abilene:​col:​airports:​City] <br>5. UNION[#3, #4] <br>6. AGGREGATE[count, #5] <br> | 1. SELECT[tbl:​flights] <br>2. PROJECT[col:​airports:​City, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Aberdeen:​col:​airports:​City] <br>4. COMPARATIVE[#1, #2, comparative:​=:​Abilene:​col:​airports:​City] <br>5. UNION[#3, #4] <br>6. AGGREGATE[count, #5] <br> | + | hard | 
  | SPIDER_dev_256 | How many flights land in Aberdeen or Abilene? | SELECT count(*) FROM Flights AS T1 JOIN Airports AS T2 ON T1.DestAirport  =  T2.AirportCode WHERE T2.city  =  "Aberdeen" OR T2.city  =  "Abilene" | 1. SELECT[tbl:​flights] <br>2. FILTER[#1, comparative:​=:​Aberdeen:​col:​airports:​City] <br>3. FILTER[#1, comparative:​=:​Abilene:​col:​airports:​City] <br>4. UNION[#2, #3] <br>5. AGGREGATE[count, #4] <br> | 1. SELECT[tbl:​flights] <br>2. COMPARATIVE[#1, #1, comparative:​=:​Aberdeen:​col:​airports:​City] <br>3. COMPARATIVE[#1, #1, comparative:​=:​Abilene:​col:​airports:​City] <br>4. UNION[#2, #3] <br>5. AGGREGATE[count, #4] <br> | + | hard | 
 ***
 Exec acc: **0.9265**
