 | Idx | Table      | Column | Primary Key | Foreign Key | 
 | ----------- | ----------- | ----------- | ----------- | ----------- | 
  | 0 |  | * |   |   | 
 | 1 | **Breeds** | breed_code | + |   | 
 | 2 |   | breed_name |   |   | 
 | 3 | **Charges** | charge_id | + |   | 
 | 4 |   | charge_type |   |   | 
 | 5 |   | charge_amount |   |   | 
 | 6 | **Sizes** | size_code | + |   | 
 | 7 |   | size_description |   |   | 
 | 8 | **Treatment_Types** | treatment_type_code | + |   | 
 | 9 |   | treatment_type_description |   |   | 
 | 10 | **Owners** | owner_id | + |   | 
 | 11 |   | first_name |   |   | 
 | 12 |   | last_name |   |   | 
 | 13 |   | street |   |   | 
 | 14 |   | city |   |   | 
 | 15 |   | state |   |   | 
 | 16 |   | zip_code |   |   | 
 | 17 |   | email_address |   |   | 
 | 18 |   | home_phone |   |   | 
 | 19 |   | cell_number |   |   | 
 | 20 | **Dogs** | dog_id | + |   | 
 | 21 |   | owner_id |   | --> 10 | 
 | 22 |   | abandoned_yn |   |   | 
 | 23 |   | breed_code |   | --> 1 | 
 | 24 |   | size_code |   | --> 6 | 
 | 25 |   | name |   |   | 
 | 26 |   | age |   |   | 
 | 27 |   | date_of_birth |   |   | 
 | 28 |   | gender |   |   | 
 | 29 |   | weight |   |   | 
 | 30 |   | date_arrived |   |   | 
 | 31 |   | date_adopted |   |   | 
 | 32 |   | date_departed |   |   | 
 | 33 | **Professionals** | professional_id | + |   | 
 | 34 |   | role_code |   |   | 
 | 35 |   | first_name |   |   | 
 | 36 |   | street |   |   | 
 | 37 |   | city |   |   | 
 | 38 |   | state |   |   | 
 | 39 |   | zip_code |   |   | 
 | 40 |   | last_name |   |   | 
 | 41 |   | email_address |   |   | 
 | 42 |   | home_phone |   |   | 
 | 43 |   | cell_number |   |   | 
 | 44 | **Treatments** | treatment_id | + |   | 
 | 45 |   | dog_id |   | --> 20 | 
 | 46 |   | professional_id |   | --> 33 | 
 | 47 |   | treatment_type_code |   | --> 8 | 
 | 48 |   | date_of_treatment |   |   | 
 | 49 |   | cost_of_treatment |   |   | 
 
  | Index | Question  | SQL | gold QDMR | pred QDMR | Exec | SQL hardness |
  | ----------- | ----------- | ----------- |  ----------- | ----------- | ----------- | ----------- | 
 | SPIDER_dev_918 | Which states have both owners and professionals living there? | SELECT state FROM Owners INTERSECT SELECT state FROM Professionals |  | 1. SELECT[col:​Owners:​state] <br>2. COMPARATIVE[#1, #1, tbl:​Professionals] <br>3. COMPARATIVE[#1, #1, tbl:​Professionals] <br>4. INTERSECTION[#1, #2, #3] <br> | - | hard | 
  | SPIDER_dev_919 | Find the states where both owners and professionals live. | SELECT state FROM Owners INTERSECT SELECT state FROM Professionals |  | 1. SELECT[col:​Professionals:​state] <br>2. COMPARATIVE[#1, #1, tbl:​Professionals] <br>3. COMPARATIVE[#1, #1, tbl:​Professionals] <br>4. INTERSECTION[#1, #2, #3] <br> | - | hard | 
  | SPIDER_dev_920 | What is the average age of the dogs who have gone through any treatments? | SELECT avg(age) FROM Dogs WHERE dog_id IN ( SELECT dog_id FROM Treatments ) |  | 1. SELECT[tbl:​Dogs] <br>2. COMPARATIVE[#1, #1, tbl:​Treatments] <br>3. PROJECT[col:​Dogs:​age, #2] <br>4. AGGREGATE[avg, #3] <br> | + | hard | 
  | SPIDER_dev_921 | Find the average age of the dogs who went through treatments. | SELECT avg(age) FROM Dogs WHERE dog_id IN ( SELECT dog_id FROM Treatments ) |  | 1. SELECT[tbl:​Dogs] <br>2. COMPARATIVE[#1, #1, tbl:​Treatments] <br>3. PROJECT[col:​Dogs:​age, #2] <br>4. AGGREGATE[avg, #3] <br> | + | hard | 
  | SPIDER_dev_922 | Which professionals live in the state of Indiana or have done treatment on more than 2 treatments? List his or her id, last name and cell phone. | SELECT professional_id ,  last_name ,  cell_number FROM Professionals WHERE state  =  'Indiana' UNION SELECT T1.professional_id ,  T1.last_name ,  T1.cell_number FROM Professionals AS T1 JOIN Treatments AS T2 ON T1.professional_id  =  T2.professional_id GROUP BY T1.professional_id HAVING count(*)  >  2 |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[tbl:​Treatments, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Indiana:​col:​Professionals:​state] <br>4. PROJECT[tbl:​Treatments, #1] <br>5. GROUP[count, #4, #1] <br>6. COMPARATIVE[#1, #5, comparative:​>:​2] <br>7. UNION[#3, #6] <br>8. PROJECT[col:​Professionals:​first_name, #7] <br>9. PROJECT[col:​Professionals:​last_name, #7] <br>10. PROJECT[col:​Professionals:​cell_number, #4] <br>11. UNION[#8, #9, #9] <br> | - | extra | 
  | SPIDER_dev_923 | Find the id, last name and cell phone of the professionals who live in the state of Indiana or have performed more than two treatments. | SELECT professional_id ,  last_name ,  cell_number FROM Professionals WHERE state  =  'Indiana' UNION SELECT T1.professional_id ,  T1.last_name ,  T1.cell_number FROM Professionals AS T1 JOIN Treatments AS T2 ON T1.professional_id  =  T2.professional_id GROUP BY T1.professional_id HAVING count(*)  >  2 |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[tbl:​Treatments, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Indiana:​col:​Professionals:​state] <br>4. PROJECT[tbl:​Treatments, #1] <br>5. GROUP[count, #4, #1] <br>6. COMPARATIVE[#1, #5, comparative:​>:​2] <br>7. UNION[#3, #6] <br>8. PROJECT[col:​Treatments:​professional_id, #7] <br>9. PROJECT[col:​Professionals:​last_name, #8] <br>10. PROJECT[col:​Professionals:​cell_number, #4] <br>11. UNION[#8, #9, #9] <br> | - | extra | 
  | SPIDER_dev_924 | Which dogs have not cost their owner more than 1000 for treatment? List the dog names. | select name from dogs where dog_id not in ( select dog_id from treatments group by dog_id having sum(cost_of_treatment)  >  1000 ) |  | 1. SELECT[tbl:​Dogs] <br>2. PROJECT[tbl:​Treatments, #1] <br>3. COMPARATIVE[#1, #2, comparative:​>:​1000:​col:​Treatments:​cost_of_treatment] <br>4. PROJECT[col:​Dogs:​name, #3] <br> | - | hard | 
  | SPIDER_dev_925 | What are the names of the dogs for which the owner has not spend more than 1000 for treatment? | select name from dogs where dog_id not in ( select dog_id from treatments group by dog_id having sum(cost_of_treatment)  >  1000 ) |  | 1. SELECT[tbl:​Dogs] <br>2. COMPARATIVE[#1, #1, comparative:​>:​1000:​col:​Treatments:​cost_of_treatment] <br>3. PROJECT[tbl:​Dogs, #2] <br> | - | hard | 
  | SPIDER_dev_926 | Which first names are used for professionals or owners but are not used as dog names? | SELECT first_name FROM Professionals UNION SELECT first_name FROM Owners EXCEPT SELECT name FROM Dogs |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[tbl:​Dogs, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, None] <br>5. DISCARD[#1, #4] <br>6. PROJECT[col:​Professionals:​first_name, #5] <br> | - | hard | 
  | SPIDER_dev_927 | Find the first names that are used for professionals or owners but are not used as dog names. | SELECT first_name FROM Professionals UNION SELECT first_name FROM Owners EXCEPT SELECT name FROM Dogs |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[tbl:​Dogs, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, None] <br>5. DISCARD[#1, #4] <br>6. PROJECT[col:​Professionals:​first_name, #5] <br> | - | hard | 
  | SPIDER_dev_928 | Which professional did not operate any treatment on dogs? List the professional's id, role and email. | SELECT professional_id ,  role_code ,  email_address FROM Professionals EXCEPT SELECT T1.professional_id ,  T1.role_code ,  T1.email_address FROM Professionals AS T1 JOIN Treatments AS T2 ON T1.professional_id  =  T2.professional_id |  | 1. SELECT[tbl:​Professionals] <br>2. COMPARATIVE[#1, #1, tbl:​Treatments] <br>3. DISCARD[#1, #2] <br>4. PROJECT[col:​Professionals:​professional_id, #3] <br>5. PROJECT[col:​Professionals:​role_code, #3] <br>6. PROJECT[col:​Professionals:​email_address, #3] <br>7. UNION[#4, #5, #6] <br> | + | extra | 
  | SPIDER_dev_929 | Give me the id, role and email of the professionals who did not perform any treatment on dogs. | SELECT professional_id ,  role_code ,  email_address FROM Professionals EXCEPT SELECT T1.professional_id ,  T1.role_code ,  T1.email_address FROM Professionals AS T1 JOIN Treatments AS T2 ON T1.professional_id  =  T2.professional_id |  | 1. SELECT[tbl:​Professionals] <br>2. COMPARATIVE[#1, #1, tbl:​Treatments] <br>3. DISCARD[#1, #2] <br>4. PROJECT[col:​Professionals:​professional_id, #3] <br>5. PROJECT[col:​Professionals:​role_code, #3] <br>6. PROJECT[col:​Professionals:​email_address, #3] <br>7. UNION[#4, #5, #6] <br> | + | extra | 
  | SPIDER_dev_930 | Which owner owns the most dogs? List the owner id, first name and last name. | SELECT T1.owner_id ,  T2.first_name ,  T2.last_name FROM Dogs AS T1 JOIN Owners AS T2 ON T1.owner_id  =  T2.owner_id GROUP BY T1.owner_id ORDER BY count(*) DESC LIMIT 1 |  | 1. SELECT[tbl:​Owners] <br>2. PROJECT[tbl:​Dogs, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Owners:​owner_id, #4] <br>6. PROJECT[col:​Owners:​first_name, #4] <br>7. PROJECT[col:​Owners:​last_name, #4] <br>8. UNION[#5, #6, #7] <br> | + | extra | 
  | SPIDER_dev_931 | Return the owner id, first name and last name of the owner who has the most dogs. | SELECT T1.owner_id ,  T2.first_name ,  T2.last_name FROM Dogs AS T1 JOIN Owners AS T2 ON T1.owner_id  =  T2.owner_id GROUP BY T1.owner_id ORDER BY count(*) DESC LIMIT 1 |  | 1. SELECT[tbl:​Owners] <br>2. PROJECT[tbl:​Dogs, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Owners:​owner_id, #4] <br>6. PROJECT[col:​Owners:​first_name, #4] <br>7. PROJECT[col:​Owners:​last_name, #4] <br>8. UNION[#5, #6, #7] <br> | + | extra | 
  | SPIDER_dev_932 | Which professionals have done at least two treatments? List the professional's id, role, and first name. | SELECT T1.professional_id ,  T1.role_code ,  T1.first_name FROM Professionals AS T1 JOIN Treatments AS T2 ON T1.professional_id  =  T2.professional_id GROUP BY T1.professional_id HAVING count(*)  >=  2 |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[tbl:​Treatments, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>=:​2] <br>5. PROJECT[col:​Professionals:​professional_id, #4] <br>6. PROJECT[col:​Professionals:​role_code, #4] <br>7. PROJECT[col:​Professionals:​first_name, #4] <br>8. UNION[#5, #6, #7] <br> | + | medium | 
  | SPIDER_dev_933 | What are the id, role, and first name of the professionals who have performed two or more treatments? | SELECT T1.professional_id ,  T1.role_code ,  T1.first_name FROM Professionals AS T1 JOIN Treatments AS T2 ON T1.professional_id  =  T2.professional_id GROUP BY T1.professional_id HAVING count(*)  >=  2 |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[tbl:​Treatments, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>=:​2] <br>5. PROJECT[col:​Treatments:​professional_id, #4] <br>6. PROJECT[col:​Professionals:​role_code, #4] <br>7. PROJECT[col:​Professionals:​first_name, #4] <br>8. UNION[#5, #6, #7] <br> | + | medium | 
  | SPIDER_dev_934 | What is the name of the breed with the most dogs? | SELECT T1.breed_name FROM Breeds AS T1 JOIN Dogs AS T2 ON T1.breed_code  =  T2.breed_code GROUP BY T1.breed_name ORDER BY count(*) DESC LIMIT 1 |  | 1. SELECT[tbl:​Breeds] <br>2. PROJECT[tbl:​Dogs, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Breeds:​breed_name, #4] <br> | + | extra | 
  | SPIDER_dev_935 | Which breed do the most dogs have? Give me the breed name. | SELECT T1.breed_name FROM Breeds AS T1 JOIN Dogs AS T2 ON T1.breed_code  =  T2.breed_code GROUP BY T1.breed_name ORDER BY count(*) DESC LIMIT 1 |  | 1. SELECT[tbl:​Breeds] <br>2. PROJECT[tbl:​Dogs, #1] <br>3. GROUP[count, #1, #2] <br>4. SUPERLATIVE[comparative:​max:​None, #2, #3] <br>5. PROJECT[col:​Breeds:​breed_name, #4] <br> | + | extra | 
  | SPIDER_dev_936 | Which owner has paid for the most treatments on his or her dogs? List the owner id and last name. | SELECT T1.owner_id ,  T1.last_name FROM Owners AS T1 JOIN Dogs AS T2 ON T1.owner_id  =  T2.owner_id JOIN Treatments AS T3 ON T2.dog_id  =  T3.dog_id GROUP BY T1.owner_id ORDER BY count(*) DESC LIMIT 1 |  | 1. SELECT[tbl:​Owners] <br>2. PROJECT[tbl:​Dogs, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Owners:​owner_id, #4] <br>6. PROJECT[col:​Owners:​last_name, #4] <br>7. UNION[#5, #6] <br> | + | extra | 
  | SPIDER_dev_937 | Tell me the owner id and last name of the owner who spent the most on treatments of his or her dogs. | SELECT T1.owner_id ,  T1.last_name FROM Owners AS T1 JOIN Dogs AS T2 ON T1.owner_id  =  T2.owner_id JOIN Treatments AS T3 ON T2.dog_id  =  T3.dog_id GROUP BY T1.owner_id ORDER BY count(*) DESC LIMIT 1 |  | 1. SELECT[tbl:​Owners] <br>2. PROJECT[tbl:​Dogs, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Owners:​owner_id, #4] <br>6. PROJECT[col:​Owners:​last_name, #4] <br>7. UNION[#5, #6] <br> | + | extra | 
  | SPIDER_dev_938 | What is the description of the treatment type that costs the least money in total? | SELECT T1.treatment_type_description FROM Treatment_types AS T1 JOIN Treatments AS T2 ON T1.treatment_type_code  =  T2.treatment_type_code GROUP BY T1.treatment_type_code ORDER BY sum(cost_of_treatment) ASC LIMIT 1 |  | 1. SELECT[tbl:​Treatment_Types] <br>2. PROJECT[col:​Treatments:​cost_of_treatment, #1] <br>3. GROUP[sum, #2, #1] <br>4. SUPERLATIVE[comparative:​min:​None, #1, #3] <br>5. PROJECT[col:​Treatment_Types:​treatment_type_description, #4] <br> | + | extra | 
  | SPIDER_dev_939 | Give me the description of the treatment type whose total cost is the lowest. | SELECT T1.treatment_type_description FROM Treatment_types AS T1 JOIN Treatments AS T2 ON T1.treatment_type_code  =  T2.treatment_type_code GROUP BY T1.treatment_type_code ORDER BY sum(cost_of_treatment) ASC LIMIT 1 |  | 1. SELECT[tbl:​Treatment_Types] <br>2. PROJECT[col:​Treatments:​cost_of_treatment, #1] <br>3. GROUP[sum, #2, #1] <br>4. SUPERLATIVE[comparative:​min:​None, #1, #3] <br>5. PROJECT[col:​Treatment_Types:​treatment_type_description, #4] <br> | + | extra | 
  | SPIDER_dev_940 | Which owner has paid the largest amount of money in total for their dogs? Show the owner id and zip code. | SELECT T1.owner_id ,  T1.zip_code FROM Owners AS T1 JOIN Dogs AS T2 ON T1.owner_id  =  T2.owner_id JOIN Treatments AS T3 ON T2.dog_id  =  T3.dog_id GROUP BY T1.owner_id ORDER BY sum(T3.cost_of_treatment) DESC LIMIT 1 |  | 1. SELECT[tbl:​Owners] <br>2. PROJECT[tbl:​Dogs, #1] <br>3. GROUP[sum, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Owners:​owner_id, #4] <br>6. PROJECT[col:​Owners:​zip_code, #4] <br>7. UNION[#5, #6] <br> | - | extra | 
  | SPIDER_dev_941 | Find the owner id and zip code of the owner who spent the most money in total for his or her dogs. | SELECT T1.owner_id ,  T1.zip_code FROM Owners AS T1 JOIN Dogs AS T2 ON T1.owner_id  =  T2.owner_id JOIN Treatments AS T3 ON T2.dog_id  =  T3.dog_id GROUP BY T1.owner_id ORDER BY sum(T3.cost_of_treatment) DESC LIMIT 1 |  | 1. SELECT[tbl:​Owners] <br>2. PROJECT[tbl:​Dogs, #1] <br>3. GROUP[count, #2, #1] <br>4. SUPERLATIVE[comparative:​max:​None, #1, #3] <br>5. PROJECT[col:​Owners:​owner_id, #4] <br>6. PROJECT[col:​Owners:​zip_code, #4] <br>7. UNION[#5, #6] <br> | - | extra | 
  | SPIDER_dev_942 | Which professionals have done at least two types of treatments? List the professional id and cell phone. | SELECT T1.professional_id ,  T1.cell_number FROM Professionals AS T1 JOIN Treatments AS T2 ON T1.professional_id  =  T2.professional_id GROUP BY T1.professional_id HAVING count(*)  >=  2 |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[tbl:​Treatments, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>=:​2] <br>5. PROJECT[col:​Professionals:​professional_id, #4] <br>6. PROJECT[col:​Professionals:​cell_number, #4] <br>7. UNION[#5, #6] <br> | + | medium | 
  | SPIDER_dev_943 | Find the id and cell phone of the professionals who operate two or more types of treatments. | SELECT T1.professional_id ,  T1.cell_number FROM Professionals AS T1 JOIN Treatments AS T2 ON T1.professional_id  =  T2.professional_id GROUP BY T1.professional_id HAVING count(*)  >=  2 |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[tbl:​Treatments, #1] <br>3. GROUP[count, #2, #1] <br>4. COMPARATIVE[#1, #3, comparative:​>=:​2] <br>5. PROJECT[col:​Treatments:​professional_id, #4] <br>6. PROJECT[col:​Professionals:​cell_number, #4] <br>7. UNION[#5, #6] <br> | + | medium | 
  | SPIDER_dev_944 | What are the first name and last name of the professionals who have done treatment with cost below average? | SELECT DISTINCT T1.first_name ,  T1.last_name FROM Professionals AS T1 JOIN Treatments AS T2 WHERE cost_of_treatment  <  ( SELECT avg(cost_of_treatment) FROM Treatments ) |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[tbl:​Treatments, #1] <br>3. AGGREGATE[avg, #2] <br>4. COMPARATIVE[#1, #2, comparative:​<:​EXAM:​col:​Treatments:​treatment_type_code] <br>5. PROJECT[col:​Professionals:​first_name, #4] <br>6. PROJECT[col:​Professionals:​last_name, #4] <br>7. UNION[#5, #6] <br> | - | extra | 
  | SPIDER_dev_945 | Which professionals have operated a treatment that costs less than the average? Give me theor first names and last names. | SELECT DISTINCT T1.first_name ,  T1.last_name FROM Professionals AS T1 JOIN Treatments AS T2 WHERE cost_of_treatment  <  ( SELECT avg(cost_of_treatment) FROM Treatments ) |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[col:​Treatments:​cost_of_treatment, #1] <br>3. AGGREGATE[avg, #2] <br>4. COMPARATIVE[#1, #2, comparative:​<:​MED:​col:​Dogs:​size_code] <br>5. PROJECT[col:​Professionals:​first_name, #4] <br>6. PROJECT[col:​Professionals:​last_name, #4] <br>7. UNION[#5, #6] <br> | - | extra | 
  | SPIDER_dev_946 | List the date of each treatment, together with the first name of the professional who operated it. | SELECT T1.date_of_treatment ,  T2.first_name FROM Treatments AS T1 JOIN Professionals AS T2 ON T1.professional_id  =  T2.professional_id |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[col:​Treatments:​date_of_treatment, #1] <br>3. PROJECT[col:​Professionals:​first_name, #1] <br>4. UNION[#2, #3] <br> | + | medium | 
  | SPIDER_dev_947 | What are the date and the operating professional's first name of each treatment? | SELECT T1.date_of_treatment ,  T2.first_name FROM Treatments AS T1 JOIN Professionals AS T2 ON T1.professional_id  =  T2.professional_id |  | 1. SELECT[tbl:​Treatments] <br>2. PROJECT[col:​Treatments:​date_of_treatment, #1] <br>3. PROJECT[tbl:​Professionals, #1] <br>4. PROJECT[col:​Professionals:​first_name, #3] <br>5. UNION[#2, #4] <br> | + | medium | 
  | SPIDER_dev_948 | List the cost of each treatment and the corresponding treatment type description. | SELECT T1.cost_of_treatment ,  T2.treatment_type_description FROM Treatments AS T1 JOIN treatment_types AS T2 ON T1.treatment_type_code  =  T2.treatment_type_code |  | 1. SELECT[tbl:​Treatment_Types] <br>2. PROJECT[col:​Treatments:​cost_of_treatment, #1] <br>3. PROJECT[col:​Treatment_Types:​treatment_type_description, #1] <br>4. UNION[#2, #3] <br> | + | medium | 
  | SPIDER_dev_949 | What are the cost and treatment type description of each treatment? | SELECT T1.cost_of_treatment ,  T2.treatment_type_description FROM Treatments AS T1 JOIN treatment_types AS T2 ON T1.treatment_type_code  =  T2.treatment_type_code |  | 1. SELECT[tbl:​Treatment_Types] <br>2. PROJECT[col:​Treatments:​cost_of_treatment, #1] <br>3. PROJECT[col:​Treatment_Types:​treatment_type_description, #1] <br>4. UNION[#2, #3] <br> | + | medium | 
  | SPIDER_dev_950 | List each owner's first name, last name, and the size of his for her dog. | SELECT T1.first_name ,  T1.last_name ,  T2.size_code FROM Owners AS T1 JOIN Dogs AS T2 ON T1.owner_id  =  T2.owner_id |  | 1. SELECT[tbl:​Owners] <br>2. PROJECT[col:​Owners:​first_name, #1] <br>3. PROJECT[col:​Owners:​last_name, #1] <br>4. PROJECT[col:​Dogs:​size_code, #1] <br>5. UNION[#2, #3, #4] <br> | + | medium | 
  | SPIDER_dev_951 | What are each owner's first name, last name, and the size of their dog? | SELECT T1.first_name ,  T1.last_name ,  T2.size_code FROM Owners AS T1 JOIN Dogs AS T2 ON T1.owner_id  =  T2.owner_id |  | 1. SELECT[tbl:​Owners] <br>2. PROJECT[col:​Owners:​first_name, #1] <br>3. PROJECT[col:​Owners:​last_name, #1] <br>4. PROJECT[col:​Dogs:​size_code, #1] <br>5. UNION[#2, #3, #4] <br> | + | medium | 
  | SPIDER_dev_952 | List pairs of the owner's first name and the dogs's name. | SELECT T1.first_name ,  T2.name FROM Owners AS T1 JOIN Dogs AS T2 ON T1.owner_id  =  T2.owner_id |  | 1. SELECT[tbl:​Owners] <br>2. PROJECT[col:​Owners:​first_name, #1] <br>3. PROJECT[col:​Dogs:​name, #1] <br>4. UNION[#2, #3] <br> | + | medium | 
  | SPIDER_dev_953 | What are each owner's first name and their dogs's name? | SELECT T1.first_name ,  T2.name FROM Owners AS T1 JOIN Dogs AS T2 ON T1.owner_id  =  T2.owner_id |  | 1. SELECT[tbl:​Owners] <br>2. PROJECT[col:​Owners:​first_name, #1] <br>3. PROJECT[tbl:​Dogs, #1] <br>4. PROJECT[col:​Dogs:​name, #3] <br>5. UNION[#2, #4] <br> | + | medium | 
  | SPIDER_dev_954 | List the names of the dogs of the rarest breed and the treatment dates of them. | SELECT T1.name ,  T2.date_of_treatment FROM Dogs AS T1 JOIN Treatments AS T2 ON T1.dog_id  =  T2.dog_id WHERE T1.breed_code  =  ( SELECT breed_code FROM Dogs GROUP BY breed_code ORDER BY count(*) ASC LIMIT 1 ) |  | 1. SELECT[tbl:​Breeds] <br>2. PROJECT[col:​Dogs:​breed_code, #1] <br>3. SUPERLATIVE[comparative:​max:​None, #1, #2] <br>4. PROJECT[col:​Dogs:​name, #3] <br>5. PROJECT[col:​Treatments:​date_of_treatment, #3] <br>6. UNION[#4, #5] <br> | - | extra | 
  | SPIDER_dev_955 | Which dogs are of the rarest breed? Show their names and treatment dates. | SELECT T1.name ,  T2.date_of_treatment FROM Dogs AS T1 JOIN Treatments AS T2 ON T1.dog_id  =  T2.dog_id WHERE T1.breed_code  =  ( SELECT breed_code FROM Dogs GROUP BY breed_code ORDER BY count(*) ASC LIMIT 1 ) |  | 1. SELECT[tbl:​Dogs] <br>2. PROJECT[col:​Dogs:​breed_code, #1] <br>3. SUPERLATIVE[comparative:​max:​None, #1, #2] <br>4. PROJECT[col:​Breeds:​breed_name, #3] <br>5. PROJECT[col:​Treatments:​date_of_treatment, #3] <br>6. UNION[#4, #5] <br> | - | extra | 
  | SPIDER_dev_956 | Which dogs are owned by someone who lives in Virginia? List the owner's first name and the dog's name. | SELECT T1.first_name ,  T2.name FROM Owners AS T1 JOIN Dogs AS T2 ON T1.owner_id  =  T2.owner_id WHERE T1.state  =  'Virginia' |  | 1. SELECT[tbl:​Owners] <br>2. COMPARATIVE[#1, #1, comparative:​=:​Virginia:​col:​Owners:​state] <br>3. PROJECT[col:​Owners:​first_name, #2] <br>4. PROJECT[col:​Dogs:​name, #2] <br>5. UNION[#3, #4] <br> | + | medium | 
  | SPIDER_dev_957 | Find the first names of owners living in Virginia and the names of dogs they own. | SELECT T1.first_name ,  T2.name FROM Owners AS T1 JOIN Dogs AS T2 ON T1.owner_id  =  T2.owner_id WHERE T1.state  =  'Virginia' |  | 1. SELECT[tbl:​Owners] <br>2. COMPARATIVE[#1, #1, comparative:​=:​Virginia:​col:​Owners:​state] <br>3. PROJECT[tbl:​Dogs, #2] <br>4. PROJECT[col:​Owners:​first_name, #3] <br>5. PROJECT[col:​Dogs:​name, #3] <br>6. UNION[#4, #5] <br> | + | medium | 
  | SPIDER_dev_958 | What are the arriving date and the departing date of the dogs who have gone through a treatment? | SELECT DISTINCT T1.date_arrived ,  T1.date_departed FROM Dogs AS T1 JOIN Treatments AS T2 ON T1.dog_id  =  T2.dog_id |  | 1. SELECT[tbl:​Dogs] <br>2. COMPARATIVE[#1, #1, tbl:​Treatments] <br>3. PROJECT[col:​Dogs:​date_arrived, #2] <br>4. PROJECT[col:​Dogs:​date_departed, #2] <br>5. UNION[#3, #4] <br> | + | medium | 
  | SPIDER_dev_959 | Find the arriving date and the departing date of the dogs that received a treatment. | SELECT DISTINCT T1.date_arrived ,  T1.date_departed FROM Dogs AS T1 JOIN Treatments AS T2 ON T1.dog_id  =  T2.dog_id |  | 1. SELECT[tbl:​Dogs] <br>2. COMPARATIVE[#1, #1, tbl:​Treatments] <br>3. PROJECT[col:​Dogs:​date_arrived, #2] <br>4. PROJECT[col:​Dogs:​date_departed, #2] <br>5. UNION[#3, #4] <br> | + | medium | 
  | SPIDER_dev_960 | List the last name of the owner owning the youngest dog. | SELECT T1.last_name FROM Owners AS T1 JOIN Dogs AS T2 ON T1.owner_id  =  T2.owner_id WHERE T2.age  =  ( SELECT max(age) FROM Dogs ) |  | 1. SELECT[tbl:​Owners] <br>2. PROJECT[tbl:​Dogs, #1] <br>3. SUPERLATIVE[comparative:​min:​None, #1, #2] <br>4. PROJECT[col:​Owners:​last_name, #3] <br> | - | extra | 
  | SPIDER_dev_961 | Who owns the youngest dog? Give me his or her last name. | SELECT T1.last_name FROM Owners AS T1 JOIN Dogs AS T2 ON T1.owner_id  =  T2.owner_id WHERE T2.age  =  ( SELECT max(age) FROM Dogs ) |  | 1. SELECT[tbl:​Dogs] <br>2. PROJECT[col:​Dogs:​age, #1] <br>3. SUPERLATIVE[comparative:​min:​None, #1, #2] <br>4. PROJECT[col:​Dogs:​name, #3] <br> | - | extra | 
  | SPIDER_dev_962 | List the emails of the professionals who live in the state of Hawaii or the state of Wisconsin. | SELECT email_address FROM Professionals WHERE state  =  'Hawaii' OR state  =  'Wisconsin' |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[col:​Professionals:​state, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Hawaii:​col:​Professionals:​state] <br>4. COMPARATIVE[#1, #2, comparative:​=:​Wisconsin:​col:​Professionals:​state] <br>5. UNION[#3, #4] <br>6. PROJECT[col:​Professionals:​email_address, #5] <br> | + | medium | 
  | SPIDER_dev_963 | What are the emails of the professionals living in either the state of Hawaii or the state of Wisconsin? | SELECT email_address FROM Professionals WHERE state  =  'Hawaii' OR state  =  'Wisconsin' |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[col:​Professionals:​state, #1] <br>3. COMPARATIVE[#1, #2, comparative:​=:​Hawaii:​col:​Professionals:​state] <br>4. COMPARATIVE[#1, #2, comparative:​=:​Wisconsin:​col:​Professionals:​state] <br>5. UNION[#3, #4] <br>6. PROJECT[col:​Professionals:​email_address, #5] <br> | + | medium | 
  | SPIDER_dev_964 | What are the arriving date and the departing date of all the dogs? | SELECT date_arrived ,  date_departed FROM Dogs |  | 1. SELECT[tbl:​Dogs] <br>2. PROJECT[col:​Dogs:​date_arrived, #1] <br>3. PROJECT[col:​Dogs:​date_departed, #1] <br>4. UNION[#2, #3] <br> | + | medium | 
  | SPIDER_dev_965 | List the arrival date and the departure date for all the dogs. | SELECT date_arrived ,  date_departed FROM Dogs |  | 1. SELECT[tbl:​Dogs] <br>2. PROJECT[col:​Dogs:​date_arrived, #1] <br>3. PROJECT[col:​Dogs:​date_departed, #1] <br>4. UNION[#2, #3] <br> | + | medium | 
  | SPIDER_dev_966 | How many dogs went through any treatments? | SELECT count(DISTINCT dog_id) FROM Treatments |  | 1. SELECT[tbl:​Dogs] <br>2. COMPARATIVE[#1, #1, tbl:​Treatments] <br>3. AGGREGATE[count, #2] <br> | + | easy | 
  | SPIDER_dev_967 | Count the number of dogs that went through a treatment. | SELECT count(DISTINCT dog_id) FROM Treatments |  | 1. SELECT[tbl:​Dogs] <br>2. COMPARATIVE[#1, #1, tbl:​Treatments] <br>3. AGGREGATE[count, #2] <br> | + | easy | 
  | SPIDER_dev_968 | How many professionals have performed any treatment to dogs? | SELECT count(DISTINCT professional_id) FROM Treatments |  | 1. SELECT[col:​Treatments:​professional_id] <br>2. COMPARATIVE[#1, #1, tbl:​Treatments] <br>3. AGGREGATE[count, #2] <br> | + | easy | 
  | SPIDER_dev_969 | Find the number of professionals who have ever treated dogs. | SELECT count(DISTINCT professional_id) FROM Treatments |  | 1. SELECT[tbl:​Professionals] <br>2. COMPARATIVE[#1, #1, tbl:​Dogs] <br>3. AGGREGATE[count, #2] <br> | + | easy | 
  | SPIDER_dev_970 | Which professionals live in a city containing the substring 'West'? List his or her role, street, city and state. | SELECT role_code ,  street ,  city ,  state FROM professionals WHERE city LIKE '%West%' |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[col:​Professionals:​city, #1] <br>3. COMPARATIVE[#1, #2, comparative:​like:​West:​col:​Professionals:​city] <br>4. PROJECT[col:​Professionals:​city, #3] <br>5. PROJECT[col:​Professionals:​street, #3] <br>6. PROJECT[col:​Professionals:​city, #3] <br>7. PROJECT[col:​Professionals:​state, #3] <br>8. UNION[#4, #5, #6, #7] <br> | - | medium | 
  | SPIDER_dev_971 | Find the role, street, city and state of the professionals living in a city that contains the substring 'West'. | SELECT role_code ,  street ,  city ,  state FROM professionals WHERE city LIKE '%West%' |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[col:​Professionals:​city, #1] <br>3. COMPARATIVE[#1, #2, comparative:​like:​West:​col:​Professionals:​city] <br>4. PROJECT[col:​Professionals:​role_code, #3] <br>5. PROJECT[col:​Professionals:​street, #3] <br>6. PROJECT[col:​Professionals:​state, #3] <br>7. UNION[#4, #5, #6] <br> | - | medium | 
  | SPIDER_dev_972 | Which owners live in the state whose name contains the substring 'North'? List his first name, last name and email. | SELECT first_name ,  last_name ,  email_address FROM Owners WHERE state LIKE '%North%' |  | 1. SELECT[col:​Owners:​state] <br>2. PROJECT[col:​Owners:​state, #1] <br>3. COMPARATIVE[#1, #2, comparative:​like:​North:​col:​Owners:​state] <br>4. PROJECT[col:​Owners:​first_name, #3] <br>5. PROJECT[col:​Owners:​last_name, #3] <br>6. PROJECT[col:​Owners:​email_address, #3] <br>7. UNION[#4, #5, #6] <br> | + | medium | 
  | SPIDER_dev_973 | Return the first name, last name and email of the owners living in a state whose name contains the substring 'North'. | SELECT first_name ,  last_name ,  email_address FROM Owners WHERE state LIKE '%North%' |  | 1. SELECT[tbl:​Owners] <br>2. PROJECT[col:​Owners:​state, #1] <br>3. COMPARATIVE[#1, #2, comparative:​like:​North:​col:​Owners:​state] <br>4. PROJECT[col:​Owners:​first_name, #3] <br>5. PROJECT[col:​Owners:​last_name, #3] <br>6. PROJECT[col:​Owners:​email_address, #3] <br>7. UNION[#4, #5, #6] <br> | + | medium | 
  | SPIDER_dev_974 | How many dogs have an age below the average? | SELECT count(*) FROM Dogs WHERE age  <  ( SELECT avg(age) FROM Dogs ) |  | 1. SELECT[tbl:​Dogs] <br>2. PROJECT[col:​Dogs:​age, #1] <br>3. AGGREGATE[avg, #2] <br>4. COMPARATIVE[#1, #2, comparative:​<:​LGE:​col:​Dogs:​size_code] <br>5. AGGREGATE[count, #4] <br> | - | hard | 
  | SPIDER_dev_975 | Count the number of dogs of an age below the average. | SELECT count(*) FROM Dogs WHERE age  <  ( SELECT avg(age) FROM Dogs ) |  | 1. SELECT[tbl:​Dogs] <br>2. PROJECT[col:​Dogs:​age, #1] <br>3. AGGREGATE[avg, #2] <br>4. COMPARATIVE[#1, #2, comparative:​<:​LGE:​col:​Dogs:​size_code] <br>5. AGGREGATE[count, #4] <br> | - | hard | 
  | SPIDER_dev_976 | How much does the most recent treatment cost? | SELECT cost_of_treatment FROM Treatments ORDER BY date_of_treatment DESC LIMIT 1 |  | 1. SELECT[col:​Treatments:​cost_of_treatment] <br>2. PROJECT[None, #1] <br>3. SUPERLATIVE[comparative:​max:​None, #1, #2] <br>4. AGGREGATE[max, #3] <br> | - | medium | 
  | SPIDER_dev_977 | Show me the cost of the most recently performed treatment. | SELECT cost_of_treatment FROM Treatments ORDER BY date_of_treatment DESC LIMIT 1 |  | 1. SELECT[tbl:​Treatments] <br>2. PROJECT[col:​Treatments:​cost_of_treatment, #1] <br>3. SUPERLATIVE[comparative:​max:​None, #1, #2] <br>4. PROJECT[col:​Treatments:​cost_of_treatment, #3] <br> | - | medium | 
  | SPIDER_dev_978 | How many dogs have not gone through any treatment? | SELECT count(*) FROM Dogs WHERE dog_id NOT IN ( SELECT dog_id FROM Treatments ) |  | 1. SELECT[tbl:​Dogs] <br>2. COMPARATIVE[#1, #1, tbl:​Treatments] <br>3. DISCARD[#1, #2] <br>4. AGGREGATE[count, #3] <br> | + | extra | 
  | SPIDER_dev_979 | Tell me the number of dogs that have not received any treatment. | select count(*) from dogs where dog_id not in ( select dog_id from treatments ) |  | 1. SELECT[tbl:​Dogs] <br>2. COMPARATIVE[#1, #1, tbl:​Treatments] <br>3. DISCARD[#1, #2] <br>4. AGGREGATE[count, #3] <br> | + | extra | 
  | SPIDER_dev_980 | How many owners temporarily do not have any dogs? | SELECT count(*) FROM Owners WHERE owner_id NOT IN ( SELECT owner_id FROM Dogs ) |  | 1. SELECT[tbl:​Owners] <br>2. COMPARATIVE[#1, #1, tbl:​Dogs] <br>3. DISCARD[#1, #2] <br>4. AGGREGATE[count, #3] <br> | + | extra | 
  | SPIDER_dev_981 | Find the number of owners who do not own any dogs at this moment. | SELECT count(*) FROM Owners WHERE owner_id NOT IN ( SELECT owner_id FROM Dogs ) |  | 1. SELECT[tbl:​Owners] <br>2. COMPARATIVE[#1, #1, tbl:​Dogs] <br>3. DISCARD[#1, #2] <br>4. AGGREGATE[count, #3] <br> | + | extra | 
  | SPIDER_dev_982 | How many professionals did not operate any treatment on dogs? | SELECT count(*) FROM Professionals WHERE professional_id NOT IN ( SELECT professional_id FROM Treatments ) |  | 1. SELECT[tbl:​Professionals] <br>2. COMPARATIVE[#1, #1, tbl:​Treatments] <br>3. DISCARD[#1, #2] <br>4. AGGREGATE[count, #3] <br> | + | extra | 
  | SPIDER_dev_983 | Find the number of professionals who have not treated any dogs. | SELECT count(*) FROM Professionals WHERE professional_id NOT IN ( SELECT professional_id FROM Treatments ) |  | 1. SELECT[tbl:​Professionals] <br>2. COMPARATIVE[#1, #1, tbl:​Treatments] <br>3. DISCARD[#1, #2] <br>4. AGGREGATE[count, #3] <br> | + | extra | 
  | SPIDER_dev_984 | List the dog name, age and weight of the dogs who have been abandoned? 1 stands for yes, and 0 stands for no. | SELECT name ,  age ,  weight FROM Dogs WHERE abandoned_yn  =  1 |  | 1. SELECT[tbl:​Dogs] <br>2. COMPARATIVE[#1, #1, comparative:​=:​1:​col:​Dogs:​abandoned_yn] <br>3. COMPARATIVE[#2, #2, comparative:​=:​0:​col:​Dogs:​abandoned_yn] <br>4. PROJECT[col:​Dogs:​name, #3] <br>5. PROJECT[col:​Dogs:​age, #3] <br>6. PROJECT[col:​Dogs:​weight, #3] <br>7. UNION[#4, #5, #6] <br> | - | medium | 
  | SPIDER_dev_985 | What are the dog name, age and weight of the dogs that were abandoned? Note that 1 stands for yes, and 0 stands for no in the tables. | SELECT name ,  age ,  weight FROM Dogs WHERE abandoned_yn  =  1 |  | 1. SELECT[tbl:​Dogs] <br>2. COMPARATIVE[#1, #1, comparative:​=:​0:​col:​Dogs:​abandoned_yn] <br>3. COMPARATIVE[#2, #2, comparative:​=:​1:​col:​Dogs:​abandoned_yn] <br>4. PROJECT[col:​Dogs:​name, #3] <br>5. PROJECT[col:​Dogs:​age, #3] <br>6. PROJECT[col:​Dogs:​weight, #3] <br>7. UNION[#4, #5, #6] <br> | - | medium | 
  | SPIDER_dev_986 | What is the average age of all the dogs? | SELECT avg(age) FROM Dogs |  | 1. SELECT[tbl:​Dogs] <br>2. PROJECT[col:​Dogs:​age, #1] <br>3. AGGREGATE[avg, #2] <br> | + | easy | 
  | SPIDER_dev_987 | Compute the average age of all the dogs. | SELECT avg(age) FROM Dogs |  | 1. SELECT[tbl:​Dogs] <br>2. PROJECT[col:​Dogs:​age, #1] <br>3. AGGREGATE[avg, #2] <br> | + | easy | 
  | SPIDER_dev_988 | What is the age of the oldest dog? | SELECT max(age) FROM Dogs |  | 1. SELECT[tbl:​Dogs] <br>2. PROJECT[col:​Dogs:​age, #1] <br>3. SUPERLATIVE[comparative:​max:​None, #1, #2] <br>4. PROJECT[col:​Dogs:​age, #3] <br> | - | easy | 
  | SPIDER_dev_989 | Tell me the age of the oldest dog. | SELECT max(age) FROM Dogs |  | 1. SELECT[tbl:​Dogs] <br>2. PROJECT[col:​Dogs:​age, #1] <br>3. SUPERLATIVE[comparative:​max:​None, #1, #2] <br>4. PROJECT[col:​Dogs:​age, #3] <br> | - | easy | 
  | SPIDER_dev_990 | How much does each charge type costs? List both charge type and amount. | SELECT charge_type ,  charge_amount FROM Charges |  | 1. SELECT[tbl:​Charges] <br>2. PROJECT[col:​Charges:​charge_amount, #1] <br>3. SUPERLATIVE[comparative:​max:​None, #1, #2] <br>4. PROJECT[col:​Charges:​charge_type, #3] <br>5. PROJECT[col:​Charges:​charge_amount, #3] <br>6. UNION[#4, #5] <br> | - | medium | 
  | SPIDER_dev_991 | List each charge type and its amount. | SELECT charge_type ,  charge_amount FROM Charges |  | 1. SELECT[tbl:​Charges] <br>2. PROJECT[col:​Charges:​charge_type, #1] <br>3. PROJECT[col:​Charges:​charge_amount, #1] <br>4. UNION[#2, #3] <br> | + | medium | 
  | SPIDER_dev_992 | How much does the most expensive charge type costs? | SELECT max(charge_amount) FROM Charges |  | 1. SELECT[tbl:​Charges] <br>2. PROJECT[col:​Charges:​charge_type, #1] <br>3. SUPERLATIVE[comparative:​max:​None, #1, #2] <br>4. AGGREGATE[count, #3] <br> | - | easy | 
  | SPIDER_dev_993 | What is the charge amount of the most expensive charge type? | SELECT max(charge_amount) FROM Charges |  | 1. SELECT[tbl:​Charges] <br>2. PROJECT[col:​Charges:​charge_type, #1] <br>3. SUPERLATIVE[comparative:​max:​None, #1, #2] <br>4. PROJECT[col:​Charges:​charge_amount, #3] <br> | + | easy | 
  | SPIDER_dev_994 | List the email, cell phone and home phone of all the professionals. | SELECT email_address ,  cell_number ,  home_phone FROM professionals |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[col:​Professionals:​email_address, #1] <br>3. PROJECT[col:​Professionals:​cell_number, #1] <br>4. PROJECT[col:​Professionals:​home_phone, #1] <br>5. UNION[#2, #3, #4] <br> | + | medium | 
  | SPIDER_dev_995 | What are the email, cell phone and home phone of each professional? | SELECT email_address ,  cell_number ,  home_phone FROM professionals |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[col:​Professionals:​email_address, #1] <br>3. PROJECT[col:​Professionals:​cell_number, #1] <br>4. PROJECT[col:​Professionals:​home_phone, #1] <br>5. UNION[#2, #3, #4] <br> | + | medium | 
  | SPIDER_dev_998 | List the first name of all the professionals along with the description of the treatment they have done. | SELECT DISTINCT T1.first_name ,  T3.treatment_type_description FROM professionals AS T1 JOIN Treatments AS T2 ON T1.professional_id  =  T2.professional_id JOIN Treatment_types AS T3 ON T2.treatment_type_code  =  T3.treatment_type_code |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[col:​Professionals:​first_name, #1] <br>3. PROJECT[col:​Treatment_Types:​treatment_type_description, #1] <br>4. UNION[#2, #3] <br> | - | medium | 
  | SPIDER_dev_999 | What are each professional's first name and description of the treatment they have performed? | SELECT DISTINCT T1.first_name ,  T3.treatment_type_description FROM professionals AS T1 JOIN Treatments AS T2 ON T1.professional_id  =  T2.professional_id JOIN Treatment_types AS T3 ON T2.treatment_type_code  =  T3.treatment_type_code |  | 1. SELECT[tbl:​Professionals] <br>2. PROJECT[col:​Professionals:​first_name, #1] <br>3. PROJECT[col:​Treatment_Types:​treatment_type_description, #1] <br>4. UNION[#2, #3] <br> | - | medium | 
 ***
 Exec acc: **0.6250**
