/*
 * Decompiled with CFR 0.152.
 */
package parentical_parsers;

import java.util.ArrayList;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntColParser {
    private String full = "";
    private int parlevel = 0;
    private int tokens_parsed = 0;
    private String currentMainPhrase = "O";
    private int currentPositionInMainPhrase = 0;
    private Integer[] currentMainPhraseSpan;
    private int currentMainPhrase_parlevel = 0;
    private int sentnum;
    private String currentSubsent = "O";
    private int currentSubsent_parlevel;
    private Stack st = new Stack();
    private ArrayList<Integer[]> mainphrases_span;

    public SyntColParser() {
        this.currentMainPhraseSpan = new Integer[2];
        this.currentMainPhraseSpan[0] = 0;
        this.currentMainPhraseSpan[1] = 0;
        this.mainphrases_span = new ArrayList();
    }

    public void parse(String input) {
        block18: {
            try {
                String linput = input.trim();
                String element = "";
                if (!this.currentMainPhrase.equals("O")) {
                    this.currentMainPhrase = "I" + this.currentMainPhrase.substring(1);
                    ++this.currentPositionInMainPhrase;
                    this.currentMainPhraseSpan[1] = this.tokens_parsed;
                }
                boolean inElem = false;
                for (int cn = 0; cn < linput.length(); ++cn) {
                    char cinput = linput.charAt(cn);
                    if (cinput == ' ' || cinput == '\n' || cinput == '\r' || cinput == '\t' || cinput == '*') continue;
                    this.full = this.full + cinput;
                    if (cinput == '(') {
                        if (inElem) {
                            if (element.length() < 1) {
                                throw new Exception("Empty element");
                            }
                            this.st.push(element);
                            if (element.equals("SBAR")) {
                                this.currentSubsent = this.currentSubsent + this.sentnum;
                                this.sentnum = 1;
                                this.currentSubsent_parlevel = this.parlevel;
                            }
                            if (this.currentMainPhrase.equals("O") && element.matches("(PP|NP|VP|ADJP|ADVP|CONJP|WH(ADJP|AVP|PP|NP)|QP)") || this.currentMainPhrase.matches("(B|I)\\-VP") && element.matches("(PP|NP|ADJP|ADVP|CONJP|WH(ADJP|AVP|PP|NP)|QP)")) {
                                this.currentMainPhrase = "B-" + element;
                                this.currentPositionInMainPhrase = 1;
                                this.currentMainPhrase_parlevel = this.parlevel;
                                this.currentMainPhraseSpan[0] = this.tokens_parsed;
                                this.currentMainPhraseSpan[1] = this.tokens_parsed;
                            }
                            element = "";
                        } else {
                            inElem = true;
                        }
                        ++this.parlevel;
                        continue;
                    }
                    if (cinput == ')') {
                        if (this.parlevel == this.currentMainPhrase_parlevel && !this.currentMainPhrase.endsWith("O")) {
                            this.currentMainPhrase = "O";
                            this.currentPositionInMainPhrase = 0;
                            this.currentMainPhrase_parlevel = 0;
                            if (input.matches("[)]*")) {
                                Integer[] integerArray = this.currentMainPhraseSpan;
                                Integer n = integerArray[1];
                                Integer n2 = integerArray[1] = Integer.valueOf(integerArray[1] - 1);
                            }
                            this.mainphrases_span.add((Integer[])this.currentMainPhraseSpan.clone());
                            this.currentMainPhraseSpan = null;
                            this.currentMainPhraseSpan = new Integer[2];
                        }
                        --this.parlevel;
                        this.st.pop();
                        continue;
                    }
                    element = element + cinput;
                }
                if (inElem) {
                    if (element.length() < 1) {
                        throw new Exception("Empty element");
                    }
                    this.st.push(element);
                    if (element.equals("SBAR")) {
                        this.currentSubsent = this.currentSubsent + this.sentnum;
                        this.currentSubsent_parlevel = this.parlevel;
                    }
                    if (this.currentMainPhrase.equals("O") && element.matches("(PP|NP|VP|ADJP|ADVP|CONJP|WH(ADJP|AVP|PP|NP)|QP)") || this.currentMainPhrase.matches("(B|I)\\-VP") && element.matches("(PP|NP|ADJP|ADVP|CONJP|WH(ADJP|AVP|PP|NP)|QP)")) {
                        this.currentMainPhrase = "B-" + element;
                        this.currentPositionInMainPhrase = 1;
                        this.currentMainPhrase_parlevel = this.parlevel;
                        this.currentMainPhraseSpan[0] = this.tokens_parsed;
                        this.currentMainPhraseSpan[1] = this.tokens_parsed;
                    }
                    element = "";
                }
                if (!input.matches("[)]*")) {
                    ++this.tokens_parsed;
                }
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block18;
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    public int getParlevel() {
        return this.parlevel;
    }

    public String getCurrentSubsent() {
        return this.currentSubsent;
    }

    public String getCurrentMainPhraseBIO() {
        return this.currentMainPhrase;
    }

    public int getCurrentPositionInMainPhrase() {
        return this.currentPositionInMainPhrase;
    }

    public String getCurrent() {
        Object[] st_arr = new String[this.st.size()];
        String current = "";
        this.st.copyInto(st_arr);
        for (int i = 0; i < st_arr.length; ++i) {
            if (i != 0) {
                current = current + "-";
            }
            current = current + (String)st_arr[i];
        }
        return current;
    }

    public String updateCurrent(String past) {
        Object[] st_arr = new String[this.st.size()];
        String current = "";
        this.st.copyInto(st_arr);
        for (int i = 0; i < st_arr.length; ++i) {
            if (i != 0) {
                current = current + "-";
            }
            current = current + (String)st_arr[i];
        }
        String[] past_arr = past.split("-");
        String[] curr_arr = current.split("-");
        String commonSynt = "";
        int shortestSyntTree = curr_arr.length;
        if (past_arr.length < shortestSyntTree) {
            shortestSyntTree = past_arr.length;
        }
        for (int i = 0; i < shortestSyntTree && curr_arr[i].equals(past_arr[i]); ++i) {
            if (i != 0) {
                commonSynt = commonSynt + "-";
            }
            commonSynt = commonSynt + curr_arr[i];
        }
        return commonSynt;
    }

    public String getCurrentPhrase(String synt) {
        String[] synt_arr = synt.split("-");
        String phraseSynt = "";
        int phraseDept = 0;
        for (int i = synt_arr.length - 1; i >= 0; --i) {
            if (phraseDept == 0) {
                if (synt_arr[i].equals("VP")) {
                    phraseSynt = synt_arr[i];
                    break;
                }
                phraseSynt = synt_arr[i];
                ++phraseDept;
                continue;
            }
            if (synt_arr[i].equals("VP") || synt_arr[i].matches("S.*")) break;
            phraseSynt = synt_arr[i] + "-" + phraseSynt;
            ++phraseDept;
        }
        return phraseSynt;
    }

    public String getCurrentMainPhrase(String synt) {
        String[] synt_arr = synt.split("-");
        String phraseSynt = "";
        boolean phraseDept = false;
        for (int i = synt_arr.length - 1; i >= 0; --i) {
            if (!phraseDept) {
                if (synt_arr[i].equals("VP")) {
                    phraseSynt = synt_arr[i];
                    break;
                }
                phraseSynt = synt_arr[i];
                phraseDept = true;
                continue;
            }
            if (synt_arr[i].equals("VP") || synt_arr[i].matches("S.*")) break;
            phraseSynt = synt_arr[i];
        }
        return phraseSynt;
    }

    public String getFull() {
        return this.full;
    }

    public ArrayList<Integer[]> getMainPhrasesSpan() {
        return this.mainphrases_span;
    }

    public ArrayList<String> getAllPhrases() {
        ArrayList<String> phrases;
        block9: {
            phrases = new ArrayList<String>();
            try {
                Stack<String> localst = new Stack<String>();
                String linput = this.full.trim();
                String element = "";
                boolean inElem = false;
                for (int cn = 0; cn < linput.length(); ++cn) {
                    char cinput = linput.charAt(cn);
                    if (cinput == ' ' || cinput == '\n' || cinput == '\r' || cinput == '\t' || cinput == '*') continue;
                    if (cinput == '(') {
                        if (inElem) {
                            if (element.length() < 1) {
                                throw new Exception("Empty element");
                            }
                            localst.push(element);
                            this.getAllCurrentPhrases(localst, phrases);
                            element = "";
                            continue;
                        }
                        inElem = true;
                        continue;
                    }
                    if (cinput == ')') {
                        if (inElem) {
                            if (element.length() < 1) {
                                throw new Exception("Empty element");
                            }
                            localst.push(element);
                            this.getAllCurrentPhrases(localst, phrases);
                            element = "";
                            inElem = false;
                        }
                        localst.pop();
                        continue;
                    }
                    element = element + cinput;
                }
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block9;
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
        return phrases;
    }

    public void getAllCurrentPhrases(Stack localst, ArrayList<String> phrases) {
        Object[] synt_arr = new String[localst.size()];
        localst.copyInto(synt_arr);
        Object phraseSynt = "";
        int phraseDept = 0;
        for (int i = synt_arr.length - 1; i >= 0; --i) {
            if (phraseDept == 0) {
                if (((String)synt_arr[i]).equals("VP")) {
                    phraseSynt = synt_arr[i];
                    break;
                }
                if (!((String)synt_arr[i]).endsWith("P")) break;
                phraseSynt = synt_arr[i];
                ++phraseDept;
                continue;
            }
            if (phraseDept >= 3 || ((String)synt_arr[i]).equals("VP") || ((String)synt_arr[i]).matches("S.*")) break;
            phraseSynt = (String)synt_arr[i] + "-" + (String)phraseSynt;
            ++phraseDept;
        }
        if (!((String)phraseSynt).equals("")) {
            phrases.add((String)phraseSynt);
        }
    }
}

