import argparse
import json

def convert_class(original):
    return original.replace(" ", "SPACE")

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--input", type=str, required=True, help="Path to input file")
    parser.add_argument("--output", type=str, required=True, help="Path to output file")
    args = parser.parse_args()

    with open(args.input) as f:
        classes_original = json.load(f)
    
    classed_fixed = list(map(convert_class, classes_original))
    with open(args.output, 'w') as f:
        json.dump(classed_fixed, f)
        