# -*- coding: utf-8 -*-
"""hate-speech-flair.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1C-bA-heoAS-7h7W0cxTpFAXjARVFHW83
"""

!pip install flair

from flair.datasets import ClassificationCorpus,CSVClassificationCorpus
from flair.data import Corpus

# Create Column Mapping to show which column is for label and text
column_name_map = {2:"label",1:"text"}

data_folder = '/content/drive/MyDrive/hope-speech-jan-2021/data-mal'

corpus_fst: Corpus = ClassificationCorpus(data_folder)

print(corpus_fst.obtain_statistics())

# Creating the Label Diction For CSV
label_dict= corpus_fst.make_label_dictionary()

print(label_dict)

# Working with the Word Embeddings
from flair.embeddings import FastTextEmbeddings,FlairEmbeddings,WordEmbeddings,StackedEmbeddings,DocumentLSTMEmbeddings,DocumentRNNEmbeddings,DocumentPoolEmbeddings

# Create our WEmbeddings
word_embeddings = [FlairEmbeddings('ta-forward'),FlairEmbeddings('ta-backward')]

# Document Embeddings
#document_embeddings = DocumentRNNEmbeddings(word_embeddings,hidden_size=512)

document_embeddings = DocumentPoolEmbeddings(word_embeddings,
                                             fine_tune_mode='nonlinear',
                                             pooling='max')

# Load NLP Pkgs
from flair.models import TextClassifier
from flair.trainers import ModelTrainer

# Classifier with CSV dataset
clf = TextClassifier(document_embeddings,label_dictionary=label_dict)

# 6. initialize the text classifier trainer
trainer = ModelTrainer(clf, corpus_fst)

# 7. start the training
trainer.train('/content/drive/MyDrive/hope-speech-jan-2021/eng-data/resources/taggers/en-hope-flair-fast-encrawl--pool-max',
              learning_rate=0.1,
              mini_batch_size=32,
              anneal_factor=0.5,
              patience=5,
              max_epochs=20,
              checkpoint=True)

# 9. continue trainer at later point
#from pathlib import Path

#checkpoint = 'resources/taggers/example-ner/checkpoint.pt'
trainer = ModelTrainer.load_checkpoint("/content/drive/MyDrive/hope-speech-jan-2021/data-mal/resources/taggers/mal-hope-flair-fast-pool-max/checkpoint.pt", corpus_fst)
trainer.train('/content/drive/MyDrive/hope-speech-jan-2021/data-mal/resources/taggers/mal-hope-flair-fast-pool-max',
              learning_rate=0.1,
              mini_batch_size=32,
              max_epochs=20,
              checkpoint=True)

"""## **evaluate**

"""

from flair.datasets import DataLoader, SentenceDataset

import pandas as pd
import numpy as np
import re

def result_summary(result):
    scores = []
    lines = result.detailed_results.split('\n')
    #print(lines)
    for line in lines[3:]:
        split_line = re.split('\ -\ |\ +|:\ ', line)
        #split_line.remove('-')
        split_line=line.strip()
        #print(split_line)
        scores.append(split_line)
        
    scores = np.array(scores,dtype=object)
    #scores=list(scores)

    print(scores)
    #scores.remove('-')
    #print(scores)
    tags = scores[:,0].tolist()
    print(tags)
    scores_ = scores[:, 2::2]
    tag_tfpn = scores_[:, :4].astype(int)
    print(tag_tfpn)
    tag_metrics = scores_[:, 4:].astype(float)
    metrics = np.array(result.log_line.split('\t')).astype(float).reshape(1,3, dtype=object)
    
    df_tag_tfpn = pd.DataFrame(data=tag_tfpn,index=tags,columns=['true-positive','false-positive', 'false-negative', 'true-negative'])
    df_tag_metrics = pd.DataFrame(data=tag_metrics,index=tags,columns=['precision','recall', 'accuracy','f1-score'])
    df_metrics = pd.DataFrame(data=metrics, index=None,columns=['precision','recall','f1-score'])
    
    return df_tag_metrics, df_metrics

result, loss = trainer.model.evaluate(corpus_fst.test,num_workers=4)



print(result.detailed_results)

print(result.detailed_results)

print(result.detailed_results)

result.log_line

result.main_score



# visualize
from flair.visual.training_curves import Plotter
plotter = Plotter()
plotter.plot_training_curves('/content/drive/MyDrive/hope-speech-jan-2021/data-mal/resources/taggers/mal-hope/loss.tsv')
#plotter.plot_weights('weights.txt')



"""Prediction

"""

from flair.models import TextClassifier
from flair.data import Sentence

classifier = TextClassifier.load('/content/drive/MyDrive/malayalam-hope-speech-21/resources/taggers/ml-hope-flair/best-model.pt')



classifier.predict(sentence)

print(sentence.labels)

from flair.datasets import ClassificationCorpus,CSVClassificationCorpus
from flair.data import Corpus

# Create Column Mapping to show which column is for label and text
column_name_map = {2:"label",1:"text"}

data_folder = '/content/drive/MyDrive/malayalam-hope-speech-21/data-mal'

# Create Corpus For CSV
corpus_csv: Corpus = CSVClassificationCorpus(data_folder,column_name_map=column_name_map,skip_header=True,delimiter=',')

print(corpus_csv.obtain_statistics())

# Creating the Label Diction For CSV
label_dict_csv = corpus_csv.make_label_dictionary()

print(label_dict_csv)

# Working with the Word Embeddings
from flair.embeddings import FlairEmbeddings,WordEmbeddings,StackedEmbeddings,DocumentLSTMEmbeddings,DocumentRNNEmbeddings

# Create our WEmbeddings
word_embeddings = [FlairEmbeddings('ml-forward'),FlairEmbeddings('ml-backward')]

# Document Embeddings
document_embeddings = DocumentRNNEmbeddings(word_embeddings,hidden_size=512)

# Load NLP Pkgs
from flair.models import TextClassifier
from flair.trainers import ModelTrainer

# Classifier with CSV dataset
clf = TextClassifier(document_embeddings,label_dictionary=label_dict_csv)

# 6. initialize the text classifier trainer
trainer = ModelTrainer(clf, corpus)

# 7. start the training
trainer.train('/content/drive/MyDrive/malayalam-hope-speech-21/data-mal/resources/taggers/mal-hope',
              learning_rate=0.1,
              mini_batch_size=32,
              anneal_factor=0.5,
              patience=5,
              max_epochs=10)

"""Prediction

"""

from flair.models import TextClassifier
from flair.data import Sentence

classifier = TextClassifier.load('/content/drive/MyDrive/malayalam-hope-speech-21/resources/taggers/ml-hope-flair/best-model.pt')



sentence = Sentence("അതെ അണപൊട്ടി ഒഴുകുകയാണ്,
കെവിൻ avde pettupoyi🤣🤣🤣,
@my voice ullup illa daaa tayoli ath kond alle ninte ammaye njan panniyatha monee,
@Albin Baiju
I respect you..,
@Sreekesh Mohanan ചെറിയ ശതമാനം ക്രിസ്ത്യൻ /മുസ്ലിം ജാതി ഉണ്ട് എന്നു വച്ചു എല്ലാരും അല്ല,
@divya nandu ഇങ്ങ് വാ.. ഞാൻ ആക്കി തരാ,
@Hari Prasadv333 ഈ വിഷയത്തിൽ കരുണയുടെയും സഹാനുഭൂതിയുടെയും അടിസ്ഥാനത്തിൽ നമുക്കിവർക്ക് വേണ്ടി വാദിക്കുവാനും അനുകൂലിക്കുവാനുമൊക്കെ തോന്നും അത് സ്വാഭാവികം.പക്ഷെ ഇതൊരു അവസ്ഥയാണെന്നതാണ് സത്യം ജൻമനാ കാഴ്ചശക്തിയില്ലാതെയും സംസാരശേഷി ഇല്ലാതെയുമൊക്കെ കുട്ടികൾ ജനിക്കുന്നില്ലെ അതുപോലെ മനസ്സിനെ ബാധിക്കുന്ന ഒരു തരം വൈകല്യമാണിത് ഇതിനെ ആരംഭത്തിൽ തന്നെ വേണ്ട പ്പെട്ടവർ തിരിച്ചറിഞ്ഞു കൃത്യമായ ഇടപെടലുകൾ നടത്തിയിരുന്നെങ്കിൽ അവർക്ക് ഇതുപോലെ അവിടെ വന്നിരിക്കേണ്ട അവസ്ഥ വരില്ലായിരുന്നു.
@Mathew P നിനകും നിന്റെ കമന്റ് ന്നു like അടിച്ച ആ മലരുക്കൾകും എന്റെയും നല്ലവരായ എല്ലാ ഇന്ത്യൻക്കരുടെ നടുവിരൽ നമസ്കാരം... മോനെ മതീസ്സ്‌ നീ വീട്ടിൽ ഇരുന്ന് അടിച്ചോ...
ഇതിൽ വന്ന് കമന്റ് വായിക്കുന്നവരിൽ അധികവും പണ്ട് ഫയർ മാസികയെ സ്നേഹിച്ചവർ ആണ്
തീർച്ചയായും share ചെയ്യും dr.... take care.....
Angana parayalle broo,
@Jagan Tom ഹോർമോണിന്റെ പ്രശ്ന മുള്ളവർക്കും എതിർ ലിംഗത്തിനോട് ചെറിയ തരത്തിലെങ്കിലും ആകർഷണം തോന്നും അത് പരിചയത്തിലൂടെയും ശീലത്തിലൂടെയും വികസിപ്പിച്ചെടുക്കാം.,
@Aswathi Priya hai
PubG ozhike ellaaam delete ആക്കി... Pubg കൊറിയൻ ആപ്പ് അല്ലെ ഉമയ്യപ്പാ...???
ഈ ജീവിതത്തിന് എന്ത് ഭാവിയാണുള്ളത്")

classifier.predict(sentence)

print(sentence.labels)