import random

class Random:
    SEED = 19
    @staticmethod
    def set_seed(seed):
        Random.SEED = seed

    @staticmethod
    def randomchoice(list):
        random.seed(Random.SEED)
        return random.choice(list)

    @staticmethod
    def sample(list, lenght):
        if len(list) > lenght:
            random.seed(Random.SEED)
            return random.sample(list, lenght)
        else:
            return [x for x in list]

    @staticmethod
    def split(list, perc):
        lenght = int(len(list)*perc)
        shuffled = [x for x in list]

        random.seed(Random.SEED)
        random.shuffle(shuffled)

        for line in shuffled:
            if line.split('\t')[0] == 'Synset_name':
                shuffled.remove(line)
        header = '\t'.join(['Synset_name', 'target', 'w1', 'w2', 'target_pos', 'w1_pos', 'w2_pos', 'definition', '#\n'])
        return [header] + shuffled[0:lenght], [header] +shuffled[lenght:]

