# HMNeT

Code for paper "Listen to Both Sides and be Enlightened Hierarchical Modality Fusion Network for Entity and Relation Extraction"

Model Architecture
==========
![model](model.png)
The overall architecture of our hierarchical modality fusion network.


Requirements
==========
To run the codes, you need to install the requirements:
```
pip install -r requirements.txt
```

Data Collection
==========
The datasets that we used in our experiments are as follows:


+ Twitter2015 & Twitter2017
    
    The text data of the Twitter2015 and Twitter2017 datasets are placed in `data/NER_data/twitter2015/` and `data/NER_data/twitter2017/`. Download each tweet's associated images via this [link](https://drive.google.com/file/d/1PpvvncnQkgDNeBMKVgG2zFYuRhbL873g/view) and put in `data/NER_data/twitter2015_images/` and `data/NER_data/twitter2017_images/`. You can also put them anywhere and modify the path configuration in `run.py`
+ MNER
    
    The MNRE dataset used in our paper can be downloaded [here](https://drive.google.com/file/d/1gD9ipQgDEDRxaVxkKr8T0gFFQgKyPpa7/view?usp=sharing). Unzip and move it to `data/RE_data`.
    
    
    For more information regarding the dataset, please refer to the [MNRE](https://github.com/thecharm/MNRE) repository.

Data Process
==========
The text data follows the conll format. For image data, use Faster-RCNN to extract object-images and save them. Because one full picture corresponds to multiple object-images, you need to save the corresponding object-image path. This is a example:
```
{'62654.jpg':   # full image path
    ['0_pred_yolo_crop_1.png',   # object 1 image path
     '0_pred_yolo_crop_0.png',   # object 2 image path
     '0_pred_yolo_crop_2.png'],
    ...
}
  ```
The expected structure of files is:


```
HMNeT
 |-- data	# conll2003, mit-movie, mit-restaurant and atis
 |    |-- NER_data
 |    |    |-- twitter2015  # text data
 |    |    |    |-- train.txt
 |    |    |    |-- valid.txt
 |    |    |    |-- test.txt
 |    |    |    |-- twitter2015_train_dict.pth  # {full-image-[object-image]}
 |    |    |    |-- ...
 |    |    |-- twitter2015_images   # full image data
 |    |    |-- twitter2015_aux_images   # full image data
 |    |    |-- twitter2017
 |    |    |-- twitter2017_images
 |    |    |-- twitter2017_aux_images
 |    |-- RE_data
 |    |    |-- ...
 |-- models	# models
 |    |-- bert_model.py
 |    |-- modeling_bert.py
 |-- modules
 |    |-- metrics.py    # metric
 |    |-- train.py  # trainer
 |-- processor
 |    |-- dataset.py    # processor, dataset
 |-- logs     # code logs
 |-- run.py   # main 
 |-- run_ner_task.sh
 |-- run_re_task.sh
```

Train
==========

## NER Task

The data path and GPU related configuration are in the `run.py`. To train ner model, run this script.

```shell
bash run_ner_task.py
```

## RE Task

To train re model, run this script.

```shell
bash run_re_task.py
```

