﻿// Copyright 2010 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/// Application wrapper for a single clipboard button.
/// <author>nicksantos@google.com (Nick Santos)</author>

using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace ClosureLibrary {
  public partial class ClipboardButtonApp : Application {

    public ClipboardButtonApp() {
      this.Startup += this.Application_Startup;
      this.UnhandledException += this.Application_UnhandledException;

      InitializeComponent();
    }

    private void Application_Startup(object sender, StartupEventArgs e) {
      string callbackName = e.InitParams["callbackName"];
      ClipboardButtonType buttonType = (ClipboardButtonType) Enum.Parse(
          typeof(ClipboardButtonType), e.InitParams["buttonType"], false);

      this.RootVisual = new ClipboardButton(
          buttonType, callbackName, e.InitParams);
    }

    // Error handlers generated by MS Visual Web Developer.
    private void Application_UnhandledException(object sender, ApplicationUnhandledExceptionEventArgs e) {
      // If the app is running outside of the debugger then report the exception using
      // the browser's exception mechanism. On IE this will display it a yellow alert
      // icon in the status bar and Firefox will display a script error.
      if (!System.Diagnostics.Debugger.IsAttached) {

        // NOTE: This will allow the application to continue running after an exception has been thrown
        // but not handled.
        // For production applications this error handling should be replaced with something that will
        // report the error to the website and stop the application.
        e.Handled = true;
        Deployment.Current.Dispatcher.BeginInvoke(delegate { ReportErrorToDOM(e); });
      }
    }

    private void ReportErrorToDOM(ApplicationUnhandledExceptionEventArgs e) {
      try {
        string errorMsg = e.ExceptionObject.Message + e.ExceptionObject.StackTrace;
        errorMsg = errorMsg.Replace('"', '\'').Replace("\r\n", @"\n");

        System.Windows.Browser.HtmlPage.Window.Eval("throw new Error(\"Unhandled Error in Silverlight Application " + errorMsg + "\");");
      } catch (Exception) {
      }
    }
  }
}
