### Processed dialogue data for the Coling 2020 experiments

All of the files contain the extracted contexts of varying length for running the experiments. The only difference are the labels:

    * `extracted_contexts-03.dill`: is the original 3-way split ('telic', 'atelic', 'stative')
    * `extracted_contexts-03-state-event.dill`: label recoding of the original data to just cover 2 labels: 'state' and 'event'
    * `extracted_contexts-03-telic-atelic.dill`: filtered version of the original data, i.e. all `stative` examples were removed to just cover 'telic' and 'atelic' examples`

```
# Loading files:
from telicity.util import io

data = io.load_structured_resource('/path/to/dialogue/extracted_contexts-03-state-event.dill')
```

An example data item looks like:
```
{
    "lemma_word_map": [
        "say",
        "says"
    ],
    "target_word_index": 1,
    "label": "telic",
    "target_word_pos": "VBZ",
    "sent": "it says delta ~ e whatever .",
    "lemma_sent": "it say delta ~ e whatever .",
    "window_1": [
        "it_###POS###_PRP",
        "delta_###POS###_NN"
    ],
    "window_1_lemma": [
        "it_###POS###_PRP",
        "delta_###POS###_NN"
    ],
    "window_2": [
        "it_###POS###_PRP",
        "delta_###POS###_NN",
        "~_###POS###_NN"
    ],
    "window_2_lemma": [
        "it_###POS###_PRP",
        "delta_###POS###_NN",
        "~_###POS###_NN"
    ],
    "window_2_dependency_paths": [],
    "window_2_lemma_dependency_paths": [],
    "window_3": [
        "it_###POS###_PRP",
        "delta_###POS###_NN",
        "~_###POS###_NN",
        "e_###POS###_SYM"
    ],
    "window_3_lemma": [
        "it_###POS###_PRP",
        "delta_###POS###_NN",
        "~_###POS###_NN",
        "e_###POS###_SYM"
    ],
    "window_3_dependency_paths": [],
    "window_3_lemma_dependency_paths": [],
    "window_5": [
        "it_###POS###_PRP",
        "delta_###POS###_NN",
        "~_###POS###_NN",
        "e_###POS###_SYM",
        "whatever_###POS###_WDT"
    ],
    "window_5_lemma": [
        "it_###POS###_PRP",
        "delta_###POS###_NN",
        "~_###POS###_NN",
        "e_###POS###_SYM",
        "whatever_###POS###_WDT"
    ],
    "window_5_dependency_paths": [],
    "window_5_lemma_dependency_paths": [],
    "window_10": [
        "it_###POS###_PRP",
        "delta_###POS###_NN",
        "~_###POS###_NN",
        "e_###POS###_SYM",
        "whatever_###POS###_WDT"
    ],
    "window_10_lemma": [
        "it_###POS###_PRP",
        "delta_###POS###_NN",
        "~_###POS###_NN",
        "e_###POS###_SYM",
        "whatever_###POS###_WDT"
    ],
    "window_10_dependency_paths": [],
    "window_10_lemma_dependency_paths": [],
    "dep_1": [
        [
            "!acl:relcl",
            "it_###POS###_PRP"
        ],
        [
            "dobj",
            "delta_###POS###_NN"
        ],
        [
            "dep",
            "whatever_###POS###_WDT"
        ]
    ],
    "dep_1_lemma": [
        [
            "!acl:relcl",
            "it_###POS###_PRP"
        ],
        [
            "dobj",
            "delta_###POS###_NN"
        ],
        [
            "dep",
            "whatever_###POS###_WDT"
        ]
    ],
    "dep_1_head": [
        [
            "!acl:relcl",
            "it_###POS###_PRP"
        ]
    ],
    "dep_1_head_lemma": [
        [
            "!acl:relcl",
            "it_###POS###_PRP"
        ]
    ],
    "dep_1_children": [
        [
            "dobj",
            "delta_###POS###_NN"
        ],
        [
            "dep",
            "whatever_###POS###_WDT"
        ]
    ],
    "dep_1_children_lemma": [
        [
            "dobj",
            "delta_###POS###_NN"
        ],
        [
            "dep",
            "whatever_###POS###_WDT"
        ]
    ]
}
```
