'''
Date: 2021-06-10 18:16:13
LastEditors: Wu Xianze (wuxianze.0@bytedance.com)
LastEditTime: 2021-06-17 17:00:52
'''
import os
import json
import csv

def saveGeneralCSV(data, fname, start: list=None, delimiter=','):
    with open(fname, 'w', newline="") as fout:
        fout.write('\ufeff') # 
        writer = csv.writer(fout, delimiter=",")
        if start:
            writer.writerow(start)
        for d in data:
            outputs = d
            writer.writerow(outputs)
    print('Save {} example to {}'.format(len(data), fname))

def readTxt(path):
    datas = []
    with open(path, 'r') as fin:
        for line in fin:
            datas.append(line.strip())
    print("Reading {} example from {}".format(len(datas), path))
    return datas

def saveTxt(data, fname):
    with open(fname, 'w') as fout:
        for d in data:
            d = d.strip().replace('\n', " ").replace('\r', " ")
            fout.write('{}\n'.format(d))
    print('Save {} example to {}'.format(len(data), fname))

def readJsonl(fname):
    datas = []
    with open(fname, 'r') as fin:
        for line in fin:
            datas.append(json.loads(line.strip()))
    return datas

def dumpJsonl(datas, fname):
    with open(fname, 'w') as fout:
        for data in datas:
            fout.write(json.dumps(data, ensure_ascii=False) + '\n')

def getfiles(path):
    if os.path.isdir(path):
        files = [os.path.join(path, f) for f in os.listdir(path)]
        files = sorted(files)
    else:
        files = [path]
    return files