set -e

function join_by { local d=${1-} f=${2-}; if shift 2; then printf %s "$f" "${@/#/$d}"; fi; }

# Variables to change

# Replace with any prefix you want to use for your experiments (purely for naming purposes)
prefix="sample-ft" 

# Replace with the prefixes in the generated translations and alignments
translation_prefix="mBART" 
alignments_prefix="ft"

# Replace with the languages for which you have parallel and mono datasets respectively
parallel_langs=(fi_FI et_EE)
mono_langs=(en_XX fi_FI et_EE)
all_langs=(en et fi) # List of languages

# Replacement ratio
AA_ratio=0.9

# More or less fixed
base_dir="~/CAS" # Replace with the base directory of the project 
preprocessing_dir="~/CAS/baselines/aligned-augmentation" 
SCRIPTS_DIR="~/scripts" # Replace with directory containing Moses tokenization (and detokenization) scripts
datasets_dir="~/CAS/data" # Replace with directory containing all datasets

SPM=~/sentencepiece/build/src # Sentencepiece path
FAIRSEQ=~/fairseq/fairseq_cli # Fairseq path
multi_dict_path="~/muse/uralic.txt" # Multilingual dictionary generated by Pan et al.

# Derived
data_dir="${base_dir}/data/${prefix}"
checkpoints_dir="${base_dir}/checkpoints/${prefix}"
results_dir="${base_dir}/results/${prefix}"
dict_dir="${data_dir}/dict"
spm_dir="${data_dir}/spm"
spm_corpus="${data_dir}/spm_corpus"
dict_corpus="${data_dir}/dict_corpus"
MODEL=${spm_dir}/${prefix}.model

rm -rf ${data_dir} ${checkpoints_dir} ${results_dir} ${dict_dir} ${data_dir}/mono ${spm_dir}
mkdir -p ${data_dir} ${checkpoints_dir} ${results_dir} ${dict_dir} ${data_dir}/mono  ${spm_dir}

DICT_LANGS=""
for l in "${mono_langs[@]}"
do
    l_short="${l:0:2}"
    DICT_LANGS=${DICT_LANGS}",${l_short}"
done
DICT_LANGS=${DICT_LANGS:1}

echo "AAing En file for En->X direction..."
SRC_LANG="en_XX"
SRC_LANG_SHORT="${SRC_LANG:0:2}"

for TGT_LANG in "${train_langs[@]}"
do
    lang="${TGT_LANG:0:2}"
    PARALLEL_DIR="${datasets_dir}/en-${lang}-uralic"
    rm -rf ${PARALLEL_DIR}/preprocessed/${prefix}
done

for TGT_LANG in "${train_langs[@]}"
do
    
    lang="${TGT_LANG:0:2}"
    SRC_LANG_CAPS="${SRC_LANG_SHORT^^}"
    TGT_LANG_CAPS="${lang^^}"

    # Variables to change
    PARALLEL_DIR="${datasets_dir}/en-${lang}-uralic"
    SRC_FILE="${PARALLEL_DIR}/train.${SRC_LANG}"
    TGT_FILE="${PARALLEL_DIR}/train.${TGT_LANG}"
    SRC_FINAL="${PARALLEL_DIR}/preprocessed/${prefix}/train.AAed.${SRC_LANG_SHORT}-${lang}.${SRC_LANG_SHORT}"
    TGT_FINAL="${PARALLEL_DIR}/preprocessed/${prefix}/train.AAed.${SRC_LANG_SHORT}-${lang}.${lang}"

    echo "AAing for the En->${lang} direction..."
    mkdir -p ${PARALLEL_DIR}/preprocessed/${prefix}

    python ${preprocessing_dir}/preprocess_aa_multi.py \
        --source_file ${SRC_FILE} \
        --output_file ${SRC_FINAL} \
        --multi_dict_path ${multi_dict_path} \
        --replacement_ratio ${AA_ratio} \
        --is_parallel
    
    echo "Done"

    cp ${TGT_FILE} ${TGT_FINAL}
done

TGT_LANG="en_XX"
TGT_LANG_SHORT="${TGT_LANG:0:2}"
echo "AAing X file for X->En direction..."
for SRC_LANG in "${train_langs[@]}"
do
    lang="${SRC_LANG:0:2}"
    TGT_LANG_CAPS="${TGT_LANG_SHORT^^}"
    SRC_LANG_CAPS="${lang^^}"

    # Variables to change
    PARALLEL_DIR="${datasets_dir}/en-${lang}-uralic"
    SRC_FILE="${PARALLEL_DIR}/train.${SRC_LANG}"
    TGT_FILE="${PARALLEL_DIR}/train.${TGT_LANG}"
    SRC_FINAL="${PARALLEL_DIR}/preprocessed/${prefix}/train.AAed.${lang}-${TGT_LANG_SHORT}.${lang}"
    TGT_FINAL="${PARALLEL_DIR}/preprocessed/${prefix}/train.AAed.${lang}-${TGT_LANG_SHORT}.${TGT_LANG_SHORT}"

    echo "AAing for the ${lang}->En direction..."
    mkdir -p ${PARALLEL_DIR}/preprocessed/${prefix}

    python ${preprocessing_dir}/preprocess_aa_multi.py \
        --source_file ${SRC_FILE} \
        --output_file ${SRC_FINAL} \
        --multi_dict_path ${multi_dict_path} \
        --replacement_ratio ${AA_ratio} \
        --is_parallel
    echo "Done"
    cp $TGT_FILE $TGT_FINAL
done

for SRC_LANG in "${mono_langs[@]}"
do
    SRC_LANG_SHORT="${SRC_LANG:0:2}"
    MONO_DIR="${datasets_dir}/mono-${SRC_LANG_SHORT}"
    rm -rf ${MONO_DIR}/preprocessed/${prefix}
done

echo "AAing monolingual corpora..."
i=0
for SRC_LANG in "${mono_langs[@]}"
do
    SRC_LANG_SHORT="${SRC_LANG:0:2}"
    SRC_LANG_CAPS="${SRC_LANG_SHORT^^}"

    MONO_DIR="${datasets_dir}/mono-${SRC_LANG_SHORT}"
    SRC_FILE="${MONO_DIR}/mono.${SRC_LANG}"
    SRC_SAMPLED="${MONO_DIR}/preprocessed/${prefix}/mono.sampled.${SRC_LANG}"
    FINAL_SRC="${MONO_DIR}/preprocessed/${prefix}/mono.AAed.mono${SRC_LANG_SHORT}noised"
    FINAL_TGT="${MONO_DIR}/preprocessed/${prefix}/mono.AAed.mono${SRC_LANG_SHORT}target"

    echo "AAing the ${SRC_LANG_SHORT} mono corpus..."

    mkdir -p ${MONO_DIR}/preprocessed/${prefix}
    head -n ${mono_max_sizes[$i]} ${SRC_FILE} > ${SRC_SAMPLED}

    python ${preprocessing_dir}/preprocess_aa_multi.py \
        --source_file ${SRC_SAMPLED} \
        --output_file ${FINAL_SRC} \
        --multi_dict_path ${multi_dict_path} \
        --replacement_ratio ${AA_ratio}
    echo "Done"
    cp ${SRC_SAMPLED} ${FINAL_TGT}
    i=$((i+1))
done

rm -rf ${spm_corpus} ${dict_corpus}
touch $spm_corpus ${dict_corpus}

SRC_LANG="en_XX"
SRC_LANG_SHORT="${SRC_LANG:0:2}"

for TGT_LANG in "${train_langs[@]}"
do
    lang="${TGT_LANG:0:2}"
    PARALLEL_DIR="${datasets_dir}/en-${lang}-uralic"
    SRC_FINAL="${PARALLEL_DIR}/train.${SRC_LANG}"
    TGT_FINAL="${PARALLEL_DIR}/train.${TGT_LANG}"

    cat ${SRC_FINAL} ${TGT_FINAL} >> $spm_corpus

    SRC_FINAL="${PARALLEL_DIR}/preprocessed/${prefix}/train.AAed.*.${SRC_LANG_SHORT}"
    TGT_FINAL="${PARALLEL_DIR}/preprocessed/${prefix}/train.AAed.*.${lang}"

    cat ${SRC_FINAL} ${TGT_FINAL} >> $dict_corpus
done

for TGT_LANG in "${mono_langs[@]}"
do
    lang="${TGT_LANG:0:2}"
    MONO_DIR="${datasets_dir}/mono-${lang}"
    MONO_ORIG="${MONO_DIR}/mono.${TGT_LANG}"
    MONO_FILE="${MONO_DIR}/preprocessed/${prefix}/mono.AAed"

    cat "${MONO_FILE}.mono${lang}noised" "${MONO_FILE}.mono${lang}target" >> $dict_corpus

    cat ${MONO_ORIG} >> $spm_corpus
done

shuf $spm_corpus > "${spm_corpus}.shuf"
shuf $dict_corpus > "${dict_corpus}.shuf"

echo "Training an spm model"
${SPM}/spm_train --input="${spm_corpus}.shuf" --train_extremely_large_corpus=true --model_prefix="${spm_dir}/${prefix}" --vocab_size=32000 --character_coverage=1.0  --model_type=unigram --input_sentence_size=20000000 --shuffle_input_sentence=true
${SPM}/spm_encode --model="${MODEL}" < ${dict_corpus}.shuf > "${dict_corpus}.spm.src"

python ${FAIRSEQ}/preprocess.py \
        --source-lang src --target-lang src \
        --trainpref "${dict_corpus}.spm" \
        --destdir ${dict_dir} --only-source \
        --thresholdtgt 0 --thresholdsrc 0 \
        --dict-only --joined-dictionary  \
        --workers 128
rm -rf ${spm_corpus} ${dict_corpus} ${spm_corpus}.shuf ${dict_corpus}.shuf
for lang in "${all_langs[@]}"
do
    lang_caps="${lang^^}"
    echo -e "LANG_TOK_${lang_caps} 1" >> "${dict_dir}/dict.src.txt"
done


TRAIN_SRC="${data_dir}/train.src"
TRAIN_TGT="${data_dir}/train.tgt"
MONO_SRC="${data_dir}/mono/train.src"
MONO_TGT="${data_dir}/mono/train.tgt"
DEV_SRC="${data_dir}/dev.src"
DEV_TGT="${data_dir}/dev.tgt"

SRC_LANG="en_XX"
SRC_LANG_SHORT="${SRC_LANG:0:2}"
SRC_LANG_CAPS="${SRC_LANG_SHORT^^}"

for TGT_LANG in "${train_langs[@]}"
do
    TGT_LANG_SHORT="${TGT_LANG:0:2}"
    TGT_LANG_CAPS="${TGT_LANG_SHORT^^}"
    PARALLEL_DIR="${datasets_dir}/en-${TGT_LANG_SHORT}-uralic"

    TRAIN_PREFIX="${PARALLEL_DIR}/preprocessed/${prefix}/train.AAed.${SRC_LANG_SHORT}-${TGT_LANG_SHORT}"
    TRAIN_PREFIX_REV="${PARALLEL_DIR}/preprocessed/${prefix}/train.AAed.${TGT_LANG_SHORT}-${SRC_LANG_SHORT}"
    DEV_PREFIX="${PARALLEL_DIR}/dev"
    DEV_FINAL="${PARALLEL_DIR}/preprocessed/${prefix}/dev"

    ${SPM}/spm_encode --model=${MODEL} < ${TRAIN_PREFIX}.${SRC_LANG_SHORT} > ${TRAIN_PREFIX}.spm.${SRC_LANG_SHORT}
    ${SPM}/spm_encode --model=${MODEL} < ${TRAIN_PREFIX}.${TGT_LANG_SHORT} > ${TRAIN_PREFIX}.spm.${TGT_LANG_SHORT}

    ${SPM}/spm_encode --model=${MODEL} < ${TRAIN_PREFIX_REV}.${SRC_LANG_SHORT} > ${TRAIN_PREFIX_REV}.spm.${SRC_LANG_SHORT}
    ${SPM}/spm_encode --model=${MODEL} < ${TRAIN_PREFIX_REV}.${TGT_LANG_SHORT} > ${TRAIN_PREFIX_REV}.spm.${TGT_LANG_SHORT}

    ${SPM}/spm_encode --model=${MODEL} < ${DEV_PREFIX}.${SRC_LANG} > ${DEV_FINAL}.spm.${SRC_LANG_SHORT}
    ${SPM}/spm_encode --model=${MODEL} < ${DEV_PREFIX}.${TGT_LANG} > ${DEV_FINAL}.spm.${TGT_LANG_SHORT}

    awk -v SRC=$SRC_LANG_CAPS '{print "LANG_TOK_"SRC" " $0 } ' ${TRAIN_PREFIX}.spm.${SRC_LANG_SHORT} >> ${TRAIN_SRC}
    awk -v TGT=$TGT_LANG_CAPS '{print "LANG_TOK_"TGT" " $0 } ' ${TRAIN_PREFIX}.spm.${TGT_LANG_SHORT} >> ${TRAIN_TGT}

    awk -v SRC=$SRC_LANG_CAPS '{print "LANG_TOK_"SRC" " $0 } ' ${TRAIN_PREFIX_REV}.spm.${SRC_LANG_SHORT} >> ${TRAIN_TGT}
    awk -v TGT=$TGT_LANG_CAPS '{print "LANG_TOK_"TGT" " $0 } ' ${TRAIN_PREFIX_REV}.spm.${TGT_LANG_SHORT} >> ${TRAIN_SRC}

    awk -v SRC=$SRC_LANG_CAPS '{print "LANG_TOK_"SRC" " $0 } ' ${DEV_FINAL}.spm.${SRC_LANG_SHORT} >> ${DEV_SRC}
    awk -v TGT=$TGT_LANG_CAPS '{print "LANG_TOK_"TGT" " $0 } ' ${DEV_FINAL}.spm.${TGT_LANG_SHORT} >> ${DEV_TGT}

    awk -v SRC=$SRC_LANG_CAPS '{print "LANG_TOK_"SRC" " $0 } ' ${DEV_FINAL}.spm.${SRC_LANG_SHORT} >> ${DEV_TGT}
    awk -v TGT=$TGT_LANG_CAPS '{print "LANG_TOK_"TGT" " $0 } ' ${DEV_FINAL}.spm.${TGT_LANG_SHORT} >> ${DEV_SRC}

done

:|paste -d ' ||| ' ${TRAIN_SRC} - - - - ${TRAIN_TGT} > "${data_dir}/train"
shuf "${data_dir}/train" > "${data_dir}/train.shuf"
awk -F ' \\|\\|\\| ' '{print $1}' "${data_dir}/train.shuf" > "${data_dir}/train.shuf.src"
awk -F ' \\|\\|\\| ' '{print $2}' "${data_dir}/train.shuf" > "${data_dir}/train.shuf.tgt"

:|paste -d ' ||| ' ${DEV_SRC} - - - - ${DEV_TGT} > "${data_dir}/dev"
shuf "${data_dir}/dev" > "${data_dir}/dev.shuf"
awk -F ' \\|\\|\\| ' '{print $1}' "${data_dir}/dev.shuf" > "${data_dir}/dev.shuf.src"
awk -F ' \\|\\|\\| ' '{print $2}' "${data_dir}/dev.shuf" > "${data_dir}/dev.shuf.tgt"

python ${FAIRSEQ}/preprocess.py \
    --source-lang src --target-lang tgt \
    --trainpref ${data_dir}/train.shuf \
    --validpref ${data_dir}/dev.shuf \
    --srcdict ${dict_dir}/dict.src.txt \
    --tgtdict ${dict_dir}/dict.src.txt \
    --destdir ${data_dir} \
    --thresholdtgt 0 --thresholdsrc 0 --seed 0 \
    --amp --workers 128

for SRC_LANG_LONG in "${mono_langs[@]}"
do
    SRC_LANG="${SRC_LANG_LONG:0:2}"
    SRC_LANG_CAPS="${SRC_LANG^^}"

    MONO_DIR="${datasets_dir}/mono-${SRC_LANG}"
    TRAIN_PREFIX="${MONO_DIR}/preprocessed/${prefix}/mono.AAed"

    ${SPM}/spm_encode --model=${MODEL} < "${TRAIN_PREFIX}.mono${SRC_LANG}noised" > "${TRAIN_PREFIX}.spm.mono${SRC_LANG}noised"
    ${SPM}/spm_encode --model=${MODEL} < "${TRAIN_PREFIX}.mono${SRC_LANG}target" > "${TRAIN_PREFIX}.spm.mono${SRC_LANG}target"

    awk -v SRC=$SRC_LANG_CAPS '{print "LANG_TOK_"SRC" " $0 } ' "${TRAIN_PREFIX}.spm.mono${SRC_LANG}noised" >> "${MONO_SRC}"
    awk -v SRC=$SRC_LANG_CAPS '{print "LANG_TOK_"SRC" " $0 } ' "${TRAIN_PREFIX}.spm.mono${SRC_LANG}target" >> "${MONO_TGT}"

done

:|paste -d ' ||| ' "${data_dir}/mono/train.src" - - - - "${data_dir}/mono/train.tgt" > "${data_dir}/mono/train"
shuf "${data_dir}/mono/train" > "${data_dir}/mono/train.shuf"
awk -F ' \\|\\|\\| ' '{print $1}' "${data_dir}/mono/train.shuf" > "${data_dir}/mono/train.shuf.src"
awk -F ' \\|\\|\\| ' '{print $2}' "${data_dir}/mono/train.shuf" > "${data_dir}/mono/train.shuf.tgt"

python ${FAIRSEQ}/preprocess.py \
    --source-lang src --target-lang tgt \
    --trainpref "${data_dir}/mono/train.shuf" \
    --srcdict ${dict_dir}/dict.src.txt \
    --tgtdict ${dict_dir}/dict.src.txt \
    --destdir ${data_dir}/mono \
    --thresholdtgt 0 --thresholdsrc 0 --seed 0 \
    --amp --workers 128

sbatch train-mAAP.sh