theory question_76_1

imports Main

begin

typedecl entity
typedecl event

consts
  Organism :: "entity ⇒ bool"
  Becomes :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  TooHot :: "entity ⇒ bool"
  Dies :: "event ⇒ bool"
  Decomposers :: "entity ⇒ bool"
  Complete :: "event ⇒ bool"
  Cycle :: "entity ⇒ bool"

(* Explanation 1: If an organism becomes too hot, then decomposers complete their cycle. *)
axiomatization where
  explanation_1: "(∃e1 x. Organism x ∧ Becomes e1 ∧ Agent e1 x ∧ TooHot x) ⟶ (∃e2 y. Decomposers y ∧ Complete e2 ∧ Agent e2 y ∧ Cycle y)"

theorem hypothesis:
  assumes asm: "Organism x ∧ Becomes e1 ∧ Agent e1 x ∧ TooHot x"
  (* Hypothesis: If an organism becomes too hot, then decomposers complete their cycle. *)
  shows "∃e2 y. Decomposers y ∧ Complete e2 ∧ Agent e2 y ∧ Cycle y"
proof -
  from asm obtain e2 y where "Decomposers y ∧ Complete e2 ∧ Agent e2 y ∧ Cycle y" using explanation_1 by blast
  then show ?thesis using `Decomposers y` `Complete e2` `Agent e2 y` `Cycle y` by blast
qed

end
