theory question_30_2

imports Main

begin
typedecl entity
typedecl event

consts
  Skateboard :: "entity ⇒ bool"
  Doing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Human :: "entity ⇒ bool"

(* Explanation 1: Doing tricks on a skateboard is equivalent to doing tricks. *)
axiomatization where
  explanation_1: "∀x y e. Skateboard y ∧ Doing e ∧ Agent e x ∧ On x y ⟷ Doing e ∧ Agent e x"

(* Explanation 2: A man is a human. *)
axiomatization where  
  explanation_2: "∀x. Man x ⟶ Human x"

theorem hypothesis:
  (* Premise: A man is doing tricks on a skateboard. *)
  assumes asm: "Man x ∧ Skateboard y ∧ Doing e ∧ Agent e x ∧ On x y"
  (* Hypothesis: A human doing tricks *)
  shows "∃x e. Human x ∧ Doing e ∧ Agent e x"
proof -
  from asm have "Man x ∧ Doing e ∧ Agent e x" by blast
  then have "Human x ∧ Doing e ∧ Agent e x" using explanation_2 by blast
  show ?thesis using `Human x` `Doing e` `Agent e x` by blast
qed

end
