theory question_60_0
imports Main

begin
typedecl entity
typedecl event

consts
  Boy :: "entity ⇒ bool"
  KarateForm :: "entity ⇒ bool"
  Uniform :: "entity ⇒ bool"
  Poses :: "event ⇒ bool"
  Shows :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A boy poses in karate form and uniform means the boy shows "his uniform. *)"
axiomatization where
  explanation_1: "∀x y z e. Boy x ∧ KarateForm y ∧ Uniform z ∧ Poses e ∧ Agent e x ∧ Patient e y ∧ Patient e z ⟶ Shows e ∧ Agent e x ∧ Patient e z"

theorem hypothesis:
  (* Premise: A boy poses in karate form and uniform. *)
  assumes asm: "Boy x ∧ KarateForm y ∧ Uniform z ∧ Poses e ∧ Agent e x ∧ Patient e y ∧ Patient e z"
  (* Hypothesis: A boy shows "his uniform. *)"
  shows "∃x y e. Boy x ∧ Uniform y ∧ Shows e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Boy x ∧ Uniform z ∧ Poses e ∧ Agent e x ∧ Patient e z" by blast
  then have "Boy x ∧ Uniform z ∧ Shows e ∧ Agent e x ∧ Patient e z" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
