theory question_71_1

imports Main

begin

typedecl entity
typedecl event

consts
  Boy :: "entity ⇒ bool"
  Walking :: "event ⇒ bool"
  ShallowEnough :: "event ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"
  Through :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A boy walks on water if the water is shallow enough for him to walk. *)
axiomatization where
  explanation_1: "∀x e. Boy x ∧ Walking e ∧ ShallowEnough(e, Water) ⟶ On(e, Water)"

(* Explanation 2: If a boy is walking through the water, then the water must be shallow enough for him to walk. *)
axiomatization where
  explanation_2: "∀x e. Boy x ∧ Walking e ∧ Through(e, Water) ⟶ ShallowEnough(e, Water)"

theorem hypothesis:
  (* Premise: A boy walks through the water. *)
  assumes asm: "Boy x ∧ Walking e ∧ Through e  Water "
  (* Hypothesis: A boy walks on water. *)
  shows "∃x e. Boy x ∧ Walking e ∧ On e  Water "
proof -
  from asm have "Boy x ∧ Walking e ∧ Through e Water" by blast
  then have "ShallowEnough(e, Water)" using explanation_1 by blast
  then show ?thesis using `ShallowEnough(e, Water)` by blast
qed

end
