theory question_47_0

imports Main

begin

typedecl entity
typedecl event

consts
  Genes :: "entity ⇒ bool"
  Chromosome :: "entity ⇒ bool"
  Located :: "event ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  LinkedGenes :: "entity ⇒ bool"
  InheritedTogether :: "event ⇒ bool"

(* Explanation 1: Genes that are located on the same chromosome are called linked genes. *)
axiomatization where
  explanation_1: "∀x y e. Genes x ∧ Chromosome y ∧ Located e ∧ On x y ⟶ LinkedGenes x"

(* Explanation 2: Linked genes are inherited together. *)
axiomatization where
  explanation_2: "∀x e. LinkedGenes x ⟶ InheritedTogether e"

theorem hypothesis:
  assumes asm: "Genes x ∧ Chromosome y ∧ Located e ∧ On x y"
  (* Hypothesis: Genes are inherited together if they are located on the same chromosome. *)
  shows "∃x y e. Genes x ∧ Chromosome y ∧ Located e ∧ On x y ∧ InheritedTogether e"
proof -
  from asm have "Genes x ∧ Chromosome y ∧ Located e ∧ On x y" by simp
  then have "LinkedGenes x" using explanation_1 by blast
  then obtain e1 where e1: "InheritedTogether e1" using explanation_2 by blast
  have conclusion: "Genes x ∧ Chromosome y ∧ Located e ∧ On x y ∧ InheritedTogether e1" using asm e1 by simp
  show ?thesis using conclusion by blast
qed

end
