theory question_83_0
imports Main

begin

typedecl entity
typedecl event

consts
  ElectricalCircuit :: "entity ⇒ bool"
  WorkingProperly :: "entity ⇒ bool"
  Runs :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Computers :: "entity ⇒ bool"
  ElectricCircuits :: "entity ⇒ bool"
  Run :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: When an electrical circuit is working properly, electrical current runs through that circuit. *)
axiomatization where
  explanation_1: "∀x y e. ElectricalCircuit x ∧ WorkingProperly x ⟶ (Runs x ∧ Agent e x)"

(* Explanation 2: Currently computers run on electric circuits and wires. *)
axiomatization where
  explanation_2: "∀x y e. Computers x ∧ ElectricCircuits y ⟶ Run e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  assumes asm: "Computers x ∧ ElectricalCircuit y ∧ WorkingProperly e"
  (* Hypothesis: Computers run when electrical circuit is working properly. *)
  shows "Run e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Computers x ∧ ElectricalCircuit y ∧ WorkingProperly e" by simp
  then have "ElectricalCircuit y ∧ WorkingProperly y" using asm by blast
  then have "Runs y ∧ Agent e y" using explanation_1 by blast
  then have "Run e ∧ Agent e x ∧ Patient e y" using explanation_2 `Computers x` by blast
  then show ?thesis using asm by blast
qed

end
