theory question_61_4
imports Main
begin

typedecl entity
typedecl event

consts
  Sun :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  SolarSystem :: "entity ⇒ bool"
  LargestBody :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: The Sun is a star and the largest body in our solar system. *)
axiomatization where
  explanation_1: "∀x. Sun x ⟶ (Star x ∧ SolarSystem x ∧ LargestBody x)"

(* Explanation 2: The Sun is the largest body in our solar system and is part of the solar system. *)
axiomatization where
  explanation_2: "∀x. Sun x ∧ SolarSystem x ∧ LargestBody x ⟶ PartOf x SolarSystem"

theorem hypothesis:
  assumes asm: "SolarSystem x ∧ LargestBody x"
  (* Hypothesis: The largest body in our solar system is the Sun. *)
  shows "∃x. SolarSystem x ∧ LargestBody x ∧ Sun x"
proof -
  from asm have "SolarSystem x ∧ LargestBody x" by simp
  then have "Sun x" using explanation_1 by blast
  then have "SolarSystem x ∧ LargestBody x ∧ Sun x" using asm by blast
  then show ?thesis by blast
qed

end
