theory question_10_9

imports Main

begin

typedecl entity

consts
  Plants :: "entity ⇒ bool"
  Leaves :: "entity ⇒ bool"
  RainyClimate :: "entity ⇒ bool"
  SurviveWellIn :: "entity ⇒ entity ⇒ bool"
  WideAndFlat :: "entity ⇒ bool"

(* Explanation 1: The shape of leaves of plants that survive well in a rainy climate is most often wide and flat. *)
axiomatization where
  explanation_1: "∀x y z. Plants x ∧ Leaves y ∧ RainyClimate z ∧ SurviveWellIn x z ⟶ WideAndFlat y"

theorem hypothesis:
  assumes asm: "Plants x ∧ Leaves y ∧ RainyClimate z ∧ SurviveWellIn x z"
  (* Hypothesis: The shape of plants' leaves that survive well in a rainy climate are most often wide and flat. *)
  shows "WideAndFlat y"
proof -
  from asm have "Plants x ∧ Leaves y ∧ RainyClimate z ∧ SurviveWellIn x z" by simp
  then show ?thesis using explanation_1 by blast
qed

end
