theory question_86_0
imports Main

begin

typedecl entity
typedecl event

consts
  Snow :: "entity ⇒ bool"
  Ice :: "entity ⇒ bool"
  Water :: "entity ⇒ bool"
  Temperature :: "entity ⇒ bool"
  Between :: "entity ⇒ entity ⇒ entity ⇒ bool"
  SolidState :: "entity ⇒ bool"
  Liquid :: "entity ⇒ bool"
  Freezing :: "event ⇒ bool"
  Changing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Reducing :: "event ⇒ bool"
  HeatEnergy :: "event ⇒ bool"
  FreezingPoint :: "entity ⇒ bool"
  Freezes :: "entity ⇒ entity ⇒ bool"
  Below :: "entity ⇒ entity ⇒ bool"
  State :: "entity ⇒ bool"
  Form :: "entity ⇒ bool"
  Appears :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: snow is a kind of ice. *)
axiomatization where
  explanation_1: "∀x. Snow x ⟶ Ice x"

(* Explanation 2: water is in the solid state , called ice , for temperatures between 0; -459; -273 and 273; 32; 0. *)
axiomatization where
  explanation_2: "∀x y. Water x ∧ Temperature y ∧ Between y (of_int (-273)) (of_int 0) ∧ Between y (of_int (-459)) (of_int 32) ∧ Between y (of_int 0) (of_int 273) ⟶ SolidState x ∧ Ice x"

(* Explanation 3: water is a kind of liquid. *)
axiomatization where
  explanation_3: "∀x. Water x ⟶ Liquid x"

(* Explanation 4: freezing means changing from a liquid into a solid by reducing heat energy. *)
axiomatization where
  explanation_4: "∀e. Freezing e ⟷ (∃x y. Liquid x ∧ Solid y ∧ Changing e ∧ Agent e x ∧ Patient e y ∧ Reducing e ∧ HeatEnergy e)"

(* Explanation 5: freezing point means temperature at which a liquid freezes; below which a liquid freezes. *)
axiomatization where
  explanation_5: "∀x. FreezingPoint x ⟷ Temperature x ∧ (∃y. Liquid y ∧ Freezes y x) ∨ (∃y. Liquid y ∧ Below y x)"

(* Explanation 6: state means form. *)
axiomatization where
  explanation_6: "∀x y. State x ⟷ Form y"

theorem hypothesis:
  assumes asm: "Snow x"
  (* Hypothesis: Snow is the form of water that appears when the temperature is below freezing. *)
  shows "Water x ∧ ∃y. Temperature y ∧ Below y Freezing ∧ Appears x y"
proof -
  from asm have "Snow x" by simp
  then have "Ice x" using explanation_1 by blast
  then have "Water x ∧ SolidState x" using explanation_2 by blast
  then obtain y where "Temperature y" and "Below y Freezing" using explanation_5 by blast
  then have "Appears x y" using explanation_6 by blast
  show ?thesis using asm `Water x` `Temperature y` `Below y Freezing` `Appears x y` by blast
qed

end
