theory question_99_8
imports Main

begin

typedecl entity
typedecl event

consts
  GreenBeans :: "entity ⇒ bool"
  Respond :: "entity ⇒ event ⇒ bool"
  DailyCycle :: "event ⇒ bool"
  SeasonalCycle :: "event ⇒ bool"
  Disease :: "event ⇒ bool"

theorem hypothesis:
  assumes asm: "Respond g  DailyCycle ∨ SeasonalCycle ∨ Disease "
  (* Hypothesis: Green beans respond to daily and seasonal cycles and to disease. *)
  shows "Respond g DailyCycle ∧ Respond g SeasonalCycle ∧ Respond g Disease"
proof -
  from asm have "Respond g DailyCycle ∨ SeasonalCycle ∨ Disease " by simp
  then obtain e where e: "Respond g e ∨ e = SeasonalCycle ∨ e = Disease" by blast
  then have "e = DailyCycle ∨ e = SeasonalCycle ∨ e = Disease" by auto
  then have "Respond g DailyCycle ∧ Respond g SeasonalCycle ∧ Respond g Disease" by blast
  then show ?thesis by simp
qed

end
