import os

from dotenv import load_dotenv
from openai import OpenAI

load_dotenv(override=True)

client = OpenAI(
    api_key=os.environ["OPENAI_API_KEY"],
    organization=os.environ["OPENAI_ORGANIZATION_KEY"],
)


def join_hist(hist):
    convo = ""
    for row in hist:
        if row["role"] == "system":
            continue
        elif row["role"] == "Buyer":
            convo += "Buyer: " + row["content"] + "\n"
        else:
            convo += "Seller: " + row["content"] + "\n"
    return convo


def chatgpt_chatbot_price_extraction(messages):
    completion = client.chat.completions.create(
        model="gpt-4o",
        messages=messages,
        max_tokens=20,
        temperature=0.1,
    )
    answer = completion.choices[0].message.content.strip()
    return answer


def chatgpt_chatbot_editing(messages):
    completion = client.chat.completions.create(
        model="gpt-4o",
        messages=messages,
        max_tokens=150,
        temperature=0.5,
    )
    answer = completion.choices[0].message.content.strip()
    return answer


def chatgpt_chatbot_finalfeedback(messages):
    completion = client.chat.completions.create(
        model="gpt-4o",
        messages=messages,
        max_tokens=300,
        temperature=0.7,
    )
    answer = completion.choices[0].message.content.strip()
    # print(response)
    return answer


def chatgpt_zero_shot_classification(messages):
    completion = client.chat.completions.create(
        model="gpt-4o",
        messages=messages,
        max_tokens=20,
        temperature=0.1,
    )
    answer = completion.choices[0].message.content.strip()
    # print(response)
    return answer


def comments_summarizer(messages):
    completion = client.chat.completions.create(
        model="gpt-4o",
        messages=messages,
        max_tokens=250,
        temperature=0.5,
    )
    answer = completion.choices[0].message.content.strip()
    return answer


def message_reeditor(messages):
    completion = client.chat.completions.create(
        model="gpt-4o",
        messages=messages,
        max_tokens=100,
        temperature=0.8,
    )
    answer = completion.choices[0].message.content.strip()
    return answer
