def naive_extra(instruction, history, skill_set, obs):
    return\
f"""Objective: To successfully achieve your goal, execute a sequence of skills listed below. The order of execution should be logical and based on the situation provided. Only use skills from the specified skill set for decision-making and scoring. Any skills not listed are not to be considered for this task.

Context:
Goal: Specify the goal you're trying to achieve.
Previously completed skills: List the skills that have been used previously. These skills are now ineligible for further scoring or use.
Room and visible objects: Describe objects that are currently visible and can be interacted with. If necessary objects are not visible, you must first find them. If an object is not visible or If you haven't grabbed it before, you cannot grab or put it somewhere. 
Skill set: Provide a list of available skills.

Scoring Guidelines:
+2 (Highly Beneficial): Immediate substantial benefits, executable now. The skills should be executed in continuation of the previously completed skills provided below. For visible objects, both grab and sit object can score 2 points, but if an object is not visible, finding it first should score 2 points. Additionally, to put an object, you must have previously executed the grab action.
+1 (Beneficial): Significant or preparatory step, notable progression.
0 (Neutral): Indirectly related, minimal contribution.
-1 (Potentially Detrimental): Indirectly impedes the goal, irrelevant.
-2 (Directly Detrimental): Directly interferes with the goal or has the opposite effect.

The scoring should relate to the previously completed skills. Assign a score to each skill within the provided skill set, reflecting its potential impact on achieving the goal. It is crucial to identify one skill that stands out as most beneficial (2 points) and then score the remaining skills according to their effectiveness and relevance to the goal.
You can grab object, put object, and sit object with visible objects, but if they are not visible, you must execute find object first.

Format for Response:
skill_a: 2
skill_b: 1
skill_c: 0
skill_d: -1
skill_e: -2
Continue assigning points for the remaining skills based on the provided scoring guidelines.
Make sure to evaluate each skill in the skill list according to its impact on achieving the goal.

User Input
Goal: {instruction}
Previously completed skills: {history}
{obs}
Skill set:
{skill_set}
Response:
"""

def naive(instruction, history, skill_set, objects, grab, relational_expert):
    return \
f"""Robot: Hi there, I'm a robot operating in an house. You can ask me to do various tasks and I'll tell you how much each action helps in accomplishing the task.
This is my scoring guidelines
2 Points: An action that should follow the given previous completed actions.
1 Point: Actions that can indirectly perform or assist the action that would receive 2 points.
0 Points: Actions involving visible objects that do not affect the task.
-1 Point: Actions that involve finding for objects unrelated to the task.
-2 Points: Actions that involve grabbing or placing invisible objects, i.e., actions that cannot be executed in their current state.

Actions such as grab, put, open, sit, switch on and close cannot be performed on invisible objects. Additionally, the close action cannot be executed if there has been no prior open action in previous completed actions.
If you provide information according to the following format, I will score each action from -2 to 2 in the form of "action_name: score\naction_name: score\n...
Task Description: Specify the goal you're trying to achieve.
Action List: Provide a list of available actions in your home. I will answer each action in list.
Previously Completed Actions: List the actions that have been used previously.
Visible objects: The objects currently visible to the eyes.
Grabbed: The objects currently being held in the hand.
Relevant objects: Among the currently visible objects, these are related to task.

Now you can ask for scores for actions.
Answer format:
skill name: score

Human:
Task Description: {instruction}
Action List: {skill_set}
Previously Completed Actions: {history}
Visible objects: {objects}
Grabbed: {grab}
Relevant objects: {relational_expert}
Scoring each action in action list.
Robot: 
"""


def rag_robot(current_prompt, rags):
    return \
f"""Robot: Hi there, I'm a robot operating in an house. You can ask me to do various tasks and I'll tell you how much each action helps in accomplishing the task. I can also help you find objects relevant to the task.

These are my scoring guidelines.
2 Points: An action that should follow the given previous completed actions. This score is exclusively awarded to only one specific action, ensuring that no other actions receive the same high rating.
1 Point: Actions that can indirectly perform or assist the action that would receive 2 points.
0 Points: Actions involving visible objects that do not affect the task.
-1 Point: Actions that involve finding for objects unrelated to the task.
-2 Points: Actions that involve grabbing or placing invisible objects, i.e., actions that cannot be executed in their current state.
Actions such as grab, put, open, and close cannot be performed on invisible objects. Additionally, the close action cannot be executed if there has been no prior open action in previous completed actions.

Actions such as grab, put, open, sit, switch on and close cannot be performed on invisible objects. Additionally, the close action cannot be executed if there has been no prior open action in previous completed actions.

Task Description: Specify the goal you're trying to achieve.
Action List: close bathroomcabinet, close fridge, close microwave, find bathroomcounter, find bathtub, find bed, find bookshelf, find closetdrawer, find coffeetable, find desk, find fridge, find kitchentable, find microwave, find sink, find sofa, find toaster, find wallshelf, grab apple, grab bananas, grab book, grab breadslice, grab cat, grab cellphone, grab cereal, grab clothespants, grab creamybuns, grab pillow, grab salmon, grab toothbrush, grab toothpaste, open bathroomcabinet, open fridge, open microwave, put apple in fridge, put apple in microwave, put apple on breadslice, put apple on sink, put bananas in fridge, put bananas on breadslice, put bananas on sink, put breadslice on kitchentable, put cat on bathtub, put cat on bed, put cat on desk, put cellphone in fridge, put cereal in fridge, put cereal on kitchentable, put clothespants on bathroomcounter, put clothespants on bed, put creamybuns in fridge, put creamybuns on kitchentable, put salmon in fridge, put salmon in microwave, put toothpaste in bathroomcabinet, sit bed, sit sofa, switch on microwave, switch on toaster
Previously Completed Actions: List the actions that have been used previously.
Visible objects: The objects currently visible to the eyes. Find the objects relevant to the task description among these objects.
Grabbed: The objects currently being held in the hand.
Relevant objects: Among the currently visible objects, these are related to task.

Now you can ask for scores for actions related to the task and identify objects relevant to the task among those currently visible.

{rags[0]}

{rags[1]}

{rags[2]}

{current_prompt}

Robot: 
"""



def ICL(instruction, history, skill_set, obs, grab, samples):
    return \
f"""Robot: Hi there, I'm a robot operating in an house. You can ask me to do various tasks and I'll tell you how much each action helps in accomplishing the task. I can also help you find objects relevant to the task.

These are my scoring guidelines.
2 Points: An action that should follow the given previous completed actions. This score is exclusively awarded to only one specific action, ensuring that no other actions receive the same high rating.
1 Point: Actions that can indirectly perform or assist the action that would receive 2 points.
0 Points: Actions involving visible objects that do not affect the task.
-1 Point: Actions that involve finding for objects unrelated to the task.
-2 Points: Actions that involve grabbing or placing invisible objects, i.e., actions that cannot be executed in their current state.
Actions such as grab, put, open, and close cannot be performed on invisible objects. Additionally, the close action cannot be executed if there has been no prior open action in previous completed actions.

If you provide information according to the following format, I will score each action from -2 to 2 in the form of "action_name: score\naction_name: score\n(Apply the same format to all actions in Action list.)\nRelevant objects: object list"

Task Description: Specify the goal you're trying to achieve.
Action List: close bathroomcabinet, close fridge, close microwave, find bathroomcounter, find bathtub, find bed, find bookshelf, find closetdrawer, find coffeetable, find desk, find fridge, find kitchentable, find microwave, find sink, find sofa, find toaster, find wallshelf, grab apple, grab bananas, grab book, grab breadslice, grab cat, grab cellphone, grab cereal, grab clothespants, grab creamybuns, grab pillow, grab salmon, grab toothbrush, grab toothpaste, open bathroomcabinet, open fridge, open microwave, put apple in fridge, put apple in microwave, put apple on breadslice, put apple on sink, put bananas in fridge, put bananas on breadslice, put bananas on sink, put breadslice on kitchentable, put cat on bathtub, put cat on bed, put cat on desk, put cellphone in fridge, put cereal in fridge, put cereal on kitchentable, put clothespants on bathroomcounter, put clothespants on bed, put creamybuns in fridge, put creamybuns on kitchentable, put salmon in fridge, put salmon in microwave, put toothpaste in bathroomcabinet, sit bed, sit sofa, switch on microwave, switch on toaster
Previously Completed Actions: List the actions that have been used previously.
Visible objects: The objects currently visible to the eyes. Find the objects relevant to the task description among these objects.
Grabbed: The objects currently being held in the hand.

{samples[0]}

{samples[1]}

{samples[2]}

Human:
Task Description: {instruction}
Action List: {skill_set}
Previously Completed Actions: {history}
Visible objects: {obs}
Grabbed: {grab}

Robot: 
"""



def Cot(instruction, history, skill_set, obs, grab, samples):
        return \
f"""Robot: Hi there, I'm a robot operating in an house. You can ask me to do various tasks and I'll tell you how much each action helps in accomplishing the task. I can also help you find objects relevant to the task.

These are my scoring guidelines.
2 Points: An action that should follow the given previous completed actions. This score is exclusively awarded to only one specific action, ensuring that no other actions receive the same high rating.
1 Point: Actions that can indirectly perform or assist the action that would receive 2 points.
0 Points: Actions involving visible objects that do not affect the task.
-1 Point: Actions that involve finding for objects unrelated to the task.
-2 Points: Actions that involve grabbing or placing invisible objects, i.e., actions that cannot be executed in their current state.
Actions such as grab, put, open, and close cannot be performed on invisible objects. Additionally, the close action cannot be executed if there has been no prior open action in previous completed actions.

{samples[0]}

{samples[0]}

{samples[0]}

Human:
Task Description: {instruction}
Action List: {skill_set}
Previously Completed Actions: {history}
Visible objects: {obs}
Grabbed: {grab}

Robot: 
"""



def rag_general(instruction, history, objects, grab,  samples):
    return \
f"""Objective: To successfully achieve your goal, execute a sequence of skills listed below. The order of execution should be logical and based on the situation provided. Only use skills from the specified skill set for decision-making and scoring. Any skills not listed are not to be considered for this task.

Scoring Guidelines:
2 Points (Highly Beneficial Action): Awarded to a single skill that is crucial for directly achieving the goal, delivering immediate and substantial benefits, and can be executed in its current state.
1 Point (Beneficial Action): Allocated to skills that are significant steps or preparatory actions toward the goal, facilitating notable progression or preparation, and are executable in their current state.
0 Points (Neutral Action): Given to skills that are either indirectly related to the goal or have minimal contribution towards its achievement, essentially actions that are tangential to the current objective, but still executable in their current state.
-1 Point (Potentially Detrimental Action): Assigned to skills that, without directly blocking the goal, can indirectly impede its achievement, squander time on activities unrelated to the objective, or cannot be executed in their current state.
-2 Points (Directly Detrimental Action): Awarded to skills that directly interfere with goal achievement or have an effect opposite to the intended goal.

Task Description: Specify the goal you're trying to achieve.
Action List: close bathroomcabinet, close fridge, close microwave, find bathroomcounter, find bathtub, find bed, find bookshelf, find closetdrawer, find coffeetable, find desk, find fridge, find kitchentable, find microwave, find sink, find sofa, find toaster, find wallshelf, grab apple, grab bananas, grab book, grab breadslice, grab cat, grab cellphone, grab cereal, grab clothespants, grab creamybuns, grab pillow, grab salmon, grab toothbrush, grab toothpaste, open bathroomcabinet, open fridge, open microwave, put apple in fridge, put apple in microwave, put apple on breadslice, put apple on sink, put bananas in fridge, put bananas on breadslice, put bananas on sink, put breadslice on kitchentable, put cat on bathtub, put cat on bed, put cat on desk, put cellphone in fridge, put cereal in fridge, put cereal on kitchentable, put clothespants on bathroomcounter, put clothespants on bed, put creamybuns in fridge, put creamybuns on kitchentable, put salmon in fridge, put salmon in microwave, put toothpaste in bathroomcabinet, sit bed, sit sofa, switch on microwave, switch on toaster
Previously Completed Actions: List the actions that have been used previously.
Visible objects: The objects currently visible to the eyes. Find the objects relevant to the task description among these objects.
Grabbed: The objects currently being held in the hand.

{samples[0]}

{samples[0]}

{samples[0]}

Task Description: {instruction}
Previously Completed Actions: {history}
Visible objects: {objects}
Grabbed: {grab}
Response:"""

