import json
from tqdm import tqdm
import copy
import time
import requests
import traceback


def retrieve_data_mul_iter(model, args):
    """
    使用多个迭代检索数据。
    
    Args:
        model: 检索模型
        args: 参数对象，包含evaluate_task_data_path参数，指定待检索数据文件路径
    
    Returns:
        None
    """
    """
    检索数据
    """
    ds = [json.loads(data_str) for data_str in open(args.evaluate_task_data_path).readlines()]
    predict_wp = args.evaluate_task_data_path.replace("data/","data/output/") 
    output_l = [] 
    c = 0   
    with open(predict_wp, 'w', encoding= 'utf8') as fw:
        for ix, sample in enumerate(tqdm(ds)):
            retrieve_result = copy.deepcopy(sample)
            retrieve_result["prompt"] = ""
            retrieve_result["sucess_code"] = 2
            if type(sample["verify"]) != dict or "revise" not in sample["verify"]:
                retrieve_result["retrieve_error"] = "format_error"
                retrieve_result["sucess_code"] = 0             
            else:
                if sample["verify"]["revise"].strip():
                    c += 1
                    try:
                        retrieve_refer = model.query_references(sample["verify"]["revise"]) 
                        retrieve_result["prompt"] = retrieve_refer["prompt"]
                        retrieve_result["prompt"] = "#Ouestion-Answering-in-Context-Task#" + \
                        retrieve_result["prompt"]
                        retrieve_result["sucess_code"] = 1
                    except ValueError as e:
                        retrieve_result["retrieve_error"] = e
                        retrieve_result["sucess_code"] = 0
            json.dump(retrieve_result, fw, ensure_ascii=False)
            fw.write('\n')  


def retrieve_data_single_iter(model, args):
    """
    使用单个迭代检索数据。
    
    Args:
        model: 检索模型，应实现query_references方法。
        args: 包含evaluate_task_data_path参数的argparse.Namespace对象。
    
    Returns:
        None
    """
    """
    检索数据
    """
    ds = [json.loads(data_str) for data_str in open(args.evaluate_task_data_path).readlines()]
    predict_wp = args.evaluate_task_data_path.replace("data/other_dataset/", 
    "data/other_dataset_output/") 
    output_l = [] 
    c = 0   
    with open(predict_wp, 'w', encoding= 'utf8') as fw:
        for ix, sample in enumerate(tqdm(ds)):
            retrieve_result = copy.deepcopy(sample)
            retrieve_result["prompt"] = ""
            retrieve_result["sucess_code"] = 2
            try:
                retrieve_refer = model.query_references(sample["question"]) 
                retrieve_result["prompt"] = retrieve_refer["prompt"] 
                retrieve_result["prompt"] = "#Ouestion-Answering-in-Context-Task#" + \
                retrieve_result["prompt"]
                retrieve_result["sucess_code"] = 1
            except ValueError as e:
                retrieve_result["retrieve_error"] = e
                retrieve_result["sucess_code"] = 0
            json.dump(retrieve_result, fw, ensure_ascii=False)
            fw.write('\n') 
