/*
 * Decompiled with CFR 0.152.
 */
package tsg.parser;

import java.util.ArrayList;
import java.util.Hashtable;
import settings.Parameters;
import tsg.parser.CacheManager;
import tsg.parser.Cell;
import tsg.parser.TestSet;

public class RamCacheManager
extends CacheManager {
    Hashtable<ArrayList<Integer>, Cell> cellIndex = new Hashtable();

    public RamCacheManager(TestSet test) {
        super(test);
    }

    @Override
    public int inquire(ArrayList<Integer> subString) {
        if (!Parameters.cachingActive || subString.size() < 1) {
            return 0;
        }
        if (!this.test.containsSubString(subString)) {
            return 0;
        }
        if (this.cellIndex.containsKey(subString)) {
            return 1;
        }
        return -1;
    }

    @Override
    public void writeToCache(Cell cellToStore) {
        this.cellIndex.put(cellToStore.yield, cellToStore);
    }

    @Override
    public Cell readFromCache(ArrayList<Integer> yield) {
        return this.cellIndex.get(yield);
    }
}

