/*
 * Decompiled with CFR 0.152.
 */
package segmenter;

import segmenter.IMatrix;

public class WindowMatrix
implements IMatrix {
    public double[][] matrix;
    private int numPoints = 0;
    private int windowSize = 0;
    private int[] rowStarts;
    private int[] rowEnds;
    private int[] columnStarts;
    private int[] columnEnds;

    public WindowMatrix(int n, int n2) {
        this.numPoints = n;
        this.windowSize = n2;
        this.matrix = new double[n][n2];
        this.columnStarts = new int[this.numPoints];
        this.columnEnds = new int[this.numPoints];
        this.rowStarts = new int[this.numPoints];
        this.rowEnds = new int[this.numPoints];
    }

    @Override
    public void SetColumnEnd(int n, int n2) {
        this.columnEnds[n] = n2;
    }

    @Override
    public void SetColumnStart(int n, int n2) {
        this.columnStarts[n] = n2;
    }

    @Override
    public void SetElement(int n, int n2, double d) throws Exception {
        int n3 = this.rowStarts[n];
        int n4 = n2 - n3;
        this.matrix[n][n4] = d;
    }

    @Override
    public void SetRowEnd(int n, int n2) {
        this.rowEnds[n] = n2;
    }

    @Override
    public void SetRowStart(int n, int n2) {
        this.rowStarts[n] = n2;
    }

    @Override
    public int GetColumnEnd(int n) {
        return this.columnEnds[n];
    }

    @Override
    public int GetColumnStart(int n) {
        return this.columnStarts[n];
    }

    @Override
    public double GetElement(int n, int n2) throws Exception {
        int n3 = this.rowStarts[n];
        int n4 = n2 - n3;
        return this.matrix[n][n4];
    }

    @Override
    public int GetNumColumns() {
        return this.windowSize;
    }

    @Override
    public int GetNumRows() {
        return this.numPoints;
    }

    @Override
    public int GetRowEnd(int n) {
        return this.rowEnds[n];
    }

    @Override
    public int GetRowStart(int n) {
        return this.rowStarts[n];
    }

    @Override
    public double[][] GetMatrix() {
        return this.matrix;
    }

    @Override
    public void PrintActualMatrix() {
        System.out.println("\nActual matrix:");
        for (int i = 0; i < this.matrix.length; ++i) {
            System.out.println("row " + String.valueOf(i));
            System.out.print("\t");
            for (int j = 0; j < this.GetNumColumns(); ++j) {
                System.out.println(String.valueOf(j) + ": " + String.valueOf(this.matrix[i][j]) + ", ");
            }
        }
    }

    @Override
    public void PrintAbstractMatrix() {
        System.out.println("\nAbstract matrix:");
        for (int i = 0; i < this.numPoints; ++i) {
            System.out.println("row " + String.valueOf(i));
            System.out.print("\t");
            for (int j = 0; j < this.numPoints; ++j) {
                String string = "-";
                try {
                    string = String.valueOf(this.GetElement(i, j));
                }
                catch (Exception exception) {
                    string = "-INF";
                }
                System.out.println(String.valueOf(j) + ": " + string + ", ");
            }
        }
    }

    @Override
    public void PrintOffsets() {
        int n;
        System.out.println("\nRow starts and ends: ");
        for (n = 0; n < this.rowStarts.length; ++n) {
            System.out.print("row " + String.valueOf(n) + ": ");
            System.out.print("start " + this.GetRowStart(n));
            System.out.print("; end  " + this.GetRowEnd(n));
            System.out.println();
        }
        System.out.print("Column starts and ends: ");
        for (n = 0; n < this.columnStarts.length; ++n) {
            System.out.print("col " + String.valueOf(n) + ": ");
            System.out.print("start " + this.GetColumnStart(n));
            System.out.print("; end  " + this.GetColumnEnd(n));
            System.out.println();
        }
    }
}

