/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.classify.Classifier;
import com.aliasi.classify.ScoredClassification;
import com.aliasi.classify.ScoredClassifier;
import com.aliasi.matrix.Vector;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.BoundedPriorityQueue;
import com.aliasi.util.Scored;
import com.aliasi.util.ScoredObject;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigVectorClassifier
implements Classifier<Vector, ScoredClassification>,
ScoredClassifier<Vector>,
Serializable {
    static final long serialVersionUID = 5149230080619243511L;
    private final int[] mTermIndexes;
    private final int[] mDocumentIds;
    private final float[] mScores;
    private final String[] mCategories;
    private int mMaxResults;

    public BigVectorClassifier(Vector[] termVectors, int maxResults) {
        this(termVectors, BigVectorClassifier.categoriesFor(termVectors), maxResults);
    }

    public BigVectorClassifier(Vector[] termVectors, String[] categories, int maxResults) {
        this.mCategories = categories;
        this.mTermIndexes = new int[termVectors.length];
        int size = termVectors.length;
        for (Vector termVector : termVectors) {
            size += termVector.nonZeroDimensions().length;
        }
        this.mDocumentIds = new int[size];
        this.mScores = new float[size];
        int pos = 0;
        for (int i = 0; i < termVectors.length; ++i) {
            this.mTermIndexes[i] = pos;
            Vector termVector = termVectors[i];
            int[] nzDims = termVector.nonZeroDimensions();
            for (int k = 0; k < nzDims.length; ++k) {
                int j;
                this.mDocumentIds[pos] = j = nzDims[k];
                this.mScores[pos] = (float)termVector.value(j);
                ++pos;
            }
            this.mDocumentIds[pos] = -1;
            ++pos;
        }
        this.setMaxResults(maxResults);
    }

    BigVectorClassifier(int[] termIndexes, int[] documentIds, float[] scores, String[] categories, int maxResults) {
        this.mTermIndexes = termIndexes;
        this.mDocumentIds = documentIds;
        this.mScores = scores;
        this.setMaxResults(maxResults);
        this.mCategories = categories;
    }

    static String[] categoriesFor(Vector[] termVectors) {
        int max = 0;
        for (Vector termVector : termVectors) {
            int[] nzDims = termVector.nonZeroDimensions();
            for (int k = 0; k < nzDims.length; ++k) {
                max = Math.max(max, nzDims[k]);
            }
        }
        String[] categories = new String[max];
        for (int i = 0; i < categories.length; ++i) {
            categories[i] = Integer.toString(i);
        }
        return categories;
    }

    public int maxResults() {
        return this.mMaxResults;
    }

    public void setMaxResults(int maxResults) {
        if (maxResults < 1) {
            String msg = "Max results must be positive. Found maxResults=" + maxResults;
            throw new IllegalArgumentException(msg);
        }
        this.mMaxResults = maxResults;
    }

    @Override
    public ScoredClassification classify(Vector x) {
        int k;
        int[] nzDims = x.nonZeroDimensions();
        int heapSize = 0;
        for (int k2 = 0; k2 < nzDims.length; ++k2) {
            if (nzDims[k2] >= this.mTermIndexes.length) continue;
            ++heapSize;
        }
        int[] current = new int[heapSize];
        float[] vals = new float[heapSize];
        int j = 0;
        for (k = 0; k < heapSize; ++k) {
            if (nzDims[k] >= this.mTermIndexes.length) continue;
            current[j] = this.mTermIndexes[nzDims[k]];
            vals[j] = (float)x.value(nzDims[k]);
            ++j;
        }
        k = (heapSize + 1) / 2;
        while (--k >= 0) {
            BigVectorClassifier.heapify(k, heapSize, current, vals, this.mDocumentIds);
        }
        BoundedPriorityQueue<ScoredDoc> queue = new BoundedPriorityQueue<ScoredDoc>(ScoredObject.comparator(), this.mMaxResults);
        int[] documentIds = this.mDocumentIds;
        while (heapSize > 0) {
            int doc = documentIds[current[0]];
            double score = 0.0;
            while (heapSize > 0 && documentIds[current[0]] == doc) {
                score += (double)(vals[0] * this.mScores[current[0]]);
                current[0] = current[0] + 1;
                if (documentIds[current[0]] == -1 && --heapSize > 0) {
                    current[0] = current[heapSize];
                    vals[0] = vals[heapSize];
                }
                BigVectorClassifier.heapify(0, heapSize, current, vals, documentIds);
            }
            queue.offer(new ScoredDoc(doc, score));
        }
        String[] categories = new String[queue.size()];
        double[] scores = new double[queue.size()];
        int pos = 0;
        for (ScoredDoc sd : queue) {
            categories[pos] = Integer.toString(sd.docId());
            scores[pos] = sd.score();
            ++pos;
        }
        return new ScoredClassification(categories, scores);
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    static void heapify(int i, int heapSize, int[] current, float[] vals, int[] documentIds) {
        while (true) {
            int left;
            if ((left = 2 * (i + 1) - 1) >= heapSize) {
                return;
            }
            if (documentIds[current[i]] > documentIds[current[left]]) {
                BigVectorClassifier.swap(left, i, current);
                BigVectorClassifier.swap(left, i, vals);
                i = left;
                continue;
            }
            int right = left + 1;
            if (right >= heapSize) {
                return;
            }
            if (documentIds[current[i]] <= documentIds[current[right]]) break;
            BigVectorClassifier.swap(right, i, current);
            BigVectorClassifier.swap(right, i, vals);
            i = right;
        }
    }

    static void printHeap(int heapSize, int[] current, float[] vals, int[] documentIds) {
        System.out.println("\nHeapSize=" + heapSize);
        for (int i = 0; i < heapSize; ++i) {
            System.out.println("i=" + i + " curent=" + current[i] + " vals=" + vals[i] + " docId=" + documentIds[current[i]]);
        }
    }

    static void swap(int i, int j, int[] xs) {
        int tempXsI = xs[i];
        xs[i] = xs[j];
        xs[j] = tempXsI;
    }

    static void swap(int i, int j, float[] xs) {
        float tempXsI = xs[i];
        xs[i] = xs[j];
        xs[j] = tempXsI;
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = 3954262240692411543L;
        private final BigVectorClassifier mClassifier;

        public Serializer() {
            this(null);
        }

        public Serializer(BigVectorClassifier classifier) {
            this.mClassifier = classifier;
        }

        public void writeExternal(ObjectOutput objOut) throws IOException {
            Serializer.writeInts(this.mClassifier.mTermIndexes, objOut);
            Serializer.writeInts(this.mClassifier.mDocumentIds, objOut);
            Serializer.writeFloats(this.mClassifier.mScores, objOut);
            Serializer.writeUTFs(this.mClassifier.mCategories, objOut);
            objOut.writeInt(this.mClassifier.mMaxResults);
        }

        public Object read(ObjectInput objIn) throws ClassNotFoundException, IOException {
            int[] termIndexes = Serializer.readInts(objIn);
            int[] documentIds = Serializer.readInts(objIn);
            float[] scores = Serializer.readFloats(objIn);
            String[] categories = Serializer.readUTFs(objIn);
            int maxResults = objIn.readInt();
            return new BigVectorClassifier(termIndexes, documentIds, scores, categories, maxResults);
        }
    }

    static class ScoredDoc
    implements Scored {
        private final int mDocId;
        private final double mScore;

        public ScoredDoc(int docId, double score) {
            this.mDocId = docId;
            this.mScore = score;
        }

        public int docId() {
            return this.mDocId;
        }

        public double score() {
            return this.mScore;
        }

        public String toString() {
            return this.mDocId + ":" + this.mScore;
        }
    }
}

