/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.KernelFunction;
import com.aliasi.matrix.Vector;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class HyperbolicTangentKernel
implements KernelFunction,
Serializable {
    static final long serialVersionUID = -4623910478151947840L;
    private final double mK0;
    private final double mK1;

    public HyperbolicTangentKernel(double k0, double k1) {
        if (Double.isInfinite(k0) || Double.isNaN(k0)) {
            String msg = "k0 must be a finite number. Found k0=" + k0;
            throw new IllegalArgumentException(msg);
        }
        if (Double.isInfinite(k1) || Double.isNaN(k1) || k1 == 0.0) {
            String msg = "k1 must be a finite, non-zero number. Found k1=" + k1;
            throw new IllegalArgumentException(msg);
        }
        this.mK0 = k0;
        this.mK1 = k1;
    }

    public double proximity(Vector v1, Vector v2) {
        return Math.tanh(this.mK1 * v1.dotProduct(v2) + this.mK0);
    }

    public String toString() {
        return "HyperbolicTangentKernel(" + this.mK0 + ", " + this.mK1 + ")";
    }

    Object writeReplace() {
        return new Externalizer(this.mK0, this.mK1);
    }

    static class Externalizer
    extends AbstractExternalizable {
        static final long serialVersionUID = 5756879441704225246L;
        final double mK0;
        final double mK1;

        public Externalizer() {
            this(0.0, 0.0);
        }

        public Externalizer(double k0, double k1) {
            this.mK0 = k0;
            this.mK1 = k1;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeDouble(this.mK0);
            out.writeDouble(this.mK1);
        }

        public Object read(ObjectInput in) throws IOException {
            double k0 = in.readDouble();
            double k1 = in.readDouble();
            return new HyperbolicTangentKernel(k0, k1);
        }
    }
}

