/* weightd formluas, soft formulas */

/* (sf1) The larger is the score of phrase mapping to se manticitem, the more likely the corresponding phrase should been chosen. */
weight w_resource_prior: Double+;
factor: for Int p, Int r, Double s
	if candPhrase(p) & candResource(r) & priorMatch(p, r) & priorMatchScore(p, r, s)
	add [hasResource(p, r)] * s * w_resource_prior;
	
/* (sf2) The larger is the score of phrase mapping to semantic item, the more likely the corresponding phrase and semantic item should been chosen. */
weight w_phrase_prior: Double+;
factor: for Int p, Int r, Double s
	if candPhrase(p) & candResource(r) & priorMatch(p, r) & priorMatchScore(p, r, s)
	add [hasPhrase(p)] * s * w_phrase_prior;
 
/* (sf3) There are some associations between POS tags of phase and types of mapped semantic item. */
weight w_pos_rt: PosTag x ResourceType -> Double+;
factor: for Int p, Int r, PosTag pt, ResourceType rt
	if candPhrase(p) & candResource(r) & phrasePosTag(p, pt) & resourceType(r, rt) & priorMatch(p, r)
	add [hasResource(p,r)] * w_pos_rt(pt, rt);
	
/* (sf8) If the triple pattern have query results, those semantic items should have corresponding relations. */
weight w_hastriple_relation: Double+;
factor: for Int r1, Int r2, Int r3, RelationRole rr1, RelationRole rr2 
	if candResource(r1) & candResource(r2) & candResource(r3) & hasQueryResult(r1, r2, r3, rr1, rr2)
	add [hasRelation(r1, r2, rr1) & hasRelation(r2, r3, rr2)] * w_hastriple_relation;	

	
/* hard formulas */
	
/* hf0 */	
factor: for Int p, Int r
	if candPhrase(p) & candResource(r) & !priorMatch(p, r): 
	!hasResource(p,r);	
	
/* (hf9)*/
factor: for Int r1, Int r2 if candResource(r1) & candResource(r2) & resourceType(r1, "Entity"): 
	 !hasRelation(r1, r2, "2_1");
factor: for Int r1, Int r2 if candResource(r1) & candResource(r2) & resourceType(r1, "Entity"): 
	 !hasRelation(r1, r2, "2_2");
	 
/* (fh10)*/
factor: for Int r1, Int r2 if candResource(r1) & candResource(r2) & resourceType(r1, "Class"): 
	 !hasRelation(r1, r2, "2_1");
factor: for Int r1, Int r2 if candResource(r1) & candResource(r2) & resourceType(r1, "Class"): 
	 !hasRelation(r1, r2, "2_2");	 

/* (fh11)*/
factor: for Int r1, Int r2 if candResource(r1) & candResource(r2) & resourceType(r2, "Entity"): 
	 !hasRelation(r1, r2, "1_2");
factor: for Int r1, Int r2 if candResource(r1) & candResource(r2) & resourceType(r2, "Entity"): 
	 !hasRelation(r1, r2, "2_2");	
	 
/* (fh12)*/
factor: for Int r1, Int r2 if candResource(r1) & candResource(r2) & resourceType(r2, "Class"): 
	 !hasRelation(r1, r2, "1_2");
factor: for Int r1, Int r2 if candResource(r1) & candResource(r2) & resourceType(r2, "Class"): 
	 !hasRelation(r1, r2, "2_2");
	
/* (hf13) ԴӦĹϵһ */
factor: for Int r1, Int r2, RelationRole rr if candResource(r1) & candResource(r2) & !isTypeCompatible(r1, r2, rr):
	!hasRelation(r1, r2, rr);
	

	
	