/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.feature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.regex.Pattern;
import org.maltparser.core.config.ConfigurationRegistry;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.FeatureException;
import org.maltparser.core.feature.FeatureVector;
import org.maltparser.core.feature.function.AddressFunction;
import org.maltparser.core.feature.function.FeatureFunction;
import org.maltparser.core.feature.function.Function;
import org.maltparser.core.feature.spec.SpecificationModel;
import org.maltparser.core.feature.spec.SpecificationSubModel;
import org.maltparser.core.feature.system.FeatureEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureModel
extends HashMap<String, FeatureVector> {
    public static final long serialVersionUID = 3256444702936019250L;
    protected SpecificationModel specModel;
    protected final ArrayList<AddressFunction> addressFunctionCache;
    protected final ArrayList<FeatureFunction> featureFunctionCache;
    protected ConfigurationRegistry registry;
    protected FeatureEngine featureEngine;
    protected FeatureVector mainFeatureVector = null;
    protected final Pattern splitPattern;

    public FeatureModel(SpecificationModel specModel, ConfigurationRegistry registry, FeatureEngine engine) throws MaltChainedException {
        this.setSpecModel(specModel);
        this.setRegistry(registry);
        this.setFeatureEngine(engine);
        this.addressFunctionCache = new ArrayList();
        this.featureFunctionCache = new ArrayList();
        this.splitPattern = Pattern.compile("\\(|\\)|\\[|\\]|,");
        for (SpecificationSubModel subModel : specModel) {
            FeatureVector fv = new FeatureVector(this, subModel);
            if (this.mainFeatureVector == null) {
                if (subModel.getSubModelName().equals("MAIN")) {
                    this.mainFeatureVector = fv;
                    continue;
                }
                this.mainFeatureVector = fv;
                this.put(subModel.getSubModelName(), fv);
                continue;
            }
            this.put(subModel.getSubModelName(), fv);
        }
    }

    public SpecificationModel getSpecModel() {
        return this.specModel;
    }

    public void setSpecModel(SpecificationModel specModel) {
        this.specModel = specModel;
    }

    public ArrayList<AddressFunction> getAddressFunctionCache() {
        return this.addressFunctionCache;
    }

    public ArrayList<FeatureFunction> getFeatureFunctionCache() {
        return this.featureFunctionCache;
    }

    public ConfigurationRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(ConfigurationRegistry registry) {
        this.registry = registry;
    }

    public FeatureEngine getFeatureEngine() {
        return this.featureEngine;
    }

    public void setFeatureEngine(FeatureEngine featureEngine) {
        this.featureEngine = featureEngine;
    }

    public FeatureVector getMainFeatureVector() {
        return this.mainFeatureVector;
    }

    public FeatureVector getFeatureVector(String subModelName) {
        return (FeatureVector)this.get(subModelName);
    }

    public void update() throws MaltChainedException {
        int i;
        int n = this.addressFunctionCache.size();
        for (i = 0; i < n; ++i) {
            this.addressFunctionCache.get(i).update();
        }
        n = this.featureFunctionCache.size();
        for (i = 0; i < n; ++i) {
            this.featureFunctionCache.get(i).update();
        }
    }

    public void update(Object[] arguments) throws MaltChainedException {
        int i;
        int n = this.addressFunctionCache.size();
        for (i = 0; i < n; ++i) {
            this.addressFunctionCache.get(i).update(arguments);
        }
        n = this.featureFunctionCache.size();
        for (i = 0; i < n; ++i) {
            this.featureFunctionCache.get(i).update();
        }
    }

    public void updateCardinality() throws MaltChainedException {
        int n = this.featureFunctionCache.size();
        for (int i = 0; i < n; ++i) {
            this.featureFunctionCache.get(i).updateCardinality();
        }
    }

    public FeatureFunction identifyFeature(String spec) throws MaltChainedException {
        String[] items = this.splitPattern.split(spec);
        Stack<Object> objects = new Stack<Object>();
        for (int i = items.length - 1; i >= 0; --i) {
            if (items[i].trim().length() == 0) continue;
            objects.push(items[i].trim());
        }
        this.identifyFeatureFunction(objects);
        if (objects.size() != 1 || !(objects.peek() instanceof FeatureFunction) || objects.peek() instanceof AddressFunction) {
            throw new FeatureException("The feature specification '" + spec + "' were not recognized properly. ");
        }
        return (FeatureFunction)objects.pop();
    }

    protected void identifyFeatureFunction(Stack<Object> objects) throws MaltChainedException {
        Function function = this.featureEngine.newFunction(objects.peek().toString(), this.registry);
        if (function != null) {
            objects.pop();
            if (!objects.isEmpty()) {
                this.identifyFeatureFunction(objects);
            }
            this.initializeFunction(function, objects);
        } else if (!objects.isEmpty()) {
            Object o = objects.pop();
            if (!objects.isEmpty()) {
                this.identifyFeatureFunction(objects);
            }
            objects.push(o);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initializeFunction(Function function, Stack<Object> objects) throws MaltChainedException {
        int index;
        Class<?>[] paramTypes = function.getParameterTypes();
        Object[] arguments = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i] == Integer.class) {
                if (!(objects.peek() instanceof String)) throw new FeatureException("Could not cast string to integer. ");
                try {
                    objects.push(Integer.parseInt((String)objects.pop()));
                }
                catch (NumberFormatException e) {
                    throw new FeatureException("Could not cast string to integer. ", e);
                }
            } else if (paramTypes[i] == Double.class) {
                if (!(objects.peek() instanceof String)) throw new FeatureException("Could not cast string to double. ");
                try {
                    objects.push(Double.parseDouble((String)objects.pop()));
                }
                catch (NumberFormatException e) {
                    throw new FeatureException("Could not cast string to double. ", e);
                }
            } else if (paramTypes[i] == Boolean.class) {
                if (!(objects.peek() instanceof String)) throw new FeatureException("Could not cast string to boolean. ");
                objects.push(Boolean.parseBoolean((String)objects.pop()));
            }
            if (!paramTypes[i].isInstance(objects.peek())) {
                throw new FeatureException("The function cannot be initialized. (" + paramTypes[i] + ")(" + objects.peek() + ")(" + function + ")(" + objects + ")");
            }
            arguments[i] = objects.pop();
        }
        function.initialize(arguments);
        if (function instanceof AddressFunction) {
            index = this.getAddressFunctionCache().indexOf(function);
            if (index != -1) {
                function = this.getAddressFunctionCache().get(index);
            } else {
                this.getAddressFunctionCache().add((AddressFunction)function);
            }
        } else if (function instanceof FeatureFunction) {
            index = this.getFeatureFunctionCache().indexOf(function);
            if (index != -1) {
                function = this.getFeatureFunctionCache().get(index);
            } else {
                this.getFeatureFunctionCache().add((FeatureFunction)function);
            }
        }
        objects.push(function);
    }

    @Override
    public String toString() {
        return this.specModel.toString();
    }
}

