/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.properties.order;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.comparators.NumberComparator;
import babel.content.eqclasses.phrases.Phrase;
import babel.content.eqclasses.properties.Property;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class PhraseContext
extends Property {
    protected Random m_rand = null;
    protected double m_keepProb = 1.0;
    protected HashMap<Phrase, Integer> m_before = new HashMap();
    protected HashMap<Phrase, Integer> m_after = new HashMap();
    protected HashMap<Phrase, Integer> m_outOfOrder = new HashMap();
    protected HashSet<Phrase> m_all = new HashSet();

    public PhraseContext() {
    }

    public PhraseContext(double keepProb) {
        this();
        this.m_keepProb = keepProb;
        this.m_rand = new Random(1L);
    }

    public void addBefore(Phrase phrase) {
        if (this.m_keepProb == 1.0 || this.keep()) {
            Integer num = this.m_before.get(phrase);
            this.m_before.put(phrase, num == null ? 1 : num + 1);
            this.m_all.add(phrase);
        }
    }

    public void addAfter(Phrase phrase) {
        if (this.m_keepProb == 1.0 || this.keep()) {
            Integer num = this.m_after.get(phrase);
            this.m_after.put(phrase, num == null ? 1 : num + 1);
            this.m_all.add(phrase);
        }
    }

    public void addOutOfOrder(Phrase phrase) {
        if (this.m_keepProb == 1.0 || this.keep()) {
            Integer num = this.m_outOfOrder.get(phrase);
            this.m_outOfOrder.put(phrase, num == null ? 1 : num + 1);
            this.m_all.add(phrase);
        }
    }

    public boolean hasAnywhere(Phrase phrase) {
        return this.m_all.contains(phrase);
    }

    public Set<Phrase> getAll() {
        return this.m_all;
    }

    public Map<Phrase, Integer> getBefore() {
        return this.m_before;
    }

    public Map<Phrase, Integer> getAfter() {
        return this.m_after;
    }

    public Map<Phrase, Integer> getDiscontinuous() {
        return this.m_outOfOrder;
    }

    public int beforeCount(Phrase phrase) {
        return this.m_before.containsKey(phrase) ? this.m_before.get(phrase) : 0;
    }

    public int afterCount(Phrase phrase) {
        return this.m_after.containsKey(phrase) ? this.m_after.get(phrase) : 0;
    }

    public int outOfOrderCount(Phrase phrase) {
        return this.m_outOfOrder.containsKey(phrase) ? this.m_outOfOrder.get(phrase) : 0;
    }

    @Override
    public String persistToString() {
        assert (false) : "Not implemented";
        return null;
    }

    @Override
    public void unpersistFromString(EquivalenceClass eq, String str) throws Exception {
        assert (false) : "Not implemented";
    }

    public void pruneMostFreq(int keepBefore, int keepAfter, int keepDisc) {
        int i;
        LinkedList phraseList;
        if (keepBefore >= 0 && keepBefore < this.m_before.size()) {
            phraseList = new LinkedList(this.m_before.keySet());
            Collections.sort(phraseList, new NumberComparator(true));
            i = keepBefore;
            while (i < phraseList.size()) {
                this.m_before.remove(phraseList.get(i));
                ++i;
            }
        }
        if (keepAfter >= 0 && keepAfter < this.m_after.size()) {
            phraseList = new LinkedList(this.m_after.keySet());
            Collections.sort(phraseList, new NumberComparator(true));
            i = keepAfter;
            while (i < phraseList.size()) {
                this.m_after.remove(phraseList.get(i));
                ++i;
            }
        }
        if (keepDisc >= 0 && keepDisc < this.m_outOfOrder.size()) {
            phraseList = new LinkedList(this.m_outOfOrder.keySet());
            Collections.sort(phraseList, new NumberComparator(true));
            i = keepDisc;
            while (i < phraseList.size()) {
                this.m_outOfOrder.remove(phraseList.get(i));
                ++i;
            }
        }
        this.m_all.clear();
        this.m_all.addAll((Collection<Phrase>)this.m_before.keySet());
        this.m_all.addAll((Collection<Phrase>)this.m_after.keySet());
        this.m_all.addAll((Collection<Phrase>)this.m_outOfOrder.keySet());
    }

    protected synchronized boolean keep() {
        return this.m_rand.nextDouble() < this.m_keepProb;
    }
}

