///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <fstream>
#include <sstream>
#include <getopt.h>

#include "nl-randvar.h"
#include "nl-dtree.h"
#include "nl-iomacros.h"
#include "nl-refrv.h"

//char psX[]="";
//char psUscUscUsc[]="___";

//#define NOISY 1

#define THRESHOLD 0.0

////////////////////////////////////////////////////////////////////////////////
//
//  Random Variables
//
////////////////////////////////////////////////////////////////////////////////

#include "TextObsVars.h"
#include "PCFGLangModel-vecmd-rlnclust.h"
#include "TextObsModel-svs.h"

////////////////////////////////////////////////////////////////////////////////
//
//  helper classes, functions
//
////////////////////////////////////////////////////////////////////////////////

bool NOISY = false;
bool VERYNOISY = false;
bool PROBS = false;
bool EVALVEC = false;

typedef Joint2DRV<C,X> CX;



////////////////////////////////////////////////////////////////////////////////
//
//  Main Function (pipe data input)
//
////////////////////////////////////////////////////////////////////////////////

static struct option long_options[] = {
  {"forest", optional_argument, 0, 'f'},
  {"help", no_argument, 0, 'h'},
  {"verbose", no_argument, 0, 'v'},
  {0, 0, 0, 0} };

void printUsage(char* progname) {
  fprintf(stderr,"Usage: cat <RAW_FILE> | %s [OPTIONS]... [MODEL_FILE1] [MODEL_FILE2] ...\n",progname);
  fprintf(stderr,"Runs the speech recognition system on RAW_FILE using the models in MODEL_FILE1, 2, etc.\n");
  fprintf(stderr," System variable Settings:\n");
  fprintf(stderr,"  -h, --help\t\tPrint this message\n");
  fprintf(stderr,"  -v, --verbose=TRUE\n");
  fprintf(stderr,"  -V, --veryverbose=TRUE\n");
}

int main (int nArgs, char* argv[]) {

  MModel  modM;
  LModel  modL;
  GEuModel modGEgivGE;
  GErModel modGEr;
  GEModel  modGE;
  LCModel modLC;
  IModel  modI;
  //HModel  modH;
  XModel  modX;
  //OModel  mO;

  // Parse command-line options
  char* progname = strdup(argv[0]);
  int option_index = 0;
  char opt;
  while( (opt = getopt_long(nArgs, argv, "hvV", long_options, &option_index)) != -1 ) {
    switch(opt) {
    case 'h': printUsage(progname); exit(0);
    case 'v': NOISY=true; break;
    case 'V': VERYNOISY=true; NOISY=true; break;
    default: break;
    }
  }

  for ( int a=optind; a<nArgs; a++ ) {
    FILE* pf = fopen(argv[a],"r"); assert(pf);                                // READ MODEL FILE
    cerr << "Loading model \'" << argv[a] << "\'...\n";
    int c=' '; int i=0; int line=1; Array<char*> aps(100); String sBuff(1000);   // Lookahead/ctrs/buffers
    CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                   // Get to first record
    while ( c!=-1 && c!='\0' && c!='\5' ) {                                      // For each record
      CONSUME_STR ( pf, c, (c!='\n' && c!='\0' && c!='\5'), sBuff, i, line );    //   Consume line
      String sBuff2(sBuff); StringInput si(sBuff2.c_array());
      if ( !( sBuff[0]=='#' ||                                                   //   Accept comments/fields
	      si>>"M_SIZE ">>M_SIZE>>"\0"!=NULL ||
              si>>modX>>"\0"!=NULL ||
	      si>>"LC ">>modLC>>"\0"!=NULL || 
	      si>>"Gr ">>modGEr>>"\0"!=NULL || 
	      si>>"G ">>modGE>>"\0"!=NULL || 
	      si>>"HW ">>modI>>"\0"!=NULL || 
	      //si>>"H ">>modH>>"\0"!=NULL ||
	      si>>"M ">>modM>>"\0"!=NULL || 
	      si>>"L ">>modL>>"\0"!=NULL ) )
	cerr<<"\nERROR: can't parse \'"<<sBuff<<"\' in line "<<line<<"\n\n";
      CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                 //   Consume whitespace
      if ( line%100000==0 ) cerr<<"  "<<line<<" lines read...\n";                //   Progress for big models
    }
    cerr << "Model \'" << argv[a] << "\' loaded.\n";
  }

  ifstream fin;
  List<CX>  lcx;
  string   sLine;
  int ctr=0;
  IndexedVector N_1 ( M_SIZE.getInt(), 1, Prob(1.0) );

  // Read in each line...
  while ( getline(cin,sLine) ) {
    ctr++;
    if (NOISY) cerr << ctr ;

    // Read in each word...
    stringstream ss(stringstream::in|stringstream::out);
    lcx=List<CX>();
    ss<<sLine;
    for (string sc,sx; ss>>sc>>sx; ) {
      if (NOISY) cerr << " "<< sc << "#" << sx;
      lcx.add() = CX( C(sc.c_str()), X(sx.c_str()) );
    }

    if (NOISY) cerr << endl;

    // Find Vectors for appropriate POSs...
    int i=0;
    Listed(CX)* pcx;

    cout << "{ ";
    for ( pcx=(lcx).getFirst(); !lcx.isEmpty(); pcx=lcx.getFirst() ) {  //destructive (w/ pop)

      CX& cx = *pcx;
      if ( NOISY )
        cerr << "word " << pcx->second.getString() << endl;
      GE ge;

      IndexedVector v(M_SIZE.getInt(),1);
      for ( I vi; vi<M_SIZE.getInt(); ++vi ) {
        v.set(vi,I()) = /* iudlclclc->second.get(vi,0) * */ modX.getProb(cx.second,cx.first,vi);
      }
      Evec e = v;
      if ( VERYNOISY )
        cerr << "pos match! " << i << " " << i+1 << " " << cx.first << " -> " << pcx->second.getString()
             << " = " << e.infnorm() << endl;
      cout << "["<<e<<"]"<<((lcx.getCard()==1)?"":",");

      // update for next iteration
      i++;
      lcx.pop();
    }
    cout << " },\n";


  }


}

