#    This is a part of the "NED", a dependency parsing evaluation tool developed
#    in the Hebrew University by Roy Schwartz, Omri Abend, Roi Reichart and Ari Rappoport.
#    Copyright (C) 2011  Omri Abend, Roi Reichart and Ari Rappoport
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    If you have any questions, feel free to contact us in:
#    roys02@cs.huji.ac.il, omria01@cs.huji.ac.il, roiri@csail.mit.edu
#
#    Please read the README file for more details.
package POS;

use strict;

use constant LEFT => 0;
use constant RIGHT => 1;

use constant CONTINUE => 0;
use constant STOP => 1;

use constant NO_KIDS => 0;
use constant HAS_KIDS => 1;


use constant ROOT => -1;


sub new {
	my ($class, $pos, $index, $contend_model, $dep_model, $punctRE) = @_;

	my $self = {};

	if (defined $index) {
		$self->{POS} = $pos;
		$self->{WORD} = undef;
		$self->{LEFT} = [];
		$self->{INDEX} = $index;
		$self->{RIGHT} = [];
		$self->{PARENT} = undef;
		$self->{CONTEND} = $contend_model;
		$self->{DEP} = $dep_model;
		$self->{PUNCT} = $punctRE;
	} else {
		# copy ctor
		$self->{POS} = $pos->{POS};
		$self->{WORD} = $pos->{WORD};
		my @left = @{$pos->{LEFT}};
		$self->{INDEX} = $pos->{INDEX};
		$self->{LEFT} = \@left;
		my @right = @{$pos->{RIGHT}};
		$self->{RIGHT} = \@right;
		$self->{PARENT} = $pos->{PARENT};
		$self->{CONTEND} = $pos->{CONTEND};
		$self->{DEP} = $pos->{DEP};
		$self->{PUNCT} = $pos->{PUNCT};
	}

	bless($self, $class);

	return $self;
}

sub index($) {
	my $self = shift;

	return $self->{INDEX};
}

sub word {
	my $self = shift;
	my $word = shift;

	if (defined $word) {
		$self->{WORD} = $word;
	}

	return $self->{WORD};
}


sub addLeft($$) {
	my $self = shift;
	my $left = shift;

	push(@{$self->{LEFT}}, $left);
}


sub addRight($$) {
	my $self = shift;
	my $right = shift;

	push(@{$self->{RIGHT}}, $right);
}

sub rightKids($) {
	my $self = shift;
	return $self->{RIGHT};
}

sub leftKids($) {
	my $self = shift;
	return $self->{LEFT};
}

sub setParent($$) {
	my $self = shift;
	my $parent = shift;

	$self->{PARENT} = $parent;
}



sub data($) {
	my $self = shift;

	return $self->{POS};
}

sub parent($) {
	my $self = shift;

	return $self->{PARENT};
}


sub isRoot($) {
	my $self = shift;

	return $self->parent() == ROOT;
}


sub toString($) {
	my $self = shift;

	my $parent = $self->parent();

	unless (defined $parent) {
		$parent = "?";
	}

	return $self->data()." $parent";
}

sub isPunct {
	my $self = shift;
	my $punct = shift;

	if (defined $punct) {
		return $self =~ /^$punct$/;
	} else {
		return $self->data() =~ /^$self->{PUNCT}$/;
	}
}



1;