/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import matetools.is2.data.DataFES;
import matetools.is2.data.Parse;
import matetools.is2.parser.Closed;
import matetools.is2.parser.Extractor;
import matetools.is2.parser.Open;
import matetools.is2.parser.ParallelDecoder;
import matetools.is2.parser.ParallelRearrange;
import matetools.is2.parser.Parser;

public final class Decoder {
    public static final boolean TRAINING = true;
    public static long timeDecotder;
    public static long timeRearrange;
    public static float NON_PROJECTIVITY_THRESHOLD;
    public static ExecutorService executerService;
    public static List<Integer> labXindexs;
    public static List<Integer> labReverseXindexs;

    static {
        NON_PROJECTIVITY_THRESHOLD = 0.3f;
        executerService = Executors.newFixedThreadPool(Parser.THREADS);
    }

    private Decoder() {
    }

    public static Parse decode(short[] pos, DataFES x1, boolean projective, boolean training, double[][] additionalWeightForTrap) throws InterruptedException {
        int j;
        DataFES x = new DataFES(x1.len, x1.typesLen);
        int i = 0;
        while (i < x.len) {
            x.pl[i] = Arrays.copyOf(x1.pl[i], x.len);
            j = 0;
            while (j < x.len) {
                x.lab[i][j] = Arrays.copyOf(x1.lab[i][j], (int)x.typesLen);
                int k = 0;
                while (k < x.len) {
                    if (x1.gra[i][j][k] != null) {
                        x.gra[i][j][k] = Arrays.copyOf(x1.gra[i][j][k], x1.gra[i][j][k].length);
                    }
                    if (x1.sib[i][j][k] != null) {
                        x.sib[i][j][k] = Arrays.copyOf(x1.sib[i][j][k], x1.sib[i][j][k].length);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < additionalWeightForTrap.length) {
            j = 0;
            while (j < additionalWeightForTrap.length) {
                for (int labXindex : labXindexs) {
                    float[] fArray = x.lab[i][j];
                    int n = labXindex;
                    fArray[n] = (float)((double)fArray[n] + additionalWeightForTrap[i][j]);
                }
                for (int labReverseXindex : labReverseXindexs) {
                    float[] fArray = x.lab[i][j];
                    int n = labReverseXindex;
                    fArray[n] = (float)((double)fArray[n] + additionalWeightForTrap[j][i]);
                }
                ++j;
            }
            ++i;
        }
        return Decoder.decode(pos, x, projective, training);
    }

    public static Parse decode(short[] pos, DataFES x, boolean projective, boolean training) throws InterruptedException {
        long ts = System.nanoTime();
        if (executerService.isShutdown()) {
            executerService = Executors.newCachedThreadPool();
        }
        int n = pos.length;
        Open[][][][] O = new Open[n][n][2][];
        Closed[][][][] C2 = new Closed[n][n][2][];
        ArrayList<ParallelDecoder> pe = new ArrayList<ParallelDecoder>();
        int i = 0;
        while (i < Parser.THREADS) {
            pe.add(new ParallelDecoder(pos, x, O, C2, n));
            ++i;
        }
        int k = 1;
        while (k < n) {
            int s = 0;
            while (s < n) {
                short t = (short)(s + k);
                if (t >= n) break;
                ParallelDecoder.add((short)s, t);
                s = (short)(s + 1);
            }
            executerService.invokeAll(pe);
            k = (short)(k + 1);
        }
        float bestSpanScore = Float.NEGATIVE_INFINITY;
        Closed bestSpan = null;
        int m = 1;
        while (m < n) {
            if (C2[0][n - 1][1][m].p > bestSpanScore) {
                bestSpanScore = C2[0][n - 1][1][m].p;
                bestSpan = C2[0][n - 1][1][m];
            }
            ++m;
        }
        Parse out = new Parse(pos.length);
        bestSpan.create(out);
        out.heads[0] = -1;
        out.labels[0] = 0;
        timeDecotder += System.nanoTime() - ts;
        ts = System.nanoTime();
        if (!projective) {
            Decoder.rearrange(pos, out.heads, out.labels, x, training);
        }
        timeRearrange += System.nanoTime() - ts;
        return out;
    }

    /*
     * Unable to fully structure code
     */
    public static void rearrange(short[] pos, short[] heads, short[] labs, DataFES x, boolean training) throws InterruptedException {
        threads = pos.length > Parser.THREADS ? Parser.THREADS : pos.length;
        wh = -1;
        nPar = -1;
        nType = -1;
        pe = new ArrayList<ParallelRearrange>();
        while (true) {
            isChild = new boolean[heads.length][heads.length];
            i = 1;
            l1 = 1;
            ** GOTO lbl15
            {
                isChild[l1][i] = true;
                do {
                    if ((l1 = heads[l1]) != -1) continue block1;
                    l1 = ++i;
lbl15:
                    // 2 sources

                } while (i < heads.length);
            }
            max = -Infinityf;
            p = Extractor.encode3(pos, heads, labs, x);
            pe.clear();
            i = 0;
            while (i < threads) {
                pe.add(new ParallelRearrange(isChild, pos, x, heads, labs));
                ++i;
            }
            ch = 1;
            while (ch < heads.length) {
                pa = 0;
                while (pa < heads.length) {
                    if (ch != pa && pa != heads[ch] && !isChild[ch][pa]) {
                        ParallelRearrange.add(p, (short)ch, pa);
                    }
                    pa = (short)(pa + 1);
                }
                ++ch;
            }
            Decoder.executerService.invokeAll(pe);
            for (ParallelRearrange.PA rp : ParallelRearrange.order) {
                if (!(max < rp.max)) continue;
                max = rp.max;
                wh = rp.wh;
                nPar = rp.nPar;
                nType = rp.nType;
            }
            ParallelRearrange.order.clear();
            if (max <= Decoder.NON_PROJECTIVITY_THRESHOLD) break;
            heads[wh] = nPar;
            labs[wh] = nType;
        }
    }

    public static String getInfo() {
        return "Decoder non-projectivity threshold: " + NON_PROJECTIVITY_THRESHOLD;
    }
}

