/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.data;

import java.util.BitSet;

public class Parse
implements Comparable<Parse> {
    public short[] heads;
    public short[] labels;
    public double f1;

    public Parse() {
    }

    public Parse(int i) {
        this.heads = new short[i];
        this.labels = new short[i];
    }

    public Parse(short[] heads2, short[] types2, float p_new) {
        this.heads = new short[heads2.length];
        this.labels = new short[types2.length];
        System.arraycopy(heads2, 0, this.heads, 0, this.heads.length);
        System.arraycopy(types2, 0, this.labels, 0, this.labels.length);
        this.f1 = p_new;
    }

    public Parse(String parse, float p_new) {
        this.signature2parse(parse);
        this.f1 = p_new;
    }

    public void signature2parse(String parse) {
        int p = 0;
        this.heads = new short[parse.length() / 2];
        this.labels = new short[this.heads.length];
        int k = 0;
        while (k < this.heads.length) {
            this.heads[k] = (short)parse.charAt(p++);
            this.labels[k] = (short)parse.charAt(p++);
            ++k;
        }
    }

    public Parse clone() {
        Parse p = new Parse();
        p.heads = new short[this.heads.length];
        p.labels = new short[this.labels.length];
        System.arraycopy(this.heads, 0, p.heads, 0, this.heads.length);
        System.arraycopy(this.labels, 0, p.labels, 0, this.labels.length);
        p.f1 = this.f1;
        return p;
    }

    public boolean checkTree() {
        BitSet set = new BitSet(this.heads.length);
        set.set(0);
        return this.checkTree(set, 0);
    }

    private boolean checkTree(BitSet set, int h) {
        int i = 0;
        while (i < this.heads.length) {
            if (this.heads[i] == h) {
                if (!set.get(i)) {
                    this.checkTree(set, i);
                }
                set.set(i);
            }
            ++i;
        }
        i = 0;
        while (i < this.heads.length) {
            if (!set.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int k = 0;
        while (k < this.heads.length) {
            b.append(k).append(" ").append(String.valueOf(this.heads[k]) + " ").append(this.labels[k]).append("\n");
            ++k;
        }
        return b.toString();
    }

    @Override
    public int compareTo(Parse o) {
        if (this.f1 == o.f1) {
            return this.signature().compareTo(o.signature());
        }
        return this.f1 < o.f1 ? 1 : (this.f1 == o.f1 ? 0 : -1);
    }

    public String signature() {
        StringBuilder b = new StringBuilder(this.heads.length * 2);
        int k = 0;
        while (k < this.heads.length) {
            b.append((char)this.heads[k]).append((char)this.labels[k]);
            ++k;
        }
        return b.toString();
    }

    public StringBuilder signatureSB() {
        StringBuilder b = new StringBuilder(this.heads.length * 2);
        int k = 0;
        while (k < this.heads.length) {
            b.append((char)this.heads[k]).append((char)this.labels[k]);
            ++k;
        }
        return b;
    }
}

